/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SharedThreadLocalRandomInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("shared.thread.local.random.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SharedThreadLocalRandomInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("shared.thread.local.random.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SharedThreadLocalRandomInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SharedThreadLocalRandomVisitor();
    }

    private static class SharedThreadLocalRandomVisitor
    extends BaseInspectionVisitor {
        private SharedThreadLocalRandomVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"current".equals(name)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor(aClass, "java.util.concurrent.ThreadLocalRandom")) {
                return;
            }
            if (SharedThreadLocalRandomVisitor.isArgumentToMethodCall(expression)) {
                this.registerMethodCallError(expression, new Object[0]);
            } else {
                PsiCodeBlock context;
                PsiVariable variable = SharedThreadLocalRandomVisitor.assignedToVariable(expression);
                if (variable instanceof PsiField) {
                    this.registerMethodCallError(expression, new Object[0]);
                } else if (variable instanceof PsiLocalVariable && (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) || VariableAccessUtils.variableIsUsedInInnerClass(variable, context))) {
                    this.registerMethodCallError(expression, new Object[0]);
                }
            }
        }

        private static boolean isArgumentToMethodCall(PsiExpression expression) {
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses(expression);
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            return grandParent instanceof PsiMethodCallExpression;
        }

        private static PsiVariable assignedToVariable(PsiMethodCallExpression expression) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType(expression, PsiParenthesizedExpression.class);
            if (parent instanceof PsiVariable) {
                return (PsiVariable)parent;
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (!PsiTreeUtil.isAncestor(rhs, expression, false)) {
                return null;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)target;
        }
    }
}

