/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ProcessWaitFor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.process.ProcessWaitFor");
    private static final MultiMap<Process, Consumer<Integer>> ourQueue = new MultiMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        MultiMap<Process, Consumer<Integer>> multiMap = ourQueue;
        synchronized (multiMap) {
            Iterator<Process> iterator = ourQueue.keySet().iterator();
            while (iterator.hasNext()) {
                Process process = iterator.next();
                try {
                    int value = process.exitValue();
                    Collection<Consumer<Integer>> callbacks = ourQueue.get(process);
                    for (Consumer<Integer> callback : callbacks) {
                        callback.consume(value);
                    }
                    iterator.remove();
                }
                catch (IllegalThreadStateException value) {
                }
                catch (RuntimeException e) {
                    LOG.debug(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attach(@NotNull Process process, @NotNull Consumer<Integer> callback) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/ProcessWaitFor", "attach"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/execution/process/ProcessWaitFor", "attach"));
        }
        MultiMap<Process, Consumer<Integer>> multiMap = ourQueue;
        synchronized (multiMap) {
            ourQueue.putValue(process, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detach(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/ProcessWaitFor", "detach"));
        }
        MultiMap<Process, Consumer<Integer>> multiMap = ourQueue;
        synchronized (multiMap) {
            ourQueue.remove(process);
        }
    }

    static {
        BaseOSProcessHandler.ExecutorServiceHolder.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    ProcessWaitFor.processQueue();
                    TimeoutUtil.sleep(50L);
                }
            }
        });
    }
}

