/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileStubImpl<T extends PsiFile>
extends StubBase<T>
implements PsiFileStub<T> {
    public static final IStubFileElementType TYPE = new IStubFileElementType(Language.ANY);
    private volatile T myFile;
    private volatile String myInvalidationReason;
    private volatile PsiFileStub[] myStubRoots;

    public PsiFileStubImpl(T file) {
        super(null, null);
        this.myFile = file;
    }

    @Override
    public T getPsi() {
        return this.myFile;
    }

    @Override
    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/stubs/PsiFileStubImpl", "setPsi"));
        }
        this.myFile = psi;
    }

    public void clearPsi(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/stubs/PsiFileStubImpl", "clearPsi"));
        }
        this.myInvalidationReason = reason;
        this.myFile = null;
    }

    @Nullable
    public String getInvalidationReason() {
        return this.myInvalidationReason;
    }

    @Override
    public IStubElementType getStubType() {
        return null;
    }

    @Override
    public IStubFileElementType getType() {
        return TYPE;
    }

    @Override
    @NotNull
    public PsiFileStub[] getStubRoots() {
        PsiFileStub[] psiFileStubArray;
        if (this.myStubRoots != null) {
            psiFileStubArray = this.myStubRoots;
        } else {
            PsiFileStub[] psiFileStubArray2 = new PsiFileStub[1];
            psiFileStubArray = psiFileStubArray2;
            psiFileStubArray2[0] = this;
        }
        if (psiFileStubArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
        }
        return psiFileStubArray;
    }

    public void setStubRoots(@NotNull PsiFileStub[] roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/psi/stubs/PsiFileStubImpl", "setStubRoots"));
        }
        if (roots.length == 0) {
            Logger.getInstance(this.getClass()).error("Incorrect psi file stub roots count" + this + "," + this.getStubType());
        }
        this.myStubRoots = roots;
    }
}

