/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayLevel {
    private static final Map<HighlightSeverity, HighlightDisplayLevel> ourMap = new HashMap<HighlightSeverity, HighlightDisplayLevel>();
    public static final HighlightDisplayLevel GENERIC_SERVER_ERROR_OR_WARNING = new HighlightDisplayLevel(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING));
    public static final HighlightDisplayLevel ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR, HighlightDisplayLevel.createErrorIcon());
    public static final HighlightDisplayLevel WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.WARNINGS_ATTRIBUTES));
    private static final Icon DO_NOT_SHOW_KEY = HighlightDisplayLevel.createIconByKey(TextAttributesKey.createTextAttributesKey("DO_NOT_SHOW"));
    public static final HighlightDisplayLevel DO_NOT_SHOW = new HighlightDisplayLevel(HighlightSeverity.INFORMATION, DO_NOT_SHOW_KEY);
    @Deprecated
    public static final HighlightDisplayLevel INFO = new HighlightDisplayLevel(HighlightSeverity.INFO, DO_NOT_SHOW.getIcon());
    public static final HighlightDisplayLevel WEAK_WARNING = new HighlightDisplayLevel(HighlightSeverity.WEAK_WARNING, HighlightDisplayLevel.createIconByKey(CodeInsightColors.WEAK_WARNING_ATTRIBUTES));
    public static final HighlightDisplayLevel NON_SWITCHABLE_ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR);
    private Icon myIcon;
    private final HighlightSeverity mySeverity;

    @NotNull
    private static Icon createErrorIcon() {
        SingleColorIcon singleColorIcon = new SingleColorIcon(CodeInsightColors.ERRORS_ATTRIBUTES){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                IconUtil.colorize(AllIcons.General.InspectionsError, this.getColor()).paintIcon(c, g, x, y);
            }
        };
        if (singleColorIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "createErrorIcon"));
        }
        return singleColorIcon;
    }

    @Nullable
    public static HighlightDisplayLevel find(String name) {
        for (Map.Entry<HighlightSeverity, HighlightDisplayLevel> entry : ourMap.entrySet()) {
            HighlightSeverity severity = entry.getKey();
            HighlightDisplayLevel displayLevel = entry.getValue();
            if (!Comparing.strEqual(severity.getName(), name)) continue;
            return displayLevel;
        }
        return null;
    }

    public static HighlightDisplayLevel find(HighlightSeverity severity) {
        return ourMap.get(severity);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity, @NotNull Icon icon) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeHighlighting/HighlightDisplayLevel", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeHighlighting/HighlightDisplayLevel", "<init>"));
        }
        this(severity);
        this.myIcon = icon;
        ourMap.put(this.mySeverity, this);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeHighlighting/HighlightDisplayLevel", "<init>"));
        }
        this.mySeverity = severity;
    }

    public String toString() {
        return this.mySeverity.toString();
    }

    @NotNull
    public String getName() {
        String string = this.mySeverity.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "getName"));
        }
        return string;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "getSeverity"));
        }
        return highlightSeverity;
    }

    public static void registerSeverity(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey key, @Nullable Icon icon) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeHighlighting/HighlightDisplayLevel", "registerSeverity"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeHighlighting/HighlightDisplayLevel", "registerSeverity"));
        }
        Icon severityIcon = icon != null ? icon : HighlightDisplayLevel.createIconByKey(key);
        HighlightDisplayLevel level = ourMap.get(severity);
        if (level == null) {
            new HighlightDisplayLevel(severity, severityIcon);
        } else {
            level.myIcon = severityIcon;
        }
    }

    public static int getEmptyIconDim() {
        return JBUI.scale(14);
    }

    public static Icon createIconByKey(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeHighlighting/HighlightDisplayLevel", "createIconByKey"));
        }
        return new SingleColorIcon(key);
    }

    @NotNull
    public static Icon createIconByMask(Color renderColor) {
        MyColorIcon myColorIcon = new MyColorIcon(HighlightDisplayLevel.getEmptyIconDim(), renderColor);
        if (myColorIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "createIconByMask"));
        }
        return myColorIcon;
    }

    public static class SingleColorIcon
    implements Icon,
    ColoredIcon {
        private final TextAttributesKey myKey;

        public SingleColorIcon(@NotNull TextAttributesKey key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeHighlighting/HighlightDisplayLevel$SingleColorIcon", "<init>"));
            }
            this.myKey = key;
        }

        @Override
        @NotNull
        public Color getColor() {
            Color color = ObjectUtils.notNull(this.getColorInner(), JBColor.GRAY);
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel$SingleColorIcon", "getColor"));
            }
            return color;
        }

        @Nullable
        public Color getColorInner() {
            EditorColorsManager manager = EditorColorsManager.getInstance();
            if (manager != null) {
                TextAttributes attributes = manager.getGlobalScheme().getAttributes(this.myKey);
                Color stripe = attributes.getErrorStripeColor();
                if (stripe != null) {
                    return stripe;
                }
                return attributes.getEffectColor();
            }
            TextAttributes defaultAttributes = this.myKey.getDefaultAttributes();
            if (defaultAttributes == null) {
                defaultAttributes = TextAttributes.ERASE_MARKER;
            }
            return defaultAttributes.getErrorStripeColor();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.getColor());
            g.fillRect(x + 2, y + 2, 10, 10);
        }

        @Override
        public int getIconWidth() {
            return HighlightDisplayLevel.getEmptyIconDim();
        }

        @Override
        public int getIconHeight() {
            return HighlightDisplayLevel.getEmptyIconDim();
        }
    }

    public static interface ColoredIcon {
        public Color getColor();
    }

    private static class MyColorIcon
    extends ColorIcon
    implements ColoredIcon {
        public MyColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeHighlighting/HighlightDisplayLevel$MyColorIcon", "<init>"));
            }
            super(size, color);
        }

        @Override
        public Color getColor() {
            return this.getIconColor();
        }
    }
}

