/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ThrowableConvertor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesManager<T extends Scheme, E extends ExternalizableScheme> {
    @NotNull
    public abstract Collection<E> loadSchemes();

    public abstract void addNewScheme(@NotNull T var1, boolean var2);

    public abstract void clearAllSchemes();

    @NotNull
    public abstract List<T> getAllSchemes();

    @Nullable
    public abstract T findSchemeByName(@NotNull String var1);

    public abstract void save();

    public abstract void setCurrentSchemeName(@Nullable String var1);

    @Nullable
    public abstract T getCurrentScheme();

    public abstract void removeScheme(@NotNull T var1);

    @NotNull
    public abstract Collection<String> getAllSchemeNames();

    public abstract File getRootDirectory();

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor, @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/intellij/openapi/options/SchemesManager", "loadBundledScheme"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/options/SchemesManager", "loadBundledScheme"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/openapi/options/SchemesManager", "loadBundledScheme"));
        }
    }

    public void setSchemes(@NotNull List<T> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/openapi/options/SchemesManager", "setSchemes"));
        }
        this.setSchemes(schemes, null);
    }

    public void setSchemes(@NotNull List<T> schemes, @Nullable Condition<T> removeCondition) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/openapi/options/SchemesManager", "setSchemes"));
        }
    }
}

