/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;

public class ExpressionReturnValue
implements ReturnValue {
    private final PsiExpression myExpression;

    public ExpressionReturnValue(PsiExpression expression) {
        this.myExpression = expression;
    }

    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof ExpressionReturnValue)) {
            return false;
        }
        return PsiEquivalenceUtil.areElementsEquivalent(this.myExpression, ((ExpressionReturnValue)other).myExpression);
    }

    @Override
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(methodCallExpression.getProject()).getElementFactory();
        CodeStyleManager styleManager = CodeStyleManager.getInstance(methodCallExpression.getProject());
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)elementFactory.createStatementFromText("x = y();", null);
        expressionStatement = (PsiExpressionStatement)styleManager.reformat(expressionStatement);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expressionStatement.getExpression();
        assignmentExpression.getLExpression().replace(this.getExpression());
        assignmentExpression.getRExpression().replace(methodCallExpression);
        return expressionStatement;
    }
}

