/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.IteratorUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IteratorNextDoesNotThrowNoSuchElementExceptionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("IteratorNextCanNotThrowNoSuchElementException" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection", "getID"));
        }
        return "IteratorNextCanNotThrowNoSuchElementException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("iterator.next.does.not.throw.nosuchelementexception.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IteratorNextDoesNotThrowNoSuchElementExceptionVisitor();
    }

    private static class CalledMethodsVisitor
    extends JavaRecursiveElementVisitor {
        private boolean noSuchElementExceptionThrown = false;

        private CalledMethodsVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.noSuchElementExceptionThrown) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiElement method = methodExpression.resolve();
            if (method == null) {
                return;
            }
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(method);
            for (PsiType psiType : exceptions) {
                if (!psiType.equalsToText("java.util.NoSuchElementException")) continue;
                this.noSuchElementExceptionThrown = true;
            }
        }

        public boolean isNoSuchElementExceptionThrown() {
            return this.noSuchElementExceptionThrown;
        }
    }

    private static class IteratorNextDoesNotThrowNoSuchElementExceptionVisitor
    extends BaseInspectionVisitor {
        private IteratorNextDoesNotThrowNoSuchElementExceptionVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/bugs/IteratorNextDoesNotThrowNoSuchElementExceptionInspection$IteratorNextDoesNotThrowNoSuchElementExceptionVisitor", "visitMethod"));
            }
            if (!MethodUtils.methodMatches(method, "java.util.Iterator", null, "next", new PsiType[0])) {
                return;
            }
            for (PsiType psiType : ExceptionUtil.getThrownExceptions(method)) {
                if (!psiType.equalsToText("java.util.NoSuchElementException")) continue;
                return;
            }
            if (IteratorUtils.containsCallToIteratorNext(method, null, false)) {
                return;
            }
            CalledMethodsVisitor visitor = new CalledMethodsVisitor();
            method.accept(visitor);
            if (visitor.isNoSuchElementExceptionThrown()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

