/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class RecordStoreResourceInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("RecordStoreOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/RecordStoreResourceInspection", "getID"));
        }
        return "RecordStoreOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("recordstore.opened.not.safely.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/RecordStoreResourceInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/RecordStoreResourceInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RecordStoreResourceVisitor();
    }

    private static class CloseVisitor
    extends JavaRecursiveElementVisitor {
        private boolean containsClose = false;
        private final PsiVariable objectToClose;

        private CloseVisitor(PsiVariable objectToClose) {
            this.objectToClose = objectToClose;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/j2me/RecordStoreResourceInspection$CloseVisitor", "visitElement"));
            }
            if (!this.containsClose) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/j2me/RecordStoreResourceInspection$CloseVisitor", "visitMethodCallExpression"));
            }
            if (this.containsClose) {
                return;
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String closeStore = "closeRecordStore";
            if (!"closeRecordStore".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)((Object)qualifier)).resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.objectToClose)) {
                this.containsClose = true;
            }
        }

        public boolean containsStreamClose() {
            return this.containsClose;
        }
    }

    private static class RecordStoreResourceVisitor
    extends BaseInspectionVisitor {
        private RecordStoreResourceVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/RecordStoreResourceInspection$RecordStoreResourceVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!RecordStoreResourceVisitor.isRecordStoreFactoryMethod(expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiAssignmentExpression)) {
                this.registerError((PsiElement)expression, expression);
                return;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)((Object)lhs)).resolve();
            if (!(referent instanceof PsiVariable)) {
                return;
            }
            PsiVariable boundVariable = (PsiVariable)referent;
            PsiElement currentContext = expression;
            while (true) {
                PsiTryStatement tryStatement;
                if ((tryStatement = PsiTreeUtil.getParentOfType(currentContext, PsiTryStatement.class)) == null) {
                    this.registerError((PsiElement)expression, expression);
                    return;
                }
                if (RecordStoreResourceVisitor.resourceIsOpenedInTryAndClosedInFinally(tryStatement, expression, boundVariable)) {
                    return;
                }
                currentContext = tryStatement;
            }
        }

        private static boolean resourceIsOpenedInTryAndClosedInFinally(PsiTryStatement tryStatement, PsiExpression lhs, PsiVariable boundVariable) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return false;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return false;
            }
            if (!PsiTreeUtil.isAncestor(tryBlock, lhs, true)) {
                return false;
            }
            return RecordStoreResourceVisitor.containsResourceClose(finallyBlock, boundVariable);
        }

        private static boolean containsResourceClose(PsiCodeBlock finallyBlock, PsiVariable boundVariable) {
            CloseVisitor visitor = new CloseVisitor(boundVariable);
            finallyBlock.accept(visitor);
            return visitor.containsStreamClose();
        }

        private static boolean isRecordStoreFactoryMethod(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/RecordStoreResourceInspection$RecordStoreResourceVisitor", "isRecordStoreFactoryMethod"));
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String openStore = "openRecordStore";
            if (!"openRecordStore".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            String recordStore = "javax.microedition.rms.RecordStore";
            return "javax.microedition.rms.RecordStore".equals(className);
        }
    }
}

