/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceChecker {
    private EquivalenceChecker() {
    }

    public static boolean statementsAreEquivalent(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        if (statement1 == null) {
            return statement2 == null;
        }
        if (statement2 == null) {
            return false;
        }
        if (statement1.getClass() != statement2.getClass()) {
            PsiStatement[] statements;
            PsiBlockStatement blockStatement;
            if (statement1 instanceof PsiBlockStatement && !(statement2 instanceof PsiBlockStatement)) {
                blockStatement = (PsiBlockStatement)statement1;
                statements = blockStatement.getCodeBlock().getStatements();
                if (statements.length != 1) {
                    return false;
                }
                statement1 = statements[0];
            } else if (!(statement1 instanceof PsiBlockStatement) && statement2 instanceof PsiBlockStatement) {
                blockStatement = (PsiBlockStatement)statement2;
                statements = blockStatement.getCodeBlock().getStatements();
                if (statements.length != 1) {
                    return false;
                }
                statement2 = statements[0];
            } else {
                return false;
            }
            if (statement1.getClass() != statement2.getClass()) {
                return false;
            }
        }
        if (statement1 instanceof PsiAssertStatement) {
            return EquivalenceChecker.assertStatementsAreEquivalent((PsiAssertStatement)statement1, (PsiAssertStatement)statement2);
        }
        if (statement1 instanceof PsiBlockStatement) {
            return EquivalenceChecker.blockStatementsAreEquivalent((PsiBlockStatement)statement1, (PsiBlockStatement)statement2);
        }
        if (statement1 instanceof PsiBreakStatement) {
            return EquivalenceChecker.breakStatementsAreEquivalent((PsiBreakStatement)statement1, (PsiBreakStatement)statement2);
        }
        if (statement1 instanceof PsiContinueStatement) {
            return EquivalenceChecker.continueStatementsAreEquivalent((PsiContinueStatement)statement1, (PsiContinueStatement)statement2);
        }
        if (statement1 instanceof PsiDeclarationStatement) {
            return EquivalenceChecker.declarationStatementsAreEquivalent((PsiDeclarationStatement)statement1, (PsiDeclarationStatement)statement2);
        }
        if (statement1 instanceof PsiDoWhileStatement) {
            return EquivalenceChecker.doWhileStatementsAreEquivalent((PsiDoWhileStatement)statement1, (PsiDoWhileStatement)statement2);
        }
        if (statement1 instanceof PsiEmptyStatement) {
            return true;
        }
        if (statement1 instanceof PsiExpressionListStatement) {
            return EquivalenceChecker.expressionListStatementsAreEquivalent((PsiExpressionListStatement)statement1, (PsiExpressionListStatement)statement2);
        }
        if (statement1 instanceof PsiExpressionStatement) {
            return EquivalenceChecker.expressionStatementsAreEquivalent((PsiExpressionStatement)statement1, (PsiExpressionStatement)statement2);
        }
        if (statement1 instanceof PsiForStatement) {
            return EquivalenceChecker.forStatementsAreEquivalent((PsiForStatement)statement1, (PsiForStatement)statement2);
        }
        if (statement1 instanceof PsiForeachStatement) {
            return EquivalenceChecker.forEachStatementsAreEquivalent((PsiForeachStatement)statement1, (PsiForeachStatement)statement2);
        }
        if (statement1 instanceof PsiIfStatement) {
            return EquivalenceChecker.ifStatementsAreEquivalent((PsiIfStatement)statement1, (PsiIfStatement)statement2);
        }
        if (statement1 instanceof PsiLabeledStatement) {
            return EquivalenceChecker.labeledStatementsAreEquivalent((PsiLabeledStatement)statement1, (PsiLabeledStatement)statement2);
        }
        if (statement1 instanceof PsiReturnStatement) {
            return EquivalenceChecker.returnStatementsAreEquivalent((PsiReturnStatement)statement1, (PsiReturnStatement)statement2);
        }
        if (statement1 instanceof PsiSwitchStatement) {
            return EquivalenceChecker.switchStatementsAreEquivalent((PsiSwitchStatement)statement1, (PsiSwitchStatement)statement2);
        }
        if (statement1 instanceof PsiSwitchLabelStatement) {
            return EquivalenceChecker.switchLabelStatementsAreEquivalent((PsiSwitchLabelStatement)statement1, (PsiSwitchLabelStatement)statement2);
        }
        if (statement1 instanceof PsiSynchronizedStatement) {
            return EquivalenceChecker.synchronizedStatementsAreEquivalent((PsiSynchronizedStatement)statement1, (PsiSynchronizedStatement)statement2);
        }
        if (statement1 instanceof PsiThrowStatement) {
            return EquivalenceChecker.throwStatementsAreEquivalent((PsiThrowStatement)statement1, (PsiThrowStatement)statement2);
        }
        if (statement1 instanceof PsiTryStatement) {
            return EquivalenceChecker.tryStatementsAreEquivalent((PsiTryStatement)statement1, (PsiTryStatement)statement2);
        }
        if (statement1 instanceof PsiWhileStatement) {
            return EquivalenceChecker.whileStatementsAreEquivalent((PsiWhileStatement)statement1, (PsiWhileStatement)statement2);
        }
        String text1 = statement1.getText();
        String text2 = statement2.getText();
        return text1.equals(text2);
    }

    private static boolean declarationStatementsAreEquivalent(@NotNull PsiDeclarationStatement statement1, @NotNull PsiDeclarationStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "declarationStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "declarationStatementsAreEquivalent"));
        }
        PsiElement[] elements1 = statement1.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars1 = new ArrayList<PsiLocalVariable>(elements1.length);
        for (PsiElement anElement : elements1) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars1.add((PsiLocalVariable)anElement);
        }
        PsiElement[] elements2 = statement2.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars2 = new ArrayList<PsiLocalVariable>(elements2.length);
        for (PsiElement anElement : elements2) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars2.add((PsiLocalVariable)anElement);
        }
        int size = vars1.size();
        if (size != vars2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            PsiLocalVariable var2;
            PsiLocalVariable var1 = (PsiLocalVariable)vars1.get(i);
            if (EquivalenceChecker.localVariablesAreEquivalent(var1, var2 = (PsiLocalVariable)vars2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean localVariablesAreEquivalent(@NotNull PsiLocalVariable localVariable1, @NotNull PsiLocalVariable localVariable2) {
        PsiType type2;
        if (localVariable1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localVariable1", "com/siyeh/ig/psiutils/EquivalenceChecker", "localVariablesAreEquivalent"));
        }
        if (localVariable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localVariable2", "com/siyeh/ig/psiutils/EquivalenceChecker", "localVariablesAreEquivalent"));
        }
        PsiType type1 = localVariable1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = localVariable2.getType())) {
            return false;
        }
        String name1 = localVariable1.getName();
        String name2 = localVariable2.getName();
        if (name1 == null) {
            return name2 == null;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        PsiExpression initializer1 = localVariable1.getInitializer();
        PsiExpression initializer2 = localVariable2.getInitializer();
        return EquivalenceChecker.expressionsAreEquivalent(initializer1, initializer2);
    }

    private static boolean tryStatementsAreEquivalent(@NotNull PsiTryStatement statement1, @NotNull PsiTryStatement statement2) {
        PsiParameter[] catchParameters2;
        PsiParameter[] catchParameters1;
        PsiCodeBlock[] catchBlocks2;
        PsiCodeBlock finallyBlock2;
        PsiCodeBlock tryBlock2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "tryStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "tryStatementsAreEquivalent"));
        }
        PsiCodeBlock tryBlock1 = statement1.getTryBlock();
        if (!EquivalenceChecker.codeBlocksAreEquivalent(tryBlock1, tryBlock2 = statement2.getTryBlock())) {
            return false;
        }
        PsiCodeBlock finallyBlock1 = statement1.getFinallyBlock();
        if (!EquivalenceChecker.codeBlocksAreEquivalent(finallyBlock1, finallyBlock2 = statement2.getFinallyBlock())) {
            return false;
        }
        PsiCodeBlock[] catchBlocks1 = statement1.getCatchBlocks();
        if (catchBlocks1.length != (catchBlocks2 = statement2.getCatchBlocks()).length) {
            return false;
        }
        for (int i = 0; i < catchBlocks2.length; ++i) {
            if (EquivalenceChecker.codeBlocksAreEquivalent(catchBlocks1[i], catchBlocks2[i])) continue;
            return false;
        }
        PsiResourceList resourceList1 = statement1.getResourceList();
        PsiResourceList resourceList2 = statement2.getResourceList();
        if (resourceList1 != null) {
            if (resourceList2 == null) {
                return false;
            }
            if (resourceList1.getResourceVariablesCount() != resourceList2.getResourceVariablesCount()) {
                return false;
            }
            List<PsiResourceVariable> resourceVariables1 = resourceList1.getResourceVariables();
            List<PsiResourceVariable> resourceVariables2 = resourceList2.getResourceVariables();
            int size = resourceVariables1.size();
            for (int i1 = 0; i1 < size; ++i1) {
                PsiResourceVariable variable2;
                PsiResourceVariable variable1 = resourceVariables1.get(i1);
                if (EquivalenceChecker.localVariablesAreEquivalent(variable1, variable2 = resourceVariables2.get(i1))) continue;
                return false;
            }
        } else if (resourceList2 != null) {
            return false;
        }
        if ((catchParameters1 = statement1.getCatchBlockParameters()).length != (catchParameters2 = statement2.getCatchBlockParameters()).length) {
            return false;
        }
        for (int i = 0; i < catchParameters2.length; ++i) {
            if (EquivalenceChecker.parametersAreEquivalent(catchParameters2[i], catchParameters1[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean parametersAreEquivalent(@NotNull PsiParameter parameter1, @NotNull PsiParameter parameter2) {
        PsiType type2;
        if (parameter1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter1", "com/siyeh/ig/psiutils/EquivalenceChecker", "parametersAreEquivalent"));
        }
        if (parameter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter2", "com/siyeh/ig/psiutils/EquivalenceChecker", "parametersAreEquivalent"));
        }
        PsiType type1 = parameter1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = parameter2.getType())) {
            return false;
        }
        String name1 = parameter1.getName();
        String name2 = parameter2.getName();
        if (name1 == null) {
            return name2 == null;
        }
        return name1.equals(name2);
    }

    public static boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        String type1Text = type1.getCanonicalText();
        String type2Text = type2.getCanonicalText();
        return type1Text.equals(type2Text);
    }

    private static boolean whileStatementsAreEquivalent(@NotNull PsiWhileStatement statement1, @NotNull PsiWhileStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "whileStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "whileStatementsAreEquivalent"));
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forStatementsAreEquivalent(@NotNull PsiForStatement statement1, @NotNull PsiForStatement statement2) {
        PsiStatement update2;
        PsiStatement initialization2;
        PsiExpression condition2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "forStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "forStatementsAreEquivalent"));
        }
        PsiExpression condition1 = statement1.getCondition();
        if (!EquivalenceChecker.expressionsAreEquivalent(condition1, condition2 = statement2.getCondition())) {
            return false;
        }
        PsiStatement initialization1 = statement1.getInitialization();
        if (!EquivalenceChecker.statementsAreEquivalent(initialization1, initialization2 = statement2.getInitialization())) {
            return false;
        }
        PsiStatement update1 = statement1.getUpdate();
        if (!EquivalenceChecker.statementsAreEquivalent(update1, update2 = statement2.getUpdate())) {
            return false;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forEachStatementsAreEquivalent(@NotNull PsiForeachStatement statement1, @NotNull PsiForeachStatement statement2) {
        PsiExpression value2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "forEachStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "forEachStatementsAreEquivalent"));
        }
        PsiExpression value1 = statement1.getIteratedValue();
        if (!EquivalenceChecker.expressionsAreEquivalent(value1, value2 = statement2.getIteratedValue())) {
            return false;
        }
        PsiParameter parameter1 = statement1.getIterationParameter();
        PsiParameter parameter2 = statement1.getIterationParameter();
        String name1 = parameter1.getName();
        if (name1 == null) {
            return parameter2.getName() == null;
        }
        if (!name1.equals(parameter2.getName())) {
            return false;
        }
        PsiType type1 = parameter1.getType();
        if (!type1.equals(parameter2.getType())) {
            return false;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean switchStatementsAreEquivalent(@NotNull PsiSwitchStatement statement1, @NotNull PsiSwitchStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "switchStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "switchStatementsAreEquivalent"));
        }
        PsiExpression switchExpression1 = statement1.getExpression();
        PsiExpression swithcExpression2 = statement2.getExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(switchExpression1, swithcExpression2) && EquivalenceChecker.codeBlocksAreEquivalent(body1, body2);
    }

    private static boolean doWhileStatementsAreEquivalent(@NotNull PsiDoWhileStatement statement1, @NotNull PsiDoWhileStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "doWhileStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "doWhileStatementsAreEquivalent"));
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean assertStatementsAreEquivalent(@NotNull PsiAssertStatement statement1, @NotNull PsiAssertStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "assertStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "assertStatementsAreEquivalent"));
        }
        PsiExpression condition1 = statement1.getAssertCondition();
        PsiExpression condition2 = statement2.getAssertCondition();
        PsiExpression description1 = statement1.getAssertDescription();
        PsiExpression description2 = statement2.getAssertDescription();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(description1, description2);
    }

    private static boolean synchronizedStatementsAreEquivalent(@NotNull PsiSynchronizedStatement statement1, @NotNull PsiSynchronizedStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "synchronizedStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "synchronizedStatementsAreEquivalent"));
        }
        PsiExpression lock1 = statement1.getLockExpression();
        PsiExpression lock2 = statement2.getLockExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(lock1, lock2) && EquivalenceChecker.codeBlocksAreEquivalent(body1, body2);
    }

    private static boolean blockStatementsAreEquivalent(@NotNull PsiBlockStatement statement1, @NotNull PsiBlockStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "blockStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "blockStatementsAreEquivalent"));
        }
        PsiCodeBlock block1 = statement1.getCodeBlock();
        PsiCodeBlock block2 = statement2.getCodeBlock();
        return EquivalenceChecker.codeBlocksAreEquivalent(block1, block2);
    }

    private static boolean breakStatementsAreEquivalent(@NotNull PsiBreakStatement statement1, @NotNull PsiBreakStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "breakStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "breakStatementsAreEquivalent"));
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    private static boolean continueStatementsAreEquivalent(@NotNull PsiContinueStatement statement1, @NotNull PsiContinueStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "continueStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "continueStatementsAreEquivalent"));
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    private static boolean switchLabelStatementsAreEquivalent(@NotNull PsiSwitchLabelStatement statement1, @NotNull PsiSwitchLabelStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "switchLabelStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "switchLabelStatementsAreEquivalent"));
        }
        if (statement1.isDefaultCase()) {
            return statement2.isDefaultCase();
        }
        if (statement2.isDefaultCase()) {
            return false;
        }
        PsiExpression caseExpression1 = statement1.getCaseValue();
        PsiExpression caseExpression2 = statement2.getCaseValue();
        return EquivalenceChecker.expressionsAreEquivalent(caseExpression1, caseExpression2);
    }

    private static boolean labeledStatementsAreEquivalent(@NotNull PsiLabeledStatement statement1, @NotNull PsiLabeledStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "labeledStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "labeledStatementsAreEquivalent"));
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    public static boolean codeBlocksAreEquivalent(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        if (block1 == null && block2 == null) {
            return true;
        }
        if (block1 == null || block2 == null) {
            return false;
        }
        PsiStatement[] statements1 = block1.getStatements();
        PsiStatement[] statements2 = block2.getStatements();
        if (statements2.length != statements1.length) {
            return false;
        }
        for (int i = 0; i < statements2.length; ++i) {
            if (EquivalenceChecker.statementsAreEquivalent(statements2[i], statements1[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean ifStatementsAreEquivalent(@NotNull PsiIfStatement statement1, @NotNull PsiIfStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "ifStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "ifStatementsAreEquivalent"));
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement thenBranch1 = statement1.getThenBranch();
        PsiStatement thenBranch2 = statement2.getThenBranch();
        PsiStatement elseBranch1 = statement1.getElseBranch();
        PsiStatement elseBranch2 = statement2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(thenBranch1, thenBranch2) && EquivalenceChecker.statementsAreEquivalent(elseBranch1, elseBranch2);
    }

    private static boolean expressionStatementsAreEquivalent(@NotNull PsiExpressionStatement statement1, @NotNull PsiExpressionStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "expressionStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "expressionStatementsAreEquivalent"));
        }
        PsiExpression expression1 = statement1.getExpression();
        PsiExpression expression2 = statement2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalent(expression1, expression2);
    }

    private static boolean returnStatementsAreEquivalent(@NotNull PsiReturnStatement statement1, @NotNull PsiReturnStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "returnStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "returnStatementsAreEquivalent"));
        }
        PsiExpression returnValue1 = statement1.getReturnValue();
        PsiExpression returnValue2 = statement2.getReturnValue();
        return EquivalenceChecker.expressionsAreEquivalent(returnValue1, returnValue2);
    }

    private static boolean throwStatementsAreEquivalent(@NotNull PsiThrowStatement statement1, @NotNull PsiThrowStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "throwStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "throwStatementsAreEquivalent"));
        }
        PsiExpression exception1 = statement1.getException();
        PsiExpression exception2 = statement2.getException();
        return EquivalenceChecker.expressionsAreEquivalent(exception1, exception2);
    }

    private static boolean expressionListStatementsAreEquivalent(@NotNull PsiExpressionListStatement statement1, @NotNull PsiExpressionListStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/siyeh/ig/psiutils/EquivalenceChecker", "expressionListStatementsAreEquivalent"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/siyeh/ig/psiutils/EquivalenceChecker", "expressionListStatementsAreEquivalent"));
        }
        PsiExpressionList expressionList1 = statement1.getExpressionList();
        PsiExpression[] expressions1 = expressionList1.getExpressions();
        PsiExpressionList expressionList2 = statement2.getExpressionList();
        PsiExpression[] expressions2 = expressionList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(expressions1, expressions2);
    }

    public static boolean expressionsAreEquivalent(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        expression1 = ParenthesesUtils.stripParentheses(expression1);
        expression2 = ParenthesesUtils.stripParentheses(expression2);
        if (expression1 == null) {
            return expression2 == null;
        }
        if (expression2 == null) {
            return false;
        }
        if (expression1.getClass() != expression2.getClass()) {
            return false;
        }
        if (expression1 instanceof PsiThisExpression) {
            return true;
        }
        if (expression1 instanceof PsiSuperExpression) {
            return true;
        }
        if (expression1 instanceof PsiLiteralExpression) {
            return EquivalenceChecker.literalExpressionsAreEquivalent((PsiLiteralExpression)expression1, (PsiLiteralExpression)expression2);
        }
        if (expression1 instanceof PsiClassObjectAccessExpression) {
            return EquivalenceChecker.classObjectAccessExpressionsAreEquivalent((PsiClassObjectAccessExpression)expression1, (PsiClassObjectAccessExpression)expression2);
        }
        if (expression1 instanceof PsiReferenceExpression) {
            return EquivalenceChecker.referenceExpressionsAreEquivalent((PsiReferenceExpression)expression1, (PsiReferenceExpression)expression2);
        }
        if (expression1 instanceof PsiMethodCallExpression) {
            return EquivalenceChecker.methodCallExpressionsAreEquivalent((PsiMethodCallExpression)expression1, (PsiMethodCallExpression)expression2);
        }
        if (expression1 instanceof PsiNewExpression) {
            return EquivalenceChecker.newExpressionsAreEquivalent((PsiNewExpression)expression1, (PsiNewExpression)expression2);
        }
        if (expression1 instanceof PsiArrayInitializerExpression) {
            return EquivalenceChecker.arrayInitializerExpressionsAreEquivalent((PsiArrayInitializerExpression)expression1, (PsiArrayInitializerExpression)expression2);
        }
        if (expression1 instanceof PsiTypeCastExpression) {
            return EquivalenceChecker.typeCastExpressionsAreEquivalent((PsiTypeCastExpression)expression1, (PsiTypeCastExpression)expression2);
        }
        if (expression1 instanceof PsiArrayAccessExpression) {
            return EquivalenceChecker.arrayAccessExpressionsAreEquivalent((PsiArrayAccessExpression)expression2, (PsiArrayAccessExpression)expression1);
        }
        if (expression1 instanceof PsiPrefixExpression) {
            return EquivalenceChecker.prefixExpressionsAreEquivalent((PsiPrefixExpression)expression1, (PsiPrefixExpression)expression2);
        }
        if (expression1 instanceof PsiPostfixExpression) {
            return EquivalenceChecker.postfixExpressionsAreEquivalent((PsiPostfixExpression)expression1, (PsiPostfixExpression)expression2);
        }
        if (expression1 instanceof PsiPolyadicExpression) {
            return EquivalenceChecker.polyadicExpressionsAreEquivalent((PsiPolyadicExpression)expression1, (PsiPolyadicExpression)expression2);
        }
        if (expression1 instanceof PsiAssignmentExpression) {
            return EquivalenceChecker.assignmentExpressionsAreEquivalent((PsiAssignmentExpression)expression1, (PsiAssignmentExpression)expression2);
        }
        if (expression1 instanceof PsiConditionalExpression) {
            return EquivalenceChecker.conditionalExpressionsAreEquivalent((PsiConditionalExpression)expression1, (PsiConditionalExpression)expression2);
        }
        if (expression1 instanceof PsiInstanceOfExpression) {
            return EquivalenceChecker.instanceofExpressionsAreEquivalent((PsiInstanceOfExpression)expression1, (PsiInstanceOfExpression)expression2);
        }
        return false;
    }

    private static boolean literalExpressionsAreEquivalent(PsiLiteralExpression expression1, PsiLiteralExpression expression2) {
        Object value1 = expression1.getValue();
        Object value2 = expression2.getValue();
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    private static boolean classObjectAccessExpressionsAreEquivalent(PsiClassObjectAccessExpression expression1, PsiClassObjectAccessExpression expression2) {
        PsiTypeElement operand1 = expression1.getOperand();
        PsiTypeElement operand2 = expression2.getOperand();
        return EquivalenceChecker.typeElementsAreEquivalent(operand1, operand2);
    }

    private static boolean referenceExpressionsAreEquivalent(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
        PsiElement element1 = referenceExpression1.resolve();
        PsiElement element2 = referenceExpression2.resolve();
        if (element1 != null) {
            if (!element1.equals(element2)) {
                return false;
            }
        } else {
            return false;
        }
        if (element1 instanceof PsiMember) {
            PsiMember member1 = (PsiMember)element1;
            if (member1.hasModifierProperty("static")) {
                return true;
            }
            if (member1 instanceof PsiClass) {
                return true;
            }
        } else {
            return true;
        }
        PsiExpression qualifier1 = referenceExpression1.getQualifierExpression();
        PsiExpression qualifier2 = referenceExpression2.getQualifierExpression();
        if (qualifier1 != null && !(qualifier1 instanceof PsiThisExpression) && !(qualifier1 instanceof PsiSuperExpression)) {
            if (qualifier2 == null) {
                return false;
            }
            if (!EquivalenceChecker.expressionsAreEquivalent(qualifier1, qualifier2)) {
                return false;
            }
        } else if (qualifier2 != null && !(qualifier2 instanceof PsiThisExpression) && !(qualifier2 instanceof PsiSuperExpression)) {
            return false;
        }
        String text1 = referenceExpression1.getText();
        String text2 = referenceExpression2.getText();
        return text1.equals(text2);
    }

    private static boolean instanceofExpressionsAreEquivalent(PsiInstanceOfExpression instanceOfExpression1, PsiInstanceOfExpression instanceOfExpression2) {
        PsiExpression operand2;
        PsiExpression operand1 = instanceOfExpression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalent(operand1, operand2 = instanceOfExpression2.getOperand())) {
            return false;
        }
        PsiTypeElement typeElement1 = instanceOfExpression1.getCheckType();
        PsiTypeElement typeElement2 = instanceOfExpression2.getCheckType();
        return EquivalenceChecker.typeElementsAreEquivalent(typeElement1, typeElement2);
    }

    private static boolean typeElementsAreEquivalent(PsiTypeElement typeElement1, PsiTypeElement typeElement2) {
        if (typeElement1 == null) {
            return typeElement2 == null;
        }
        if (typeElement2 == null) {
            return false;
        }
        PsiType type1 = typeElement1.getType();
        PsiType type2 = typeElement2.getType();
        return EquivalenceChecker.typesAreEquivalent(type1, type2);
    }

    private static boolean methodCallExpressionsAreEquivalent(@NotNull PsiMethodCallExpression methodCallExpression1, @NotNull PsiMethodCallExpression methodCallExpression2) {
        PsiReferenceExpression methodExpression2;
        if (methodCallExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "methodCallExpressionsAreEquivalent"));
        }
        if (methodCallExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "methodCallExpressionsAreEquivalent"));
        }
        PsiReferenceExpression methodExpression1 = methodCallExpression1.getMethodExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent(methodExpression1, methodExpression2 = methodCallExpression2.getMethodExpression())) {
            return false;
        }
        PsiExpressionList argumentList1 = methodCallExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1.getExpressions();
        PsiExpressionList argumentList2 = methodCallExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static boolean newExpressionsAreEquivalent(@NotNull PsiNewExpression newExpression1, @NotNull PsiNewExpression newExpression2) {
        PsiExpression qualifier2;
        PsiArrayInitializerExpression arrayInitializer2;
        PsiExpression[] arrayDimensions2;
        if (newExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "newExpressionsAreEquivalent"));
        }
        if (newExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "newExpressionsAreEquivalent"));
        }
        PsiJavaCodeReferenceElement classReference1 = newExpression1.getClassReference();
        PsiJavaCodeReferenceElement classReference2 = newExpression2.getClassReference();
        if (classReference1 == null || classReference2 == null) {
            return false;
        }
        String text = classReference1.getText();
        if (!text.equals(classReference2.getText())) {
            return false;
        }
        PsiExpression[] arrayDimensions1 = newExpression1.getArrayDimensions();
        if (!EquivalenceChecker.expressionListsAreEquivalent(arrayDimensions1, arrayDimensions2 = newExpression2.getArrayDimensions())) {
            return false;
        }
        PsiArrayInitializerExpression arrayInitializer1 = newExpression1.getArrayInitializer();
        if (!EquivalenceChecker.expressionsAreEquivalent(arrayInitializer1, arrayInitializer2 = newExpression2.getArrayInitializer())) {
            return false;
        }
        PsiExpression qualifier1 = newExpression1.getQualifier();
        if (!EquivalenceChecker.expressionsAreEquivalent(qualifier1, qualifier2 = newExpression2.getQualifier())) {
            return false;
        }
        PsiExpressionList argumentList1 = newExpression1.getArgumentList();
        PsiExpression[] args1 = argumentList1 == null ? null : argumentList1.getExpressions();
        PsiExpressionList argumentList2 = newExpression2.getArgumentList();
        PsiExpression[] args2 = argumentList2 == null ? null : argumentList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static boolean arrayInitializerExpressionsAreEquivalent(@NotNull PsiArrayInitializerExpression arrayInitializerExpression1, @NotNull PsiArrayInitializerExpression arrayInitializerExpression2) {
        if (arrayInitializerExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayInitializerExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "arrayInitializerExpressionsAreEquivalent"));
        }
        if (arrayInitializerExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayInitializerExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "arrayInitializerExpressionsAreEquivalent"));
        }
        PsiExpression[] initializers1 = arrayInitializerExpression1.getInitializers();
        PsiExpression[] initializers2 = arrayInitializerExpression2.getInitializers();
        return EquivalenceChecker.expressionListsAreEquivalent(initializers1, initializers2);
    }

    private static boolean typeCastExpressionsAreEquivalent(@NotNull PsiTypeCastExpression typeCastExpression1, @NotNull PsiTypeCastExpression typeCastExpression2) {
        PsiTypeElement typeElement2;
        if (typeCastExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCastExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "typeCastExpressionsAreEquivalent"));
        }
        if (typeCastExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCastExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "typeCastExpressionsAreEquivalent"));
        }
        PsiTypeElement typeElement1 = typeCastExpression1.getCastType();
        if (!EquivalenceChecker.typeElementsAreEquivalent(typeElement1, typeElement2 = typeCastExpression2.getCastType())) {
            return false;
        }
        PsiExpression operand1 = typeCastExpression1.getOperand();
        PsiExpression operand2 = typeCastExpression2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean arrayAccessExpressionsAreEquivalent(@NotNull PsiArrayAccessExpression arrayAccessExpression1, @NotNull PsiArrayAccessExpression arrayAccessExpression2) {
        if (arrayAccessExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "arrayAccessExpressionsAreEquivalent"));
        }
        if (arrayAccessExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "arrayAccessExpressionsAreEquivalent"));
        }
        PsiExpression arrayExpression2 = arrayAccessExpression1.getArrayExpression();
        PsiExpression arrayExpression1 = arrayAccessExpression2.getArrayExpression();
        PsiExpression indexExpression2 = arrayAccessExpression1.getIndexExpression();
        PsiExpression indexExpression1 = arrayAccessExpression2.getIndexExpression();
        return EquivalenceChecker.expressionsAreEquivalent(arrayExpression2, arrayExpression1) && EquivalenceChecker.expressionsAreEquivalent(indexExpression2, indexExpression1);
    }

    private static boolean prefixExpressionsAreEquivalent(@NotNull PsiPrefixExpression prefixExpression1, @NotNull PsiPrefixExpression prefixExpression2) {
        if (prefixExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "prefixExpressionsAreEquivalent"));
        }
        if (prefixExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "prefixExpressionsAreEquivalent"));
        }
        IElementType tokenType1 = prefixExpression1.getOperationTokenType();
        if (!tokenType1.equals(prefixExpression2.getOperationTokenType())) {
            return false;
        }
        PsiExpression operand1 = prefixExpression1.getOperand();
        PsiExpression operand2 = prefixExpression2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean postfixExpressionsAreEquivalent(@NotNull PsiPostfixExpression postfixExpression1, @NotNull PsiPostfixExpression postfixExpression2) {
        if (postfixExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "postfixExpressionsAreEquivalent"));
        }
        if (postfixExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "postfixExpressionsAreEquivalent"));
        }
        IElementType tokenType1 = postfixExpression1.getOperationTokenType();
        if (!tokenType1.equals(postfixExpression2.getOperationTokenType())) {
            return false;
        }
        PsiExpression operand1 = postfixExpression1.getOperand();
        PsiExpression operand2 = postfixExpression2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean polyadicExpressionsAreEquivalent(@NotNull PsiPolyadicExpression polyadicExpression1, @NotNull PsiPolyadicExpression polyadicExpression2) {
        PsiExpression[] operands2;
        IElementType tokenType2;
        if (polyadicExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "polyadicExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "polyadicExpressionsAreEquivalent"));
        }
        if (polyadicExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "polyadicExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "polyadicExpressionsAreEquivalent"));
        }
        IElementType tokenType1 = polyadicExpression1.getOperationTokenType();
        if (!tokenType1.equals(tokenType2 = polyadicExpression2.getOperationTokenType())) {
            return false;
        }
        PsiExpression[] operands1 = polyadicExpression1.getOperands();
        if (operands1.length != (operands2 = polyadicExpression2.getOperands()).length) {
            return false;
        }
        int length = operands1.length;
        for (int i = 0; i < length; ++i) {
            if (EquivalenceChecker.expressionsAreEquivalent(operands1[i], operands2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignmentExpressionsAreEquivalent(@NotNull PsiAssignmentExpression assignmentExpression1, @NotNull PsiAssignmentExpression assignmentExpression2) {
        if (assignmentExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "assignmentExpressionsAreEquivalent"));
        }
        if (assignmentExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "assignmentExpressionsAreEquivalent"));
        }
        IElementType tokenType1 = assignmentExpression1.getOperationTokenType();
        if (!tokenType1.equals(assignmentExpression2.getOperationTokenType())) {
            return false;
        }
        PsiExpression lhs1 = assignmentExpression1.getLExpression();
        PsiExpression lhs2 = assignmentExpression2.getLExpression();
        PsiExpression rhs1 = assignmentExpression1.getRExpression();
        PsiExpression rhs2 = assignmentExpression2.getRExpression();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean conditionalExpressionsAreEquivalent(@NotNull PsiConditionalExpression conditionalExpression1, @NotNull PsiConditionalExpression conditionalExpression2) {
        if (conditionalExpression1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionalExpression1", "com/siyeh/ig/psiutils/EquivalenceChecker", "conditionalExpressionsAreEquivalent"));
        }
        if (conditionalExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionalExpression2", "com/siyeh/ig/psiutils/EquivalenceChecker", "conditionalExpressionsAreEquivalent"));
        }
        PsiExpression condition1 = conditionalExpression1.getCondition();
        PsiExpression condition2 = conditionalExpression2.getCondition();
        PsiExpression thenExpression1 = conditionalExpression1.getThenExpression();
        PsiExpression thenExpression2 = conditionalExpression2.getThenExpression();
        PsiExpression elseExpression1 = conditionalExpression1.getElseExpression();
        PsiExpression elseExpression2 = conditionalExpression2.getElseExpression();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(thenExpression1, thenExpression2) && EquivalenceChecker.expressionsAreEquivalent(elseExpression1, elseExpression2);
    }

    private static boolean expressionListsAreEquivalent(@Nullable PsiExpression[] expressions1, @Nullable PsiExpression[] expressions2) {
        if (expressions1 == null && expressions2 == null) {
            return true;
        }
        if (expressions1 == null || expressions2 == null) {
            return false;
        }
        if (expressions1.length != expressions2.length) {
            return false;
        }
        for (int i = 0; i < expressions1.length; ++i) {
            if (EquivalenceChecker.expressionsAreEquivalent(expressions1[i], expressions2[i])) continue;
            return false;
        }
        return true;
    }
}

