/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

class PersistentRangeMarker
extends RangeMarkerImpl {
    private int myStartLine;
    private int myStartColumn;
    private int myEndLine;
    private int myEndColumn;

    PersistentRangeMarker(DocumentEx document, int startOffset, int endOffset, boolean register) {
        super(document, startOffset, endOffset, register);
        this.storeLinesAndCols(null);
    }

    private void storeLinesAndCols(DocumentEvent e) {
        int endOffset;
        DocumentEx myDocument;
        int startOffset = this.getStartOffset();
        if (startOffset <= (myDocument = this.getDocument()).getTextLength()) {
            this.myStartLine = myDocument.getLineNumber(startOffset);
            this.myStartColumn = startOffset - myDocument.getLineStartOffset(this.myStartLine);
            if (this.myStartColumn < 0) {
                this.invalidate(e);
            }
        } else {
            this.invalidate(e);
        }
        if ((endOffset = this.getEndOffset()) <= myDocument.getTextLength()) {
            this.myEndLine = myDocument.getLineNumber(endOffset);
            this.myEndColumn = endOffset - myDocument.getLineStartOffset(this.myEndLine);
            if (this.myEndColumn < 0) {
                this.invalidate(e);
            }
        } else {
            this.invalidate(e);
        }
    }

    private boolean translateViaDiff(DocumentEventImpl event) {
        try {
            this.myStartLine = event.translateLineViaDiffStrict(this.myStartLine);
            DocumentEx document = this.getDocument();
            if (this.myStartLine < 0 || this.myStartLine >= document.getLineCount()) {
                this.invalidate(event);
            } else {
                int start = document.getLineStartOffset(this.myStartLine) + this.myStartColumn;
                if (start >= document.getTextLength()) {
                    return false;
                }
                this.setIntervalStart(start);
            }
            this.myEndLine = event.translateLineViaDiffStrict(this.myEndLine);
            if (this.myEndLine < 0 || this.myEndLine >= document.getLineCount()) {
                this.invalidate(event);
            } else {
                int end = document.getLineStartOffset(this.myEndLine) + this.myEndColumn;
                if (end > document.getTextLength()) {
                    return false;
                }
                this.setIntervalEnd(end);
            }
            return true;
        }
        catch (FilesTooBigForDiffException e) {
            return false;
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        boolean shouldTranslateViaDiff;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/PersistentRangeMarker", "changedUpdateImpl"));
        }
        DocumentEventImpl event = (DocumentEventImpl)e;
        boolean wasTranslated = shouldTranslateViaDiff = PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this);
        if (shouldTranslateViaDiff) {
            wasTranslated = this.translateViaDiff(event);
        }
        if (!wasTranslated) {
            super.changedUpdateImpl(e);
            if (this.isValid()) {
                this.storeLinesAndCols(e);
            }
        }
        if (this.intervalEnd() < this.intervalStart() || this.intervalEnd() > this.getDocument().getTextLength() || this.myEndLine < this.myStartLine || this.myStartLine == this.myEndLine && this.myEndColumn < this.myStartColumn || this.getDocument().getLineCount() < this.myEndLine) {
            this.invalidate(e);
        }
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn + (this.isGreedyToRight() ? "]" : ")");
    }
}

