/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final Stack<DfaValue> myStack;
    private final TLongHashSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfaVariableState> myVariableStates;
    private final Map<DfaVariableValue, DfaVariableState> myDefaultVariableStates;
    private final LinkedHashSet<DfaVariableValue> myUnknownVariables;
    private boolean myEphemeral;
    private LinkedHashSet<UnorderedPair<EqClass>> myCachedDistinctClassPairs;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    public DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myDefaultVariableStates = ContainerUtil.newTroveMap();
        this.myEqClasses = ContainerUtil.newArrayList();
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet();
        this.myVariableStates = ContainerUtil.newLinkedHashMap();
        this.myDistinctClasses = new TLongHashSet();
        this.myStack = new Stack();
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myDefaultVariableStates = toCopy.myDefaultVariableStates;
        this.myStack = new Stack<DfaValue>((Collection<DfaValue>)toCopy.myStack);
        this.myDistinctClasses = new TLongHashSet(toCopy.myDistinctClasses.toArray());
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet(toCopy.myUnknownVariables);
        this.myEqClasses = ContainerUtil.newArrayList(toCopy.myEqClasses);
        this.myVariableStates = ContainerUtil.newLinkedHashMap(toCopy.myVariableStates);
        this.myCachedDistinctClassPairs = toCopy.myCachedDistinctClassPairs;
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    public DfaValueFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public DfaMemoryStateImpl createCopy() {
        return new DfaMemoryStateImpl(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.equalsSuperficially(that) && this.equalsByUnknownVariables(that) && this.equalsByRelations(that) && this.equalsByVariableStates(that);
    }

    boolean equalsByUnknownVariables(DfaMemoryStateImpl that) {
        return this.myUnknownVariables.equals(that.myUnknownVariables);
    }

    Object getSuperficialKey() {
        return Pair.create(this.myEphemeral, this.myStack);
    }

    private boolean equalsSuperficially(DfaMemoryStateImpl other) {
        return this.myEphemeral == other.myEphemeral && this.myStack.equals(other.myStack);
    }

    boolean equalsByRelations(DfaMemoryStateImpl that) {
        return this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs());
    }

    boolean equalsByVariableStates(DfaMemoryStateImpl that) {
        return this.myVariableStates.equals(that.myVariableStates);
    }

    LinkedHashSet<UnorderedPair<EqClass>> getDistinctClassPairs() {
        if (this.myCachedDistinctClassPairs != null) {
            return this.myCachedDistinctClassPairs;
        }
        LinkedHashSet<UnorderedPair<EqClass>> result = ContainerUtil.newLinkedHashSet();
        for (long encodedPair : this.myDistinctClasses.toArray()) {
            result.add(new UnorderedPair<EqClass>(this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair)), this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair))));
        }
        this.myCachedDistinctClassPairs = result;
        return this.myCachedDistinctClassPairs;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet<EqClass> result = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = this.getPartialHashCode(true, true);
        this.myCachedHash = hash;
        return hash;
    }

    int getPartialHashCode(boolean unknowns, boolean varStates) {
        int hash = (this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode();
        if (varStates) {
            hash = hash * 31 + this.myVariableStates.hashCode();
        }
        if (unknowns && !this.myUnknownVariables.isEmpty()) {
            hash = hash * 31 + this.myUnknownVariables.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        if (this.myEphemeral) {
            result.append("ephemeral, ");
        }
        for (EqClass eqClass : this.getNonTrivialEqClasses()) {
            result.append(eqClass);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result.append("\n  distincts: ");
            ArrayList<String> distincts = new ArrayList<String>();
            for (UnorderedPair unorderedPair : this.getDistinctClassPairs()) {
                distincts.add("{" + unorderedPair.first + ", " + unorderedPair.second + "}");
            }
            Collections.sort(distincts);
            result.append(StringUtil.join(distincts, " "));
        }
        if (!this.myStack.isEmpty()) {
            result.append("\n  stack: ").append(StringUtil.join(this.myStack, ","));
        }
        if (!this.myVariableStates.isEmpty()) {
            result.append("\n  vars: ");
            for (Map.Entry entry : this.myVariableStates.entrySet()) {
                result.append("[").append(entry.getKey()).append("->").append(entry.getValue()).append("] ");
            }
        }
        if (!this.myUnknownVariables.isEmpty()) {
            result.append("\n  unknowns: ").append(new HashSet<DfaVariableValue>(this.myUnknownVariables));
        }
        result.append('>');
        return result.toString();
    }

    @Override
    public DfaValue pop() {
        this.myCachedHash = null;
        return this.myStack.pop();
    }

    @Override
    public DfaValue peek() {
        return this.myStack.peek();
    }

    @Override
    public void push(@NotNull DfaValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "push"));
        }
        this.myCachedHash = null;
        this.myStack.push(value);
    }

    @Override
    public void emptyStack() {
        this.myCachedHash = null;
        this.myStack.clear();
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value) {
        if (var == value) {
            return;
        }
        this.flushVariable(var);
        if (value instanceof DfaUnknownValue) {
            this.setVariableState(var, this.getVariableState(var).withNullable(false));
            return;
        }
        this.setVariableState(var, this.getVariableState(var).withValue(value));
        if (value instanceof DfaTypeValue) {
            this.setVariableState(var, this.getVariableState(var).withNullable(((DfaTypeValue)value).isNullable()));
            DfaRelationValue dfaInstanceof = this.myFactory.getRelationFactory().createRelation(var, value, JavaTokenType.INSTANCEOF_KEYWORD, false);
            if (((DfaTypeValue)value).isNotNull()) {
                this.applyCondition(dfaInstanceof);
            } else {
                this.applyInstanceofOrNull(dfaInstanceof);
            }
        } else {
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().createRelation(var, value, JavaTokenType.EQEQ, false);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value instanceof DfaVariableValue) {
                this.setVariableState(var, this.getVariableState((DfaVariableValue)value));
            }
        }
        if (this.getVariableState(var).isNotNull()) {
            this.applyCondition(this.compareToNull(var, true));
        }
    }

    @Nullable(value="for boxed values which can't be compared by ==")
    private Integer getOrCreateEqClassIndex(DfaValue dfaValue) {
        int i = this.getEqClassIndex(dfaValue);
        if (i != -1) {
            return i;
        }
        if (!DfaMemoryStateImpl.canBeInRelation(dfaValue) || !this.canBeReused(dfaValue) && !(((DfaBoxedValue)dfaValue).getWrappedValue() instanceof DfaConstValue)) {
            return null;
        }
        EqClass aClass = new EqClass(this.myFactory);
        aClass.add(dfaValue.getID());
        int freeIndex = this.myEqClasses.indexOf(null);
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, aClass);
            return freeIndex;
        }
        this.myEqClasses.add(aClass);
        return this.myEqClasses.size() - 1;
    }

    private static boolean canBeInRelation(DfaValue dfaValue) {
        DfaValue unwrapped = DfaMemoryStateImpl.unwrap(dfaValue);
        return unwrapped instanceof DfaVariableValue || unwrapped instanceof DfaConstValue;
    }

    @NotNull
    List<DfaValue> getEquivalentValues(@NotNull DfaValue dfaValue) {
        EqClass set;
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
        }
        int index = this.getEqClassIndex(dfaValue);
        EqClass eqClass = set = index == -1 ? null : this.myEqClasses.get(index);
        if (set == null) {
            List<DfaValue> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
            }
            return list;
        }
        List<DfaValue> list = set.getMemberValues();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
        }
        return list;
    }

    private boolean canBeNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "canBeNaN"));
        }
        for (DfaValue eq : this.getEquivalentValues(dfaValue)) {
            if (eq instanceof DfaBoxedValue) {
                eq = ((DfaBoxedValue)eq).getWrappedValue();
            }
            if (!(eq instanceof DfaConstValue) || DfaMemoryStateImpl.isNaN(eq)) continue;
            return false;
        }
        return dfaValue instanceof DfaVariableValue && TypeConversionUtil.isFloatOrDoubleType(((DfaVariableValue)dfaValue).getVariableType());
    }

    private boolean isEffectivelyNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "isEffectivelyNaN"));
        }
        for (DfaValue eqClass : this.getEquivalentValues(dfaValue)) {
            if (!DfaMemoryStateImpl.isNaN(eqClass)) continue;
            return true;
        }
        return false;
    }

    private int getEqClassIndex(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEqClassIndex"));
        }
        for (int i = 0; i < this.myEqClasses.size(); ++i) {
            EqClass aClass = this.myEqClasses.get(i);
            if (aClass == null || !aClass.contains(dfaValue.getID())) continue;
            if (!this.canBeReused(dfaValue) && aClass.size() > 1) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    private boolean canBeReused(DfaValue dfaValue) {
        if (dfaValue instanceof DfaBoxedValue) {
            DfaValue valueToWrap = ((DfaBoxedValue)dfaValue).getWrappedValue();
            if (valueToWrap instanceof DfaConstValue) {
                return DfaMemoryStateImpl.cacheable((DfaConstValue)valueToWrap);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                if (PsiType.BOOLEAN.equals(((DfaVariableValue)valueToWrap).getVariableType())) {
                    return true;
                }
                for (DfaValue value : this.getEquivalentValues(valueToWrap)) {
                    if (!(value instanceof DfaConstValue) || !DfaMemoryStateImpl.cacheable((DfaConstValue)value)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean cacheable(DfaConstValue dfaConstValue) {
        Object value = dfaConstValue.getValue();
        return DfaMemoryStateImpl.box(value) == DfaMemoryStateImpl.box(value);
    }

    private static Object box(Object value) {
        Constable newBoxedValue;
        if (value instanceof Integer) {
            newBoxedValue = (int)((Integer)value);
        } else if (value instanceof Byte) {
            newBoxedValue = (byte)((Byte)value);
        } else if (value instanceof Short) {
            newBoxedValue = (short)((Short)value);
        } else if (value instanceof Long) {
            newBoxedValue = (long)((Long)value);
        } else if (value instanceof Boolean) {
            newBoxedValue = (Boolean)value;
        } else if (value instanceof Character) {
            newBoxedValue = Character.valueOf(((Character)value).charValue());
        } else {
            return new Object();
        }
        return newBoxedValue;
    }

    private boolean uniteClasses(int c1Index, int c2Index) {
        int i;
        long[] distincts;
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        THashSet vars = ContainerUtil.newTroveSet();
        THashSet negatedVars = ContainerUtil.newTroveSet();
        int[] cs = new int[c1.size() + c2.size()];
        c1.set(0, cs, 0, c1.size());
        c2.set(0, cs, c1.size(), c2.size());
        int nConst = 0;
        for (int c : cs) {
            DfaValue dfaValue = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(c));
            if (dfaValue instanceof DfaConstValue) {
                ++nConst;
            }
            if (dfaValue instanceof DfaVariableValue) {
                DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
                if (variableValue.isNegated()) {
                    negatedVars.add((DfaVariableValue)variableValue.createNegated());
                } else {
                    vars.add((DfaVariableValue)variableValue);
                }
            }
            if (nConst <= 1) continue;
            return false;
        }
        if (ContainerUtil.intersects(vars, negatedVars)) {
            return false;
        }
        TLongArrayList c2Pairs = new TLongArrayList();
        for (long distinct : distincts = this.myDistinctClasses.toArray()) {
            int pc1 = DfaMemoryStateImpl.low(distinct);
            int pc2 = DfaMemoryStateImpl.high(distinct);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct);
        }
        c1 = new EqClass(c1);
        this.myEqClasses.set(c1Index, c1);
        for (i = 0; i < c2.size(); ++i) {
            int c;
            c = c2.get(i);
            c1.add(c);
        }
        for (i = 0; i < c2Pairs.size(); ++i) {
            long c = c2Pairs.get(i);
            this.myDistinctClasses.remove(c);
            this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, DfaMemoryStateImpl.low(c) == c2Index ? DfaMemoryStateImpl.high(c) : DfaMemoryStateImpl.low(c)));
        }
        this.myEqClasses.set(c2Index, null);
        return true;
    }

    private static int low(long l) {
        return (int)l;
    }

    private static int high(long l) {
        return (int)((l & 0xFFFFFFFF00000000L) >> 32);
    }

    private static long createPair(int i1, int i2) {
        if (i1 < i2) {
            long l = i1;
            l <<= 32;
            return l += (long)i2;
        }
        long l = i2;
        l <<= 32;
        return l += (long)i1;
    }

    private void makeClassesDistinct(int c1Index, int c2Index) {
        this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, c2Index));
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaConstValue) {
            return ((DfaConstValue)dfaValue).getValue() == null;
        }
        if (dfaValue instanceof DfaVariableValue) {
            int c1Index = this.getEqClassIndex(dfaValue);
            return c1Index >= 0 && c1Index == this.getEqClassIndex(this.myFactory.getConstFactory().getNull());
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        long[] pairs;
        if (dfaVar instanceof DfaConstValue) {
            return ((DfaConstValue)dfaVar).getValue() != null;
        }
        if (dfaVar instanceof DfaBoxedValue) {
            return true;
        }
        if (dfaVar instanceof DfaTypeValue) {
            return ((DfaTypeValue)dfaVar).isNotNull();
        }
        if (dfaVar instanceof DfaVariableValue) {
            if (this.getVariableState((DfaVariableValue)dfaVar).isNotNull()) {
                return true;
            }
            DfaConstValue constantValue = this.getConstantValue((DfaVariableValue)dfaVar);
            if (constantValue != null && constantValue.getValue() != null) {
                return true;
            }
        }
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        int c1Index = this.getEqClassIndex(dfaVar);
        int c2Index = this.getEqClassIndex(dfaNull);
        if (c1Index < 0 || c2Index < 0) {
            return false;
        }
        for (long pair : pairs = this.myDistinctClasses.toArray()) {
            if ((c1Index != DfaMemoryStateImpl.low(pair) || c2Index != DfaMemoryStateImpl.high(pair)) && (c1Index != DfaMemoryStateImpl.high(pair) || c2Index != DfaMemoryStateImpl.low(pair))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public DfaConstValue getConstantValue(DfaVariableValue value) {
        int index = this.getEqClassIndex(value);
        EqClass ec = index == -1 ? null : this.myEqClasses.get(index);
        return ec == null ? null : (DfaConstValue)DfaMemoryStateImpl.unwrap(ec.findConstant(true));
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean applyInstanceofOrNull(DfaRelationValue dfaCond) {
        DfaValue left = DfaMemoryStateImpl.unwrap(dfaCond.getLeftOperand());
        if (!(left instanceof DfaVariableValue)) {
            return true;
        }
        DfaVariableValue dfaVar = (DfaVariableValue)left;
        DfaTypeValue dfaType = (DfaTypeValue)dfaCond.getRightOperand();
        if (this.isUnknownState(dfaVar) || this.isNull(dfaVar)) {
            return true;
        }
        DfaVariableState newState = this.getVariableState(dfaVar).withInstanceofValue(dfaType);
        if (newState != null) {
            this.setVariableState(dfaVar, newState);
            return true;
        }
        return false;
    }

    static DfaValue unwrap(DfaValue value) {
        if (value instanceof DfaBoxedValue) {
            return ((DfaBoxedValue)value).getWrappedValue();
        }
        if (value instanceof DfaUnboxedValue) {
            return ((DfaUnboxedValue)value).getVariable();
        }
        return value;
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaUnboxedValue) {
            DfaVariableValue dfaVar = ((DfaUnboxedValue)dfaCond).getVariable();
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaValue boxedTrue = this.myFactory.getBoxedFactory().createBoxed(this.myFactory.getConstFactory().getTrue());
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, boxedTrue, JavaTokenType.EQEQ, isNegated));
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)dfaCond;
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, dfaTrue, JavaTokenType.EQEQ, isNegated));
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        return this.applyRelationCondition((DfaRelationValue)dfaCond);
    }

    private boolean applyRelationCondition(DfaRelationValue dfaRelation) {
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        boolean isNegated = dfaRelation.isNegated();
        if (dfaLeft instanceof DfaTypeValue && ((DfaTypeValue)dfaLeft).isNotNull() && dfaRight == this.myFactory.getConstFactory().getNull()) {
            return isNegated;
        }
        if (dfaRight instanceof DfaTypeValue) {
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableState newState;
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                if (this.isUnknownState(dfaVar)) {
                    return true;
                }
                if (!dfaRelation.isInstanceOf()) {
                    if (((DfaTypeValue)dfaRight).isNotNull() && this.isNull(dfaVar)) {
                        return isNegated;
                    }
                    return true;
                }
                if (isNegated) {
                    DfaVariableState newState2 = this.getVariableState(dfaVar).withNotInstanceofValue((DfaTypeValue)dfaRight);
                    if (newState2 != null) {
                        this.setVariableState(dfaVar, newState2);
                        return true;
                    }
                    return this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), false);
                }
                if (this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true) && (newState = this.getVariableState(dfaVar).withInstanceofValue((DfaTypeValue)dfaRight)) != null) {
                    this.setVariableState(dfaVar, newState);
                    return true;
                }
                return false;
            }
            return true;
        }
        if (this.isEffectivelyNaN(dfaLeft) || this.isEffectivelyNaN(dfaRight)) {
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return isNegated;
        }
        if (this.canBeNaN(dfaLeft) && this.canBeNaN(dfaRight)) {
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return true;
        }
        return this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
    }

    private void updateVarStateOnComparison(DfaVariableValue dfaVar, DfaValue value) {
        if (!this.isUnknownState(dfaVar)) {
            if (value instanceof DfaConstValue && ((DfaConstValue)value).getValue() == null) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withNullability(Nullness.NULLABLE));
            } else if (this.isNotNull(value) && !this.isNotNull(dfaVar)) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withNullability(Nullness.UNKNOWN));
                this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true);
            }
        }
    }

    private boolean applyEquivalenceRelation(DfaRelationValue dfaRelation, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean containsCalls;
        boolean isNegated = dfaRelation.isNonEquality();
        if (!isNegated && !dfaRelation.isEquality()) {
            return true;
        }
        boolean bl = containsCalls = dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        if (containsCalls && !this.isNotNull(dfaLeft) && this.isNull(dfaRight) && !isNegated) {
            return true;
        }
        if (dfaLeft == dfaRight) {
            return containsCalls || !isNegated;
        }
        if (this.isNull(dfaLeft) && this.isNotNull(dfaRight) || this.isNull(dfaRight) && this.isNotNull(dfaLeft)) {
            return isNegated;
        }
        if (!isNegated) {
            if (dfaLeft instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaLeft, dfaRight);
            }
            if (dfaRight instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaRight, dfaLeft);
            }
        }
        if (!this.applyRelation(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (!this.checkCompareWithBooleanLiteral(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            if (!this.applyUnboxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
            if (!this.applyBoxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
        }
        return true;
    }

    private boolean applyBoxedRelation(DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (!TypeConversionUtil.isPrimitiveAndNotNull(dfaLeft.getVariableType())) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue boxedLeft = boxedFactory.createBoxed(dfaLeft);
        DfaValue boxedRight = boxedFactory.createBoxed(dfaRight);
        return boxedLeft == null || boxedRight == null || this.applyRelation(boxedLeft, boxedRight, negated);
    }

    private boolean applyUnboxedRelation(DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        DfaValue unboxedRight;
        PsiType type = dfaLeft.getVariableType();
        if (!TypeConversionUtil.isPrimitiveWrapper(type)) {
            return true;
        }
        if (negated) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue unboxedLeft = boxedFactory.createUnboxed(dfaLeft);
        return this.applyRelation(unboxedLeft, unboxedRight = boxedFactory.createUnboxed(dfaRight), false) && this.checkCompareWithBooleanLiteral(unboxedLeft, unboxedRight, false);
    }

    private boolean checkCompareWithBooleanLiteral(DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        Object constVal;
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            DfaConstValue negVal = this.myFactory.getConstFactory().createFromValue((Boolean)constVal == false, PsiType.BOOLEAN, null);
            if (!this.applyRelation(dfaLeft, negVal, !negated)) {
                return false;
            }
            if (!this.applyRelation(dfaLeft.createNegated(), negVal, negated)) {
                return false;
            }
        }
        return true;
    }

    static boolean isNaN(DfaValue dfa) {
        if (dfa instanceof DfaConstValue) {
            Object value = ((DfaConstValue)dfa).getValue();
            if (value instanceof Double && ((Double)value).isNaN()) {
                return true;
            }
            if (value instanceof Float && ((Float)value).isNaN()) {
                return true;
            }
        } else if (dfa instanceof DfaBoxedValue) {
            return DfaMemoryStateImpl.isNaN(((DfaBoxedValue)dfa).getWrappedValue());
        }
        return false;
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (dfaLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyRelation"));
        }
        if (dfaRight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRight", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyRelation"));
        }
        if (this.isUnknownState(dfaLeft) || this.isUnknownState(dfaRight)) {
            return true;
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (!isNegated) {
            if (c1Index.equals(c2Index)) {
                return true;
            }
            if (!this.uniteClasses(c1Index, c2Index)) {
                return false;
            }
            for (long encodedPair : this.myDistinctClasses.toArray()) {
                EqClass c1 = this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair));
                EqClass c2 = this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair));
                if (c1.findConstant(false) == null || c2.findConstant(false) == null) continue;
                this.myDistinctClasses.remove(encodedPair);
            }
            this.myCachedDistinctClassPairs = null;
            this.myCachedNonTrivialEqClasses = null;
            this.myCachedHash = null;
        } else {
            if (c1Index.equals(c2Index)) {
                return false;
            }
            this.makeClassesDistinct(c1Index, c2Index);
            this.myCachedDistinctClassPairs = null;
            this.myCachedHash = null;
        }
        return true;
    }

    private boolean isUnknownState(DfaValue val) {
        if ((val = DfaMemoryStateImpl.unwrap(val)) instanceof DfaVariableValue) {
            if (this.myUnknownVariables.contains(val)) {
                return true;
            }
            DfaVariableValue negatedValue = ((DfaVariableValue)val).getNegatedValue();
            if (negatedValue != null && this.myUnknownVariables.contains(negatedValue)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkNotNullable(DfaValue value) {
        if (value == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value instanceof DfaTypeValue && ((DfaTypeValue)value).isNullable()) {
            return false;
        }
        if (value instanceof DfaVariableValue) {
            DfaVariableValue varValue = (DfaVariableValue)value;
            if (varValue.getVariableType() instanceof PsiPrimitiveType) {
                return true;
            }
            if (this.isNotNull(varValue)) {
                return true;
            }
            if (this.getVariableState(varValue).isNullable()) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private DfaRelationValue compareToNull(DfaValue dfaVar, boolean negated) {
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        return this.myFactory.getRelationFactory().createRelation(dfaVar, dfaNull, JavaTokenType.EQEQ, negated);
    }

    void setVariableState(DfaVariableValue dfaVar, DfaVariableState state) {
        assert (!this.myUnknownVariables.contains(dfaVar));
        if (state.equals(this.myDefaultVariableStates.get(dfaVar))) {
            this.myVariableStates.remove(dfaVar);
        } else {
            this.myVariableStates.put(dfaVar, state);
        }
        this.myCachedHash = null;
    }

    public DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.myVariableStates.get(dfaVar);
        if (state == null) {
            state = this.myDefaultVariableStates.get(dfaVar);
            if (state == null) {
                state = this.createVariableState(dfaVar);
                DfaTypeValue initialType = dfaVar.getTypeValue();
                if (initialType != null) {
                    state = state.withInstanceofValue(initialType);
                    assert (state != null);
                }
                this.myDefaultVariableStates.put(dfaVar, state);
            }
            if (this.isUnknownState(dfaVar)) {
                return state.withNullable(false);
            }
        }
        return state;
    }

    protected Map<DfaVariableValue, DfaVariableState> getVariableStates() {
        return this.myVariableStates;
    }

    protected DfaVariableState createVariableState(DfaVariableValue var) {
        return new DfaVariableState(var);
    }

    @Override
    public void flushFields() {
        LinkedHashSet<DfaVariableValue> vars = ContainerUtil.newLinkedHashSet(this.getChangedVariables());
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            vars.addAll(aClass.getVariables(true));
        }
        for (DfaVariableValue value : vars) {
            if (!value.isFlushableByCalls()) continue;
            this.doFlush(value, this.shouldMarkUnknown(value));
        }
    }

    private boolean shouldMarkUnknown(DfaVariableValue value) {
        int eqClassIndex = this.getEqClassIndex(value);
        if (eqClassIndex < 0) {
            return false;
        }
        EqClass eqClass = this.myEqClasses.get(eqClassIndex);
        if (eqClass == null) {
            return false;
        }
        if (eqClass.findConstant(true) != null) {
            return true;
        }
        for (UnorderedPair unorderedPair : this.getDistinctClassPairs()) {
            if ((unorderedPair.first != eqClass || ((EqClass)unorderedPair.second).findConstant(true) == null) && (unorderedPair.second != eqClass || ((EqClass)unorderedPair.first).findConstant(true) == null)) continue;
            return true;
        }
        return false;
    }

    Set<DfaVariableValue> getChangedVariables() {
        return this.myVariableStates.keySet();
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "flushVariable"));
        }
        this.doFlush(variable, false);
        this.flushDependencies(variable);
        this.myUnknownVariables.remove(variable);
        this.myUnknownVariables.removeAll(this.myFactory.getVarFactory().getAllQualifiedBy(variable));
        this.myCachedHash = null;
    }

    public void flushDependencies(DfaVariableValue variable) {
        for (DfaVariableValue dependent : this.myFactory.getVarFactory().getAllQualifiedBy(variable)) {
            this.doFlush(dependent, false);
        }
    }

    Set<DfaVariableValue> getUnknownVariables() {
        return this.myUnknownVariables;
    }

    void doFlush(DfaVariableValue varPlain, boolean markUnknown) {
        DfaVariableValue varNegated = varPlain.getNegatedValue();
        int idPlain = varPlain.getID();
        int idNegated = varNegated == null ? -1 : varNegated.getID();
        int size = this.myEqClasses.size();
        int interruptCount = 0;
        for (int varClassIndex = 0; varClassIndex < size; ++varClassIndex) {
            EqClass varClass = this.myEqClasses.get(varClassIndex);
            if (varClass == null) continue;
            for (int i = 0; i < varClass.size(); ++i) {
                int cl;
                DfaValue value;
                if ((++interruptCount & 0xF) == 0) {
                    ProgressManager.checkCanceled();
                }
                if (!DfaMemoryStateImpl.mine(idPlain, value = this.myFactory.getValue(cl = varClass.get(i))) && (idNegated < 0 || !DfaMemoryStateImpl.mine(idNegated, value))) continue;
                varClass = new EqClass(varClass);
                this.myEqClasses.set(varClassIndex, varClass);
                varClass.remove(i);
                break;
            }
            if (varClass.isEmpty()) {
                long[] pairs;
                this.myEqClasses.set(varClassIndex, null);
                for (long pair : pairs = this.myDistinctClasses.toArray()) {
                    if (DfaMemoryStateImpl.low(pair) != varClassIndex && DfaMemoryStateImpl.high(pair) != varClassIndex) continue;
                    this.myDistinctClasses.remove(pair);
                }
                continue;
            }
            if (!varClass.containsConstantsOnly()) continue;
            for (long pair : this.myDistinctClasses.toArray()) {
                if ((DfaMemoryStateImpl.low(pair) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.high(pair)).containsConstantsOnly()) && (DfaMemoryStateImpl.high(pair) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.low(pair)).containsConstantsOnly())) continue;
                this.myDistinctClasses.remove(pair);
            }
        }
        this.myVariableStates.remove(varPlain);
        if (varNegated != null) {
            this.myVariableStates.remove(varNegated);
        }
        if (markUnknown) {
            this.myUnknownVariables.add(varPlain);
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedDistinctClassPairs = null;
        this.myCachedHash = null;
    }

    private static boolean mine(int id, DfaValue value) {
        return value != null && id == DfaMemoryStateImpl.unwrap(value).getID();
    }
}

