/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChangeModifierFix
extends InspectionGadgetsFix {
    public static final String FAMILY_NAME = "Change modifier";
    @PsiModifier.ModifierConstant
    private final String modifierText;

    public ChangeModifierFix(@NonNls @PsiModifier.ModifierConstant String modifierText) {
        this.modifierText = modifierText;
    }

    @Override
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("change.modifier.quickfix", this.modifierText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ChangeModifierFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if (FAMILY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ChangeModifierFix", "getFamilyName"));
        }
        return FAMILY_NAME;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiModifierListOwner modifierListOwner = PsiTreeUtil.getParentOfType(element, PsiModifierListOwner.class);
        if (modifierListOwner == null) {
            return;
        }
        PsiModifierList modifiers = modifierListOwner.getModifierList();
        if (modifiers == null) {
            return;
        }
        modifiers.setModifierProperty(this.modifierText, true);
    }
}

