/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class MethodNamesDifferOnlyByCaseInspectionBase
extends BaseInspection {
    public boolean ignoreIfMethodIsOverride = true;

    @Override
    @NotNull
    public String getID() {
        if ("MethodNamesDifferingOnlyByCase" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/MethodNamesDifferOnlyByCaseInspectionBase", "getID"));
        }
        return "MethodNamesDifferingOnlyByCase";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.names.differ.only.by.case.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/MethodNamesDifferOnlyByCaseInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.names.differ.only.by.case.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/MethodNamesDifferOnlyByCaseInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNamesDifferOnlyByCaseVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class MethodNamesDifferOnlyByCaseVisitor
    extends BaseInspectionVisitor {
        private MethodNamesDifferOnlyByCaseVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] methods;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/MethodNamesDifferOnlyByCaseInspectionBase$MethodNamesDifferOnlyByCaseVisitor", "visitMethod"));
            }
            if (method.isConstructor()) {
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            String methodName = method.getName();
            if (MethodNamesDifferOnlyByCaseInspectionBase.this.ignoreIfMethodIsOverride && MethodUtils.hasSuper(method)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (PsiMethod testMethod : methods = aClass.getAllMethods()) {
                String testMethodName = testMethod.getName();
                if (methodName.equals(testMethodName) || !methodName.equalsIgnoreCase(testMethodName)) continue;
                this.registerError((PsiElement)nameIdentifier, testMethodName);
            }
        }
    }
}

