/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticVariableNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 5;
    private static final int DEFAULT_MAX_LENGTH = 32;
    public boolean checkMutableFinals = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.variable.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/StaticVariableNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String fieldName = (String)infos[0];
        if (fieldName.length() < this.getMinLength()) {
            String string = InspectionGadgetsBundle.message("static.variable.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/StaticVariableNamingConventionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        if (fieldName.length() > this.getMaxLength()) {
            String string = InspectionGadgetsBundle.message("static.variable.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/StaticVariableNamingConventionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("static.variable.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/StaticVariableNamingConventionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "s_[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 5;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public JComponent[] createExtraOptions() {
        return new JComponent[]{new CheckBox(InspectionGadgetsBundle.message("static.variable.naming.convention.mutable.option", new Object[0]), this, "checkMutableFinals")};
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            String name;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/naming/StaticVariableNamingConventionInspectionBase$NamingConventionsVisitor", "visitField"));
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                if (!StaticVariableNamingConventionInspectionBase.this.checkMutableFinals) {
                    return;
                }
                PsiType type = field.getType();
                if (ClassUtils.isImmutable(type)) {
                    return;
                }
            }
            if ((name = field.getName()) == null) {
                return;
            }
            if (StaticVariableNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerFieldError(field, name);
        }
    }
}

