/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;

public class JdkScope
extends LibraryScopeBase {
    private final VirtualFile[] myClasses;
    private final VirtualFile[] mySources;
    private final String myJdkName;

    public JdkScope(Project project, JdkOrderEntry entry) {
        this(project, entry.getRootFiles(OrderRootType.CLASSES), entry.getRootFiles(OrderRootType.SOURCES), entry.getJdkName());
    }

    public JdkScope(Project project, VirtualFile[] classes, VirtualFile[] sources, String jdkName) {
        super(project, classes, sources);
        this.myClasses = classes;
        this.mySources = sources;
        this.myJdkName = jdkName;
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(this.myClasses);
        result = 31 * result + Arrays.hashCode(this.mySources);
        result = 31 * result + this.myJdkName.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        JdkScope that = (JdkScope)object;
        return this.myJdkName.equals(that.myJdkName) && Arrays.equals(this.myClasses, that.myClasses) && Arrays.equals(this.mySources, that.mySources);
    }
}

