/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic<BulkFileListener>("NewVirtualFileSystem changes", BulkFileListener.class);

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager virtualFileManager = ApplicationManager.getApplication().getComponent(VirtualFileManager.class);
        if (virtualFileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileManager", "getInstance"));
        }
        return virtualFileManager;
    }

    public abstract VirtualFileSystem getFileSystem(String var1);

    public abstract long syncRefresh();

    public abstract long asyncRefresh(@Nullable Runnable var1);

    public abstract void refreshWithoutFileWatcher(boolean var1);

    @Nullable
    public abstract VirtualFile findFileByUrl(@NonNls @NotNull String var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByUrl(@NotNull String var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1, @NotNull Disposable var2);

    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        String string = protocol + "://" + path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        return string;
    }

    @Nullable
    public static String extractProtocol(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VirtualFileManager", "extractProtocol"));
        }
        int index = url.indexOf("://");
        if (index < 0) {
            return null;
        }
        return url.substring(0, index);
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/VirtualFileManager", "extractPath"));
        }
        int index = url.indexOf("://");
        if (index < 0) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileManager", "extractPath"));
            }
            return string;
        }
        String string = url.substring(index + "://".length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileManager", "extractPath"));
        }
        return string;
    }

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1, @NotNull Disposable var2);

    public abstract void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void notifyPropertyChanged(@NotNull VirtualFile var1, @NotNull String var2, Object var3, Object var4);
}

