/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.UnmodifiableIterator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteredTraverser;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyntaxTraverser<T>
extends FilteredTraverser<T, SyntaxTraverser<T>>
implements Iterable<T> {
    @NotNull
    public static SyntaxTraverser<PsiElement> psiTraverser() {
        PsiTraverser psiTraverser = new PsiTraverser(null);
        if (psiTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "psiTraverser"));
        }
        return psiTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> revPsiTraverser() {
        RevPsiTraverser revPsiTraverser = new RevPsiTraverser(null);
        if (revPsiTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "revPsiTraverser"));
        }
        return revPsiTraverser;
    }

    @NotNull
    public static SyntaxTraverser<ASTNode> astTraverser() {
        ASTTraverser aSTTraverser = new ASTTraverser(null);
        if (aSTTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "astTraverser"));
        }
        return aSTTraverser;
    }

    @NotNull
    public static SyntaxTraverser<LighterASTNode> lightTraverser(PsiBuilder builder) {
        FlyweightCapableTreeStructure<LighterASTNode> lightTree = builder.getLightTree();
        FilteredTraverser.Meta<LighterASTNode> meta = FilteredTraverser.emptyMeta().withRoots(Collections.singletonList(lightTree.getRoot()));
        LightASTTraverser lightASTTraverser = new LightASTTraverser(meta, builder.getOriginalText(), lightTree);
        if (lightASTTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "lightTraverser"));
        }
        return lightASTTraverser;
    }

    protected SyntaxTraverser(@Nullable FilteredTraverser.Meta<T> meta) {
        super(meta);
    }

    @NotNull
    public abstract IElementType nodeType(@NotNull T var1);

    @NotNull
    public abstract TextRange nodeRange(@NotNull T var1);

    @NotNull
    public abstract CharSequence nodeText(@NotNull T var1);

    @Nullable
    public abstract T parent(@NotNull T var1);

    @NotNull
    public SyntaxTraverser<T> expandTypes(@NotNull Condition<? super IElementType> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/SyntaxTraverser", "expandTypes"));
        }
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)super.expand(Conditions.compose(this.NODE_TYPE(), condition));
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "expandTypes"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public SyntaxTraverser<T> filterTypes(@NotNull Condition<? super IElementType> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/SyntaxTraverser", "filterTypes"));
        }
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)super.filter(Conditions.compose(this.NODE_TYPE(), condition));
        if (syntaxTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "filterTypes"));
        }
        return syntaxTraverser;
    }

    @NotNull
    public Function<T, IElementType> NODE_TYPE() {
        Function function = new Function<T, IElementType>(){

            @Override
            public IElementType fun(T t) {
                return SyntaxTraverser.this.nodeType(t);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "NODE_TYPE"));
        }
        return function;
    }

    @Nullable
    public T getRawDeepestLast() {
        Object result = this.getRoot();
        while (result != null) {
            Object last;
            JBIterable children = this.children(result);
            if (children.isEmpty()) {
                return result;
            }
            result = last = children.last();
        }
        return null;
    }

    @NotNull
    public JBIterable<T> parents(final @Nullable T element) {
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    T cur;
                    {
                        this.cur = element;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.cur != null;
                    }

                    @Override
                    public T next() {
                        Object result = this.cur;
                        this.cur = SyntaxTraverser.this.parent(this.cur);
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser", "parents"));
        }
        return jBIterable;
    }

    private static class LightASTTraverser
    extends FlyweightTraverser<LighterASTNode> {
        private final CharSequence myText;

        public LightASTTraverser(@NotNull FilteredTraverser.Meta<LighterASTNode> meta, @NotNull CharSequence text, @NotNull FlyweightCapableTreeStructure<LighterASTNode> structure) {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "<init>"));
            }
            if (structure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "<init>"));
            }
            super(meta, structure);
            this.myText = text;
        }

        @Override
        protected SyntaxTraverser<LighterASTNode> newInstance(FilteredTraverser.Meta<LighterASTNode> meta) {
            return new LightASTTraverser(meta, this.myText, this.myTree);
        }

        @Override
        @NotNull
        public IElementType nodeType(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "nodeType"));
            }
            IElementType iElementType = node.getTokenType();
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "nodeType"));
            }
            return iElementType;
        }

        @Override
        @NotNull
        public TextRange nodeRange(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "nodeRange"));
            }
            TextRange textRange = TextRange.create(node.getStartOffset(), node.getEndOffset());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "nodeRange"));
            }
            return textRange;
        }

        @Override
        @NotNull
        public CharSequence nodeText(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "nodeText"));
            }
            CharSequence charSequence = this.myText.subSequence(node.getStartOffset(), node.getEndOffset());
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "nodeText"));
            }
            return charSequence;
        }

        @Override
        @Nullable
        public LighterASTNode parent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$LightASTTraverser", "parent"));
            }
            return node instanceof LighterASTTokenNode ? null : super.parent(node);
        }
    }

    private static abstract class FlyweightTraverser<T>
    extends SyntaxTraverser<T> {
        final FlyweightCapableTreeStructure<T> myTree;

        FlyweightTraverser(@NotNull FilteredTraverser.Meta<T> meta, @NotNull FlyweightCapableTreeStructure<T> structure) {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/psi/SyntaxTraverser$FlyweightTraverser", "<init>"));
            }
            if (structure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/psi/SyntaxTraverser$FlyweightTraverser", "<init>"));
            }
            super(meta);
            this.myTree = structure;
        }

        @Override
        @Nullable
        public T parent(@NotNull T node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$FlyweightTraverser", "parent"));
            }
            return this.myTree.getParent(node);
        }

        @Override
        protected Iterable<T> childrenImpl(final @NotNull T node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$FlyweightTraverser", "childrenImpl"));
            }
            return new JBIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    Ref<T[]> ref = Ref.create();
                    int count = FlyweightTraverser.this.myTree.getChildren(FlyweightTraverser.this.myTree.prepareForGetChildren(node), ref);
                    if (count == 0) {
                        return ContainerUtil.emptyIterator();
                    }
                    T[] array = ref.get();
                    LinkedList list = ContainerUtil.newLinkedList();
                    for (int i = 0; i < count; ++i) {
                        Object t = array[i];
                        if (FlyweightTraverser.this.nodeType(t).getLanguage() == Language.ANY) continue;
                        array[i] = null;
                        list.addLast(t);
                    }
                    FlyweightTraverser.this.myTree.disposeChildren(array, count);
                    return list.iterator();
                }
            };
        }
    }

    private static class ASTTraverser
    extends FirstNextTraverser<ASTNode> {
        public ASTTraverser(FilteredTraverser.Meta<ASTNode> meta) {
            super(meta);
        }

        @Override
        protected SyntaxTraverser<ASTNode> newInstance(FilteredTraverser.Meta<ASTNode> meta) {
            return new ASTTraverser(meta);
        }

        @Override
        @Nullable
        protected ASTNode first(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "first"));
            }
            return node.getFirstChildNode();
        }

        @Override
        @Nullable
        protected ASTNode next(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "next"));
            }
            return node.getTreeNext();
        }

        @Override
        @NotNull
        public IElementType nodeType(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "nodeType"));
            }
            IElementType iElementType = node.getElementType();
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "nodeType"));
            }
            return iElementType;
        }

        @Override
        @NotNull
        public TextRange nodeRange(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "nodeRange"));
            }
            TextRange textRange = node.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "nodeRange"));
            }
            return textRange;
        }

        @Override
        @NotNull
        public CharSequence nodeText(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "nodeText"));
            }
            String string = node.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "nodeText"));
            }
            return string;
        }

        @Override
        @Nullable
        public ASTNode parent(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$ASTTraverser", "parent"));
            }
            return node.getTreeParent();
        }
    }

    private static class RevPsiTraverser
    extends PsiTraverser {
        public RevPsiTraverser(FilteredTraverser.Meta<PsiElement> meta) {
            super(meta);
        }

        @Override
        protected SyntaxTraverser<PsiElement> newInstance(FilteredTraverser.Meta<PsiElement> meta) {
            return new RevPsiTraverser(meta);
        }

        @Override
        @Nullable
        protected PsiElement first(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$RevPsiTraverser", "first"));
            }
            return node.getLastChild();
        }

        @Override
        @Nullable
        protected PsiElement next(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$RevPsiTraverser", "next"));
            }
            return node.getPrevSibling();
        }
    }

    private static class PsiTraverser
    extends FirstNextTraverser<PsiElement> {
        public PsiTraverser(FilteredTraverser.Meta<PsiElement> meta) {
            super(meta);
        }

        @Override
        protected SyntaxTraverser<PsiElement> newInstance(FilteredTraverser.Meta<PsiElement> meta) {
            return new PsiTraverser(meta);
        }

        @Override
        @Nullable
        protected PsiElement first(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "first"));
            }
            return node.getFirstChild();
        }

        @Override
        @Nullable
        protected PsiElement next(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "next"));
            }
            return node.getNextSibling();
        }

        @Override
        @NotNull
        public IElementType nodeType(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "nodeType"));
            }
            IElementType iElementType = node.getNode().getElementType();
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "nodeType"));
            }
            return iElementType;
        }

        @Override
        @NotNull
        public TextRange nodeRange(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "nodeRange"));
            }
            TextRange textRange = node.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "nodeRange"));
            }
            return textRange;
        }

        @Override
        @NotNull
        public CharSequence nodeText(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "nodeText"));
            }
            String string = node.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "nodeText"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement parent(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$PsiTraverser", "parent"));
            }
            PsiElement parent = node.getParent();
            return parent instanceof PsiFile ? null : parent;
        }
    }

    private static abstract class FirstNextTraverser<T>
    extends SyntaxTraverser<T> {
        public FirstNextTraverser(FilteredTraverser.Meta<T> meta) {
            super(meta);
        }

        @Nullable
        protected abstract T first(@NotNull T var1);

        @Nullable
        protected abstract T next(@NotNull T var1);

        @Override
        protected final Iterable<T> childrenImpl(@NotNull T node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/SyntaxTraverser$FirstNextTraverser", "childrenImpl"));
            }
            final T first = this.first(node);
            if (first == null) {
                return JBIterable.empty();
            }
            return new JBIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new UnmodifiableIterator<T>(null){
                        T cur;
                        {
                            this.cur = first;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.cur != null;
                        }

                        @Override
                        public T next() {
                            Object result = this.cur;
                            this.cur = FirstNextTraverser.this.next(this.cur);
                            return result;
                        }
                    };
                }
            };
        }
    }
}

