/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create("FilenameIndex");
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();
    private final MyInputFilter myInputFilter = new MyInputFilter();
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();

    @Override
    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = this.myDataIndexer;
        if (myDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getIndexer"));
        }
        return myDataIndexer;
    }

    @Override
    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = this.myKeyDescriptor;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        MyInputFilter myInputFilter = this.myInputFilter;
        if (myInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getInputFilter"));
        }
        return myInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return false;
    }

    @Override
    public boolean indexDirectories() {
        return true;
    }

    @Override
    public int getVersion() {
        return 1 + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 1 : 0);
    }

    public static String[] getAllFilenames(Project project) {
        Collection<String> allKeys = FileBasedIndex.getInstance().getAllKeys(NAME, project);
        return ArrayUtil.toStringArray(allKeys);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project, String name, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, name, scope);
    }

    public static PsiFile[] getFilesByName(Project project, String name, GlobalSearchScope scope) {
        return (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        THashSet files = new THashSet();
        FileBasedIndex.getInstance().processValues(NAME, name, null, new FileBasedIndex.ValueProcessor<Void>((Set)files){
            final /* synthetic */ Set val$files;
            {
                this.val$files = set;
            }

            @Override
            public boolean process(VirtualFile file, Void value) {
                this.val$files.add(file);
                return true;
            }
        }, scope, idFilter);
        if (files.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        int processedFiles = 0;
        for (VirtualFile file : files) {
            PsiDirectory dir;
            if (!file.isValid()) continue;
            if (!includeDirs && !file.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile == null) continue;
                if (!processor.process(psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!includeDirs || !file.isDirectory() || (dir = psiManager.findDirectory(file)) == null) continue;
            if (!processor.process(dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    public static PsiFileSystemItem[] getFilesByName(Project project, String name, @NotNull GlobalSearchScope scope, boolean includeDirs) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        SmartList result = new SmartList();
        FilenameIndex.processFilesByName(name, includeDirs, new CommonProcessors.CollectProcessor(result), scope, project, null);
        if (includeDirs) {
            return ArrayUtil.toObjectArray(result, PsiFileSystemItem.class);
        }
        return result.toArray(new PsiFile[result.size()]);
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        Collection<VirtualFile> collection = FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope(project));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        int len = ext.length();
        if (len == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
            }
            return list;
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files.addAll(FilenameIndex.getVirtualFilesByName(project, name, searchScope));
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return arrayList;
    }

    @Override
    public boolean traceKeyHashToVirtualFileMapping() {
        return FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }

    private static class MyInputFilter
    implements FileBasedIndex.InputFilter {
        private MyInputFilter() {
        }

        @Override
        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/FilenameIndex$MyInputFilter", "acceptInput"));
            }
            return true;
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @Override
        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/search/FilenameIndex$MyDataIndexer", "map"));
            }
            Map<String, Object> map = Collections.singletonMap(inputData.getFileName(), null);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex$MyDataIndexer", "map"));
            }
            return map;
        }
    }
}

