/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOutputReader
extends BaseDataReader {
    protected final Reader myReader;

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(inputStream, charset, null);
    }

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @Nullable BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(BaseOutputReader.createInputStreamReader(inputStream, charset), sleepingPolicy);
    }

    public BaseOutputReader(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(reader, null);
    }

    public BaseOutputReader(@NotNull Reader reader, BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        super(sleepingPolicy);
        if (sleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING && !(reader instanceof BaseInputStreamReader)) {
            throw new IllegalArgumentException("Blocking policy can be used only with BaseInputStreamReader, that doesn't lock on close");
        }
        this.myReader = reader;
    }

    private static Reader createInputStreamReader(@NotNull InputStream stream, @Nullable Charset charset) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/io/BaseOutputReader", "createInputStreamReader"));
        }
        return charset == null ? new BaseInputStreamReader(stream) : new BaseInputStreamReader(stream, charset);
    }

    protected final boolean readAvailableNonBlocking() throws IOException {
        int n;
        char[] buffer = new char[8192];
        StringBuilder line = new StringBuilder();
        boolean read = false;
        while (this.myReader.ready() && (n = this.myReader.read(buffer)) > 0) {
            read = true;
            this.processLine(buffer, line, n);
        }
        if (line.length() > 0) {
            this.sendLine(line);
        }
        return read;
    }

    protected final boolean readAvailableBlocking() throws IOException {
        int n;
        char[] buffer = new char[8192];
        StringBuilder line = new StringBuilder();
        boolean read = false;
        while ((n = this.myReader.read(buffer)) > 0) {
            read = true;
            this.processLine(buffer, line, n);
            if (line.length() <= 0 || this.myReader.ready()) continue;
            this.sendLine(line);
        }
        if (line.length() > 0) {
            this.sendLine(line);
        }
        return read;
    }

    protected final void processLine(char[] buffer, StringBuilder line, int n) {
        for (int i = 0; i < n; ++i) {
            char c = buffer[i];
            if (c == '\n' && line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
                line.setCharAt(line.length() - 1, '\n');
            } else {
                line.append(c);
            }
            if (c != '\n') continue;
            this.sendLine(line);
        }
    }

    private void sendLine(StringBuilder line) {
        this.onTextAvailable(line.toString());
        line.setLength(0);
    }

    @Override
    protected boolean readAvailable() throws IOException {
        return this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING ? this.readAvailableBlocking() : this.readAvailableNonBlocking();
    }

    @Override
    protected void close() throws IOException {
        this.myReader.close();
    }

    protected abstract void onTextAvailable(@NotNull String var1);
}

