/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class WavePainter {
    private static final float STROKE_WIDTH = 0.7f;
    private static final Map<Color, WavePainter> myPainters = new HashMap<Color, WavePainter>();
    private static final int PATTERN_WIDTH = 4000;
    private final BufferedImage myImage = UIUtil.createImage(4000, 3, 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WavePainter(Color color) {
        Graphics2D g = this.myImage.createGraphics();
        try {
            GraphicsUtil.setupAAPainting(g);
            g.setStroke(new BasicStroke(0.7f));
            g.setColor(color);
            double height = 1.0;
            double cycle = 4.0 * height;
            double wavedAt = (double)2.3f - height;
            GeneralPath wavePath = new GeneralPath();
            wavePath.moveTo(0.0, wavedAt - Math.cos(0.0 / cycle) * height);
            for (int x = 0; x < 4000; ++x) {
                wavePath.lineTo((double)x, wavedAt - Math.cos((double)(x * 2) * Math.PI / cycle) * height);
            }
            g.draw(wavePath);
        }
        finally {
            g.dispose();
        }
    }

    public void paint(Graphics2D g, int xStart, int xEnd, int y) {
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.SrcOver);
        Shape clip = g.getClip();
        g.setClip(xStart, y - 3, xEnd - xStart, 3);
        UIUtil.drawImage((Graphics)g, (Image)this.myImage, xStart, y - 3, null);
        g.setComposite(oldComposite);
        g.setClip(clip);
    }

    public static WavePainter forColor(Color color) {
        WavePainter painter = myPainters.get(color);
        if (painter == null) {
            painter = new WavePainter(color);
            myPainters.put(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()), painter);
        }
        return painter;
    }
}

