/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.module;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.java.JpsJavaModelSerializerExtension;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;

public class JpsModuleRootModelSerializer {
    private static final Logger LOG = Logger.getInstance(JpsModuleRootModelSerializer.class);
    public static final String URL_ATTRIBUTE = "url";
    public static final String CONTENT_TAG = "content";
    public static final String SOURCE_FOLDER_TAG = "sourceFolder";
    public static final String PACKAGE_PREFIX_ATTRIBUTE = "packagePrefix";
    public static final String IS_TEST_SOURCE_ATTRIBUTE = "isTestSource";
    public static final String EXCLUDE_FOLDER_TAG = "excludeFolder";
    public static final String ORDER_ENTRY_TAG = "orderEntry";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String SOURCE_FOLDER_TYPE = "sourceFolder";
    public static final String JDK_TYPE = "jdk";
    public static final String JDK_NAME_ATTRIBUTE = "jdkName";
    public static final String JDK_TYPE_ATTRIBUTE = "jdkType";
    public static final String INHERITED_JDK_TYPE = "inheritedJdk";
    public static final String LIBRARY_TYPE = "library";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String LEVEL_ATTRIBUTE = "level";
    public static final String LIBRARY_TAG = "library";
    public static final String MODULE_LIBRARY_TYPE = "module-library";
    public static final String MODULE_TYPE = "module";
    public static final String MODULE_NAME_ATTRIBUTE = "module-name";
    private static final String SOURCE_ROOT_TYPE_ATTRIBUTE = "type";
    public static final String JAVA_SOURCE_ROOT_TYPE_ID = "java-source";
    public static final String JAVA_TEST_ROOT_TYPE_ID = "java-test";
    private static final String GENERATED_LIBRARY_NAME_PREFIX = "#";

    public static void loadRootModel(JpsModule module, @Nullable Element rootModelComponent, @Nullable JpsSdkType<?> projectSdkType) {
        if (rootModelComponent == null) {
            return;
        }
        for (Element contentElement : JDOMUtil.getChildren(rootModelComponent, CONTENT_TAG)) {
            String url = contentElement.getAttributeValue(URL_ATTRIBUTE);
            module.getContentRootsList().addUrl(url);
            for (Element sourceElement : JDOMUtil.getChildren(contentElement, "sourceFolder")) {
                module.addSourceRoot(JpsModuleRootModelSerializer.loadSourceRoot(sourceElement));
            }
            for (Element excludeElement : JDOMUtil.getChildren(contentElement, EXCLUDE_FOLDER_TAG)) {
                module.getExcludeRootsList().addUrl(excludeElement.getAttributeValue(URL_ATTRIBUTE));
            }
        }
        JpsDependenciesList dependenciesList = module.getDependenciesList();
        dependenciesList.clear();
        JpsElementFactory elementFactory = JpsElementFactory.getInstance();
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        for (Element orderEntry : JDOMUtil.getChildren(rootModelComponent, ORDER_ENTRY_TAG)) {
            String name;
            String type = orderEntry.getAttributeValue("type");
            if ("sourceFolder".equals(type)) {
                dependenciesList.addModuleSourceDependency();
                continue;
            }
            if (JDK_TYPE.equals(type)) {
                String sdkName = orderEntry.getAttributeValue(JDK_NAME_ATTRIBUTE);
                String sdkTypeId = orderEntry.getAttributeValue(JDK_TYPE_ATTRIBUTE);
                JpsSdkType<?> sdkType = JpsSdkTableSerializer.getSdkType(sdkTypeId);
                dependenciesList.addSdkDependency(sdkType);
                JpsSdkTableSerializer.setSdkReference(module.getSdkReferencesTable(), sdkName, sdkType);
                if (!(sdkType instanceof JpsJavaSdkTypeWrapper)) continue;
                dependenciesList.addSdkDependency(JpsJavaSdkType.INSTANCE);
                continue;
            }
            if (INHERITED_JDK_TYPE.equals(type)) {
                JpsJavaSdkType sdkType = projectSdkType != null ? projectSdkType : JpsJavaSdkType.INSTANCE;
                dependenciesList.addSdkDependency(sdkType);
                if (!(sdkType instanceof JpsJavaSdkTypeWrapper)) continue;
                dependenciesList.addSdkDependency(JpsJavaSdkType.INSTANCE);
                continue;
            }
            if ("library".equals(type)) {
                name = orderEntry.getAttributeValue(NAME_ATTRIBUTE);
                String level = orderEntry.getAttributeValue(LEVEL_ATTRIBUTE);
                JpsLibraryDependency dependency = dependenciesList.addLibraryDependency(elementFactory.createLibraryReference(name, JpsLibraryTableSerializer.createLibraryTableReference(level)));
                JpsModuleRootModelSerializer.loadModuleDependencyProperties(dependency, orderEntry);
                continue;
            }
            if (MODULE_LIBRARY_TYPE.equals(type)) {
                Element moduleLibraryElement = orderEntry.getChild("library");
                String name2 = moduleLibraryElement.getAttributeValue(NAME_ATTRIBUTE);
                if (name2 == null) {
                    name2 = GENERATED_LIBRARY_NAME_PREFIX;
                }
                String uniqueName = nameGenerator.generateUniqueName(name2);
                JpsLibrary library = JpsLibraryTableSerializer.loadLibrary(moduleLibraryElement, uniqueName);
                module.addModuleLibrary(library);
                JpsLibraryDependency dependency = dependenciesList.addLibraryDependency(library);
                JpsModuleRootModelSerializer.loadModuleDependencyProperties(dependency, orderEntry);
                continue;
            }
            if (!MODULE_TYPE.equals(type)) continue;
            name = orderEntry.getAttributeValue(MODULE_NAME_ATTRIBUTE);
            JpsModuleDependency dependency = dependenciesList.addModuleDependency(elementFactory.createModuleReference(name));
            JpsModuleRootModelSerializer.loadModuleDependencyProperties(dependency, orderEntry);
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadRootModel(module, rootModelComponent);
        }
    }

    @NotNull
    public static JpsModuleSourceRoot loadSourceRoot(Element sourceElement) {
        String sourceUrl = sourceElement.getAttributeValue(URL_ATTRIBUTE);
        JpsModuleSourceRootPropertiesSerializer<?> serializer = JpsModuleRootModelSerializer.getSourceRootPropertiesSerializer(sourceElement);
        JpsModuleSourceRoot jpsModuleSourceRoot = JpsModuleRootModelSerializer.createSourceRoot(sourceUrl, serializer, sourceElement);
        if (jpsModuleSourceRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "loadSourceRoot"));
        }
        return jpsModuleSourceRoot;
    }

    @NotNull
    private static <P extends JpsElement> JpsModuleSourceRoot createSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootPropertiesSerializer<P> serializer, @NotNull Element sourceElement) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTRIBUTE, "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "createSourceRoot"));
        }
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "createSourceRoot"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "createSourceRoot"));
        }
        JpsModuleSourceRoot jpsModuleSourceRoot = JpsElementFactory.getInstance().createModuleSourceRoot(url, (JpsModuleSourceRootType)serializer.getType(), serializer.loadProperties(sourceElement));
        if (jpsModuleSourceRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "createSourceRoot"));
        }
        return jpsModuleSourceRoot;
    }

    @NotNull
    private static JpsModuleSourceRootPropertiesSerializer<?> getSourceRootPropertiesSerializer(@NotNull Element sourceElement) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "getSourceRootPropertiesSerializer"));
        }
        String typeAttribute = sourceElement.getAttributeValue("type");
        if (typeAttribute == null) {
            typeAttribute = Boolean.parseBoolean(sourceElement.getAttributeValue(IS_TEST_SOURCE_ATTRIBUTE)) ? JAVA_TEST_ROOT_TYPE_ID : JAVA_SOURCE_ROOT_TYPE_ID;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModuleSourceRootPropertiesSerializer<?> serializer : extension.getModuleSourceRootPropertiesSerializers()) {
                if (!serializer.getTypeId().equals(typeAttribute)) continue;
                JpsModuleSourceRootPropertiesSerializer<?> jpsModuleSourceRootPropertiesSerializer = serializer;
                if (jpsModuleSourceRootPropertiesSerializer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "getSourceRootPropertiesSerializer"));
                }
                return jpsModuleSourceRootPropertiesSerializer;
            }
        }
        LOG.warn("Unknown module source root type " + typeAttribute);
        JpsJavaModelSerializerExtension.JavaSourceRootPropertiesSerializer javaSourceRootPropertiesSerializer = JpsJavaModelSerializerExtension.JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER;
        if (javaSourceRootPropertiesSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "getSourceRootPropertiesSerializer"));
        }
        return javaSourceRootPropertiesSerializer;
    }

    public static void saveRootModel(JpsModule module, Element rootModelElement) {
        Element element;
        List<JpsModuleSourceRoot> sourceRoots = module.getSourceRoots();
        List<String> excludedUrls = JpsModuleRootModelSerializer.getSortedList(module.getExcludeRootsList().getUrls());
        for (String url : JpsModuleRootModelSerializer.getSortedList(module.getContentRootsList().getUrls())) {
            Element contentElement = new Element(CONTENT_TAG);
            contentElement.setAttribute(URL_ATTRIBUTE, url);
            rootModelElement.addContent(contentElement);
            for (JpsModuleSourceRoot root : sourceRoots) {
                if (!FileUtil.startsWith(root.getUrl(), url)) continue;
                JpsModuleRootModelSerializer.saveSourceRoot(contentElement, root.asTyped().getUrl(), root.asTyped());
            }
            for (String excludedUrl : excludedUrls) {
                if (!FileUtil.startsWith(excludedUrl, url)) continue;
                element = new Element(EXCLUDE_FOLDER_TAG).setAttribute(URL_ATTRIBUTE, excludedUrl);
                contentElement.addContent(element);
            }
        }
        for (JpsDependencyElement dependency : module.getDependenciesList().getDependencies()) {
            if (dependency instanceof JpsModuleSourceDependency) {
                rootModelElement.addContent(JpsModuleRootModelSerializer.createDependencyElement("sourceFolder").setAttribute("forTests", "false"));
                continue;
            }
            if (dependency instanceof JpsSdkDependency) {
                JpsSdkType<?> sdkType = ((JpsSdkDependency)dependency).getSdkType();
                JpsSdkReferencesTable table = module.getSdkReferencesTable();
                JpsSdkReference<?> reference = table.getSdkReference(sdkType);
                if (reference == null) {
                    rootModelElement.addContent(JpsModuleRootModelSerializer.createDependencyElement(INHERITED_JDK_TYPE));
                    continue;
                }
                element = JpsModuleRootModelSerializer.createDependencyElement(JDK_TYPE);
                element.setAttribute(JDK_NAME_ATTRIBUTE, reference.getSdkName());
                element.setAttribute(JDK_TYPE_ATTRIBUTE, JpsSdkTableSerializer.getLoader(sdkType).getTypeId());
                rootModelElement.addContent(element);
                continue;
            }
            if (dependency instanceof JpsLibraryDependency) {
                Element element2;
                JpsLibraryReference reference = ((JpsLibraryDependency)dependency).getLibraryReference();
                JpsElementReference<? extends JpsCompositeElement> parentReference = reference.getParentReference();
                if (parentReference instanceof JpsModuleReference) {
                    element2 = JpsModuleRootModelSerializer.createDependencyElement(MODULE_LIBRARY_TYPE);
                    JpsModuleRootModelSerializer.saveModuleDependencyProperties(dependency, element2);
                    Element libraryElement = new Element("library");
                    JpsLibrary library = (JpsLibrary)reference.resolve();
                    String libraryName = library.getName();
                    JpsLibraryTableSerializer.saveLibrary(library, libraryElement, JpsModuleRootModelSerializer.isGeneratedName(libraryName) ? null : libraryName);
                    element2.addContent(libraryElement);
                } else {
                    element2 = JpsModuleRootModelSerializer.createDependencyElement("library");
                    JpsModuleRootModelSerializer.saveModuleDependencyProperties(dependency, element2);
                    element2.setAttribute(NAME_ATTRIBUTE, reference.getLibraryName());
                    element2.setAttribute(LEVEL_ATTRIBUTE, JpsLibraryTableSerializer.getLevelId(parentReference));
                }
                rootModelElement.addContent(element2);
                continue;
            }
            if (!(dependency instanceof JpsModuleDependency)) continue;
            Element element3 = JpsModuleRootModelSerializer.createDependencyElement(MODULE_TYPE);
            element3.setAttribute(MODULE_NAME_ATTRIBUTE, ((JpsModuleDependency)dependency).getModuleReference().getModuleName());
            JpsModuleRootModelSerializer.saveModuleDependencyProperties(dependency, element3);
            rootModelElement.addContent(element3);
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.saveRootModel(module, rootModelElement);
        }
    }

    public static <P extends JpsElement> void saveSourceRoot(@NotNull Element contentElement, @NotNull String rootUrl, @NotNull JpsTypedModuleSourceRoot<P> root) {
        if (contentElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentElement", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "saveSourceRoot"));
        }
        if (rootUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootUrl", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "saveSourceRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/model/serialization/module/JpsModuleRootModelSerializer", "saveSourceRoot"));
        }
        Element sourceElement = new Element("sourceFolder");
        sourceElement.setAttribute(URL_ATTRIBUTE, rootUrl);
        JpsModuleSourceRootPropertiesSerializer<P> serializer = JpsModuleRootModelSerializer.getSerializer(root.getRootType());
        if (serializer != null) {
            String typeId = serializer.getTypeId();
            if (!typeId.equals(JAVA_SOURCE_ROOT_TYPE_ID) && !typeId.equals(JAVA_TEST_ROOT_TYPE_ID)) {
                sourceElement.setAttribute("type", typeId);
            }
            serializer.saveProperties(root.getProperties(), sourceElement);
        }
        contentElement.addContent(sourceElement);
    }

    @Nullable
    private static <P extends JpsElement> JpsModuleSourceRootPropertiesSerializer<P> getSerializer(JpsModuleSourceRootType<P> type) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModuleSourceRootPropertiesSerializer<?> serializer : extension.getModuleSourceRootPropertiesSerializers()) {
                if (!((JpsModuleSourceRootType)serializer.getType()).equals(type)) continue;
                return serializer;
            }
        }
        return null;
    }

    private static boolean isGeneratedName(String libraryName) {
        return libraryName.startsWith(GENERATED_LIBRARY_NAME_PREFIX);
    }

    private static Element createDependencyElement(String type) {
        return new Element(ORDER_ENTRY_TAG).setAttribute("type", type);
    }

    private static List<String> getSortedList(List<String> list) {
        ArrayList<String> strings = new ArrayList<String>(list);
        Collections.sort(strings);
        return strings;
    }

    private static void loadModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadModuleDependencyProperties(dependency, orderEntry);
        }
    }

    private static void saveModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.saveModuleDependencyProperties(dependency, orderEntry);
        }
    }
}

