/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ImageLoader
implements Serializable {
    public static final Component ourComponent = new Component(){};
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        for (Pair<String, Integer> each : ImageLoader.getFileNames(url.toString())) {
            try {
                Image image = ImageLoader.loadFromStream(URLUtil.openStream(new URL((String)each.first)), (Integer)each.second);
                if (image != null && JBUI.isHiDPI() && !((String)each.first).contains("@2x")) {
                    image = ImageLoader.upscale(image);
                }
                return image;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @NotNull
    private static Image upscale(Image image) {
        float scale = JBUI.scale(1.0f);
        int width = (int)(scale * (float)image.getWidth(null));
        int height = (int)(scale * (float)image.getHeight(null));
        BufferedImage tmp = new BufferedImage(width, height, 2);
        Graphics2D g = tmp.createGraphics();
        g.drawImage(image, AffineTransform.getScaleInstance(scale, scale), null);
        Image image2 = image = tmp;
        if (image2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "upscale"));
        }
        return image2;
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina) {
        for (Pair<String, Integer> each : ImageLoader.getFileNames(url.toString(), dark, retina || JBUI.isHiDPI())) {
            try {
                return ImageLoader.loadFromStream(URLUtil.openStream(new URL((String)each.first)), (Integer)each.second);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        for (Pair<String, Integer> each : ImageLoader.getFileNames(path)) {
            Image image;
            InputStream stream = aClass.getResourceAsStream((String)each.first);
            if (stream == null || (image = ImageLoader.loadFromStream(stream, (Integer)each.second)) == null) continue;
            return image;
        }
        return null;
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader", "getFileNames"));
        }
        return ImageLoader.getFileNames(file, UIUtil.isUnderDarcula(), UIUtil.isRetina() || JBUI.isHiDPI());
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file, boolean dark, boolean retina) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader", "getFileNames"));
        }
        if (retina || dark) {
            ArrayList<Pair<String, Integer>> answer = new ArrayList<Pair<String, Integer>>(4);
            String name = FileUtil.getNameWithoutExtension(file);
            String ext = FileUtilRt.getExtension(file);
            if (dark && retina) {
                answer.add(Pair.create(name + "@2x_dark." + ext, 2));
            }
            if (dark) {
                answer.add(Pair.create(name + "_dark." + ext, 1));
            }
            if (retina) {
                answer.add(Pair.create(name + "@2x." + ext, 2));
            }
            answer.add(Pair.create(file, 1));
            return answer;
        }
        return Collections.singletonList(Pair.create(file, 1));
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        return ImageLoader.loadFromStream(inputStream, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must 1 or more");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            if (UIUtil.isRetina() && scale > 1) {
                image = RetinaImage.createFrom(image, scale, ourComponent);
            }
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    public static boolean isGoodSize(Icon icon) {
        return IconLoader.isGoodSize(icon);
    }
}

