/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;

public abstract class ComponentManagerImpl
extends UserDataHolderBase
implements ComponentManagerEx,
org.picocontainer.Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.components.ComponentManager");
    private boolean myComponentsCreated;
    private volatile MutablePicoContainer myPicoContainer;
    private volatile boolean myDisposed;
    private volatile boolean myDisposeCompleted;
    private MessageBus myMessageBus;
    private final ComponentManager myParentComponentManager;
    private ComponentsRegistry myComponentsRegistry;
    private final Condition myDisposedCondition;

    protected ComponentManagerImpl(@Nullable ComponentManager parentComponentManager) {
        this.myDisposedCondition = new Condition(){

            public boolean value(Object o) {
                return ComponentManagerImpl.this.isDisposed();
            }
        };
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(this.toString());
    }

    protected ComponentManagerImpl(@Nullable ComponentManager parentComponentManager, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/components/impl/ComponentManagerImpl", "<init>"));
        }
        this.myDisposedCondition = new /* invalid duplicate definition of identical inner class */;
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(name);
    }

    protected final void init(@Nullable ProgressIndicator progressIndicator) {
        this.init(progressIndicator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(@Nullable ProgressIndicator indicator, @Nullable Runnable componentsRegistered) {
        try {
            ArrayList<ComponentConfig> componentConfigs = new ArrayList<ComponentConfig>();
            this.registerComponents(componentConfigs);
            this.myComponentsRegistry = new ComponentsRegistry(componentConfigs);
            if (componentsRegistered != null) {
                componentsRegistered.run();
            }
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            this.createComponents(indicator);
        }
        finally {
            this.myComponentsCreated = true;
        }
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/components/impl/ComponentManagerImpl", "setProgressDuringInit"));
        }
        indicator.setFraction(this.getPercentageOfComponentsLoaded());
    }

    protected void createComponents(@Nullable ProgressIndicator indicator) {
        DefaultPicoContainer picoContainer = (DefaultPicoContainer)this.getPicoContainer();
        for (ComponentAdapter componentAdapter : picoContainer.getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter)) continue;
            componentAdapter.getComponentInstance((PicoContainer)picoContainer);
            if (indicator == null) continue;
            indicator.checkCanceled();
        }
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        if (this.myDisposeCompleted || this.myDisposed) {
            ProgressManager.checkCanceled();
            throw new AssertionError((Object)"Already disposed");
        }
        assert (this.myMessageBus != null) : "Not initialized yet";
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getMessageBus"));
        }
        return messageBus;
    }

    public boolean isComponentsCreated() {
        return this.myComponentsCreated;
    }

    protected final synchronized void disposeComponents() {
        assert (!this.myDisposeCompleted) : "Already disposed!";
        this.myDisposed = true;
        List components = this.myComponentsRegistry == null ? Collections.emptyList() : this.myComponentsRegistry.myBaseComponents;
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                ((BaseComponent)components.get(i)).disposeComponent();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myComponentsCreated = false;
    }

    @Override
    @Nullable
    public final <T> T getComponent(@NotNull Class<T> interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponent"));
        }
        if (this.myDisposeCompleted) {
            ProgressManager.checkCanceled();
            throw new AssertionError((Object)("Already disposed: " + this));
        }
        ComponentAdapter adapter = this.getPicoContainer().getComponentAdapter(interfaceClass);
        if (!(adapter instanceof ComponentConfigComponentAdapter)) {
            return null;
        }
        if (this.myDisposed) {
            return (T)((ComponentConfigComponentAdapter)adapter).myInitializedComponentInstance;
        }
        return (T)adapter.getComponentInstance((PicoContainer)this.getPicoContainer());
    }

    @Override
    public final <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementation) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponent"));
        }
        T component = this.getComponent(interfaceClass);
        return component == null ? defaultImplementation : component;
    }

    @Nullable
    protected ProgressIndicator getProgressIndicator() {
        return ProgressManager.getInstance().getProgressIndicator();
    }

    protected final double getPercentageOfComponentsLoaded() {
        return this.myComponentsRegistry.getPercentageOfComponentsLoaded();
    }

    @Override
    public void initializeComponent(@NotNull Object component, boolean service) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/ComponentManagerImpl", "initializeComponent"));
        }
    }

    protected void handleInitComponentError(Throwable ex, String componentClassName, PluginId pluginId) {
        LOG.error(ex);
    }

    public void registerComponentImplementation(@NotNull Class<?> componentKey, @NotNull Class<?> componentImplementation) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/openapi/components/impl/ComponentManagerImpl", "registerComponentImplementation"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/openapi/components/impl/ComponentManagerImpl", "registerComponentImplementation"));
        }
        MutablePicoContainer picoContainer = this.getPicoContainer();
        ComponentConfigComponentAdapter adapter = (ComponentConfigComponentAdapter)picoContainer.unregisterComponent(componentKey);
        LOG.assertTrue(adapter != null);
        picoContainer.registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(componentKey, componentImplementation, null, false));
    }

    public synchronized <T> T registerComponentInstance(@NotNull Class<T> componentKey, @NotNull T componentImplementation) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/openapi/components/impl/ComponentManagerImpl", "registerComponentInstance"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/openapi/components/impl/ComponentManagerImpl", "registerComponentInstance"));
        }
        MutablePicoContainer picoContainer = this.getPicoContainer();
        ComponentAdapter adapter = picoContainer.getComponentAdapter(componentKey);
        if (adapter instanceof ComponentConfigComponentAdapter) {
            ComponentConfigComponentAdapter componentAdapter = (ComponentConfigComponentAdapter)adapter;
            Object oldInstance = componentAdapter.myInitializedComponentInstance;
            componentAdapter.myInitializedComponentInstance = componentImplementation;
            return (T)oldInstance;
        }
        picoContainer.unregisterComponent(componentKey);
        picoContainer.registerComponentInstance(componentKey, componentImplementation);
        return null;
    }

    @Override
    public boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/openapi/components/impl/ComponentManagerImpl", "hasComponent"));
        }
        return this.getPicoContainer().getComponentAdapter((Object)interfaceClass) != null;
    }

    @Override
    @NotNull
    public <T> T[] getComponents(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponents"));
        }
        T[] TArray = ArrayUtil.toObjectArray(this.getComponentInstancesOfType(baseClass), baseClass);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponents"));
        }
        return TArray;
    }

    @Override
    @NotNull
    public final <T> List<T> getComponentInstancesOfType(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentInstancesOfType"));
        }
        ArrayList<Object> result = null;
        for (ComponentAdapter componentAdapter : ((DefaultPicoContainer)this.getPicoContainer()).getComponentAdapters()) {
            Object instance;
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter) || !ReflectionUtil.isAssignable(baseClass, componentAdapter.getComponentImplementation()) || (instance = ((ComponentConfigComponentAdapter)componentAdapter).myInitializedComponentInstance) == null) continue;
            if (result == null) {
                result = new ArrayList<Object>();
            }
            result.add(instance);
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentInstancesOfType"));
        }
        return list;
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer container = this.myPicoContainer;
        if (container == null || this.myDisposeCompleted) {
            ProgressManager.checkCanceled();
            throw new AssertionError((Object)("Already disposed: " + this.toString()));
        }
        MutablePicoContainer mutablePicoContainer = container;
        if (mutablePicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getPicoContainer"));
        }
        return mutablePicoContainer;
    }

    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        DefaultPicoContainer defaultPicoContainer = this.myParentComponentManager == null ? new DefaultPicoContainer() : new DefaultPicoContainer(this.myParentComponentManager.getPicoContainer());
        if (defaultPicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "createPicoContainer"));
        }
        return defaultPicoContainer;
    }

    @Override
    public synchronized BaseComponent getComponent(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponent"));
        }
        return this.myComponentsRegistry.getComponentByName(name);
    }

    protected boolean isComponentSuitable(@Nullable Map<String, String> options) {
        return options == null || ComponentManagerImpl.isComponentSuitableForOs(options.get("os")) && (!Boolean.parseBoolean(options.get("internal")) || ApplicationManager.getApplication().isInternal());
    }

    public static boolean isComponentSuitableForOs(@Nullable String os) {
        if (StringUtil.isEmpty(os)) {
            return true;
        }
        if (os.equals("mac")) {
            return SystemInfoRt.isMac;
        }
        if (os.equals("linux")) {
            return SystemInfoRt.isLinux;
        }
        if (os.equals("windows")) {
            return SystemInfoRt.isWindows;
        }
        if (os.equals("unix")) {
            return SystemInfoRt.isUnix;
        }
        if (os.equals("freebsd")) {
            return SystemInfoRt.isFreeBSD;
        }
        LOG.warn("Unknown OS " + os);
        return true;
    }

    @Override
    public synchronized void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposeCompleted = true;
        if (this.myMessageBus != null) {
            this.myMessageBus.dispose();
            this.myMessageBus = null;
        }
        this.myComponentsRegistry = null;
        this.myPicoContainer = null;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    private void registerComponents(@NotNull ArrayList<ComponentConfig> componentConfigs) {
        if (componentConfigs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentConfigs", "com/intellij/openapi/components/impl/ComponentManagerImpl", "registerComponents"));
        }
        boolean isDefaultProject = this instanceof Project && ((Project)((Object)this)).isDefault();
        boolean headless = ApplicationManager.getApplication().isHeadlessEnvironment();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
            if (PluginManagerCore.shouldSkipPlugin(plugin)) continue;
            ComponentConfig[] configs = this.getMyComponentConfigsFromDescriptor(plugin);
            componentConfigs.ensureCapacity(componentConfigs.size() + configs.length);
            for (ComponentConfig config : configs) {
                if (isDefaultProject && !config.isLoadForDefaultProject() || !this.isComponentSuitable(config.options) || !config.prepareClasses(headless)) continue;
                config.pluginDescriptor = plugin;
                componentConfigs.add(config);
            }
        }
    }

    @NotNull
    public ComponentConfig[] getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getMyComponentConfigsFromDescriptor"));
        }
        ComponentConfig[] componentConfigArray = plugin.getAppComponents();
        if (componentConfigArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getMyComponentConfigsFromDescriptor"));
        }
        return componentConfigArray;
    }

    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/components/impl/ComponentManagerImpl", "bootstrapPicoContainer"));
        }
        this.myPicoContainer = this.createPicoContainer();
        this.myMessageBus = MessageBusFactory.newMessageBus(name, this.myParentComponentManager == null ? null : this.myParentComponentManager.getMessageBus());
        MutablePicoContainer picoContainer = this.getPicoContainer();
        picoContainer.registerComponentInstance(MessageBus.class, (Object)this.myMessageBus);
    }

    protected ComponentManager getParentComponentManager() {
        return this.myParentComponentManager;
    }

    protected final int getComponentConfigurationsSize() {
        return this.myComponentsRegistry.myComponentConfigCount;
    }

    @Nullable
    public final PluginId getConfig(@NotNull Class<?> componentImplementation) {
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getConfig"));
        }
        ComponentConfigComponentAdapter adapter = this.getComponentAdapter(componentImplementation);
        return adapter == null ? null : adapter.myPluginId;
    }

    public final boolean isWorkspaceComponent(@NotNull Class<?> componentImplementation) {
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/openapi/components/impl/ComponentManagerImpl", "isWorkspaceComponent"));
        }
        ComponentConfigComponentAdapter adapter = this.getComponentAdapter(componentImplementation);
        return adapter != null && adapter.isWorkspaceComponent;
    }

    @Nullable
    private ComponentConfigComponentAdapter getComponentAdapter(@NotNull Class<?> componentImplementation) {
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentAdapter"));
        }
        for (ComponentAdapter componentAdapter : ((DefaultPicoContainer)this.getPicoContainer()).getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter) || componentAdapter.getComponentImplementation() != componentImplementation) continue;
            return (ComponentConfigComponentAdapter)componentAdapter;
        }
        return null;
    }

    @Override
    @NotNull
    public Condition getDisposed() {
        Condition condition = this.myDisposedCondition;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getDisposed"));
        }
        return condition;
    }

    @NotNull
    public static String getComponentName(@NotNull Object component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentName"));
        }
        if (component instanceof NamedComponent) {
            String string = ((NamedComponent)component).getComponentName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentName"));
            }
            return string;
        }
        String string = component.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ComponentManagerImpl", "getComponentName"));
        }
        return string;
    }

    protected boolean logSlowComponents() {
        return LOG.isDebugEnabled();
    }

    private class ComponentConfigComponentAdapter
    extends ConstructorInjectionComponentAdapter {
        private final PluginId myPluginId;
        private volatile Object myInitializedComponentInstance;
        private boolean myInitializing;
        final boolean isWorkspaceComponent;

        public ComponentConfigComponentAdapter(@NotNull Class<?> interfaceClass, @Nullable Class<?> implementationClass, PluginId pluginId, boolean isWorkspaceComponent) {
            if (interfaceClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/openapi/components/impl/ComponentManagerImpl$ComponentConfigComponentAdapter", "<init>"));
            }
            if (implementationClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementationClass", "com/intellij/openapi/components/impl/ComponentManagerImpl$ComponentConfigComponentAdapter", "<init>"));
            }
            super(interfaceClass, implementationClass, null, true);
            this.myPluginId = pluginId;
            this.isWorkspaceComponent = isWorkspaceComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, ProcessCanceledException {
            Object instance = this.myInitializedComponentInstance;
            if (instance != null) {
                return instance;
            }
            try {
                ComponentConfigComponentAdapter componentConfigComponentAdapter = this;
                synchronized (componentConfigComponentAdapter) {
                    instance = this.myInitializedComponentInstance;
                    if (instance != null) {
                        return instance;
                    }
                    long startTime = System.nanoTime();
                    instance = super.getComponentInstance(picoContainer);
                    if (this.myInitializing) {
                        String errorMessage = "Cyclic component initialization: " + this.getComponentKey();
                        if (this.myPluginId != null) {
                            LOG.error(new PluginException(errorMessage, this.myPluginId));
                        } else {
                            LOG.error(new Throwable(errorMessage));
                        }
                    }
                    try {
                        long ms;
                        this.myInitializing = true;
                        ComponentManagerImpl.this.myComponentsRegistry.registerComponentInstance(instance);
                        ProgressIndicator indicator = ComponentManagerImpl.this.getProgressIndicator();
                        if (indicator != null) {
                            indicator.checkCanceled();
                            ComponentManagerImpl.this.setProgressDuringInit(indicator);
                        }
                        ComponentManagerImpl.this.initializeComponent(instance, false);
                        if (instance instanceof BaseComponent) {
                            ((BaseComponent)instance).initComponent();
                        }
                        if ((ms = (System.nanoTime() - startTime) / 1000000L) > 10L && ComponentManagerImpl.this.logSlowComponents()) {
                            LOG.info(instance.getClass().getName() + " initialized in " + ms + " ms");
                        }
                    }
                    finally {
                        this.myInitializing = false;
                    }
                    this.myInitializedComponentInstance = instance;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (StateStorageException e) {
                throw e;
            }
            catch (Throwable t) {
                ComponentManagerImpl.this.handleInitComponentError(t, ((Class)this.getComponentKey()).getName(), this.myPluginId);
            }
            return instance;
        }

        public String toString() {
            return "ComponentConfigAdapter[" + this.getComponentKey() + "]: implementation=" + this.getComponentImplementation() + ", plugin=" + this.myPluginId;
        }
    }

    private class ComponentsRegistry {
        private final Map<String, BaseComponent> myNameToComponent;
        private final int myComponentConfigCount;
        private int myInstantiatedComponentCount;
        private final List<BaseComponent> myBaseComponents;

        public ComponentsRegistry(List<ComponentConfig> componentConfigs) {
            if (componentConfigs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentConfigs", "com/intellij/openapi/components/impl/ComponentManagerImpl$ComponentsRegistry", "<init>"));
            }
            this.myNameToComponent = new THashMap();
            this.myBaseComponents = new ArrayList<BaseComponent>();
            for (ComponentConfig config : componentConfigs) {
                this.registerComponents(config);
            }
            this.myComponentConfigCount = componentConfigs.size();
        }

        private void registerComponents(@NotNull ComponentConfig config) {
            if (config == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/openapi/components/impl/ComponentManagerImpl$ComponentsRegistry", "registerComponents"));
            }
            ClassLoader loader = config.getClassLoader();
            try {
                Class<?> interfaceClass = Class.forName(config.getInterfaceClass(), true, loader);
                Class<?> implementationClass = Comparing.equal(config.getInterfaceClass(), config.getImplementationClass()) ? interfaceClass : (StringUtil.isEmpty(config.getImplementationClass()) ? null : Class.forName(config.getImplementationClass(), true, loader));
                MutablePicoContainer picoContainer = ComponentManagerImpl.this.getPicoContainer();
                if (config.options != null && Boolean.parseBoolean(config.options.get("overrides"))) {
                    ComponentAdapter oldAdapter = picoContainer.getComponentAdapterOfType(interfaceClass);
                    if (oldAdapter == null) {
                        throw new RuntimeException(config + " does not override anything");
                    }
                    picoContainer.unregisterComponent(oldAdapter.getComponentKey());
                }
                if (implementationClass != null) {
                    picoContainer.registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(interfaceClass, implementationClass, config.getPluginId(), config.options != null && Boolean.parseBoolean(config.options.get("workspace"))));
                }
            }
            catch (Throwable t) {
                ComponentManagerImpl.this.handleInitComponentError(t, null, config.getPluginId());
            }
        }

        private double getPercentageOfComponentsLoaded() {
            return (double)this.myInstantiatedComponentCount / (double)this.myComponentConfigCount;
        }

        private void registerComponentInstance(@NotNull Object instance) {
            if (instance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/components/impl/ComponentManagerImpl$ComponentsRegistry", "registerComponentInstance"));
            }
            ++this.myInstantiatedComponentCount;
            if (instance instanceof Disposable) {
                Disposer.register(ComponentManagerImpl.this, (Disposable)instance);
            }
            if (!(instance instanceof BaseComponent)) {
                return;
            }
            BaseComponent baseComponent = (BaseComponent)instance;
            String componentName = baseComponent.getComponentName();
            if (this.myNameToComponent.containsKey(componentName)) {
                BaseComponent loadedComponent = this.myNameToComponent.get(componentName);
                if (!instance.equals(loadedComponent)) {
                    LOG.error("Component name collision: " + componentName + " " + loadedComponent.getClass() + " and " + instance.getClass());
                }
            } else {
                this.myNameToComponent.put(componentName, baseComponent);
            }
            this.myBaseComponents.add(baseComponent);
        }

        private BaseComponent getComponentByName(String name) {
            return this.myNameToComponent.get(name);
        }
    }
}

