/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class SchemesManagerFactory {
    @NotNull
    public abstract <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(@NotNull String var1, @NotNull SchemeProcessor<E> var2, @NotNull RoamingType var3);

    @NotNull
    public final <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> create(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        SchemesManager<T, E> schemesManager = this.createSchemesManager(directoryName, processor, RoamingType.PER_USER);
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        return schemesManager;
    }

    @NotNull
    public static SchemesManagerFactory getInstance() {
        SchemesManagerFactory schemesManagerFactory = ServiceManager.getService(SchemesManagerFactory.class);
        if (schemesManagerFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactory", "getInstance"));
        }
        return schemesManagerFactory;
    }

    @NotNull
    public static SchemesManagerFactory getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/SchemesManagerFactory", "getInstance"));
        }
        SchemesManagerFactory schemesManagerFactory = ServiceManager.getService(project, SchemesManagerFactory.class);
        if (schemesManagerFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactory", "getInstance"));
        }
        return schemesManagerFactory;
    }
}

