/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentBitSet;
import gnu.trove.TLongFunction;

public class ConcurrentPackedBitsArray {
    private final int bitsPerChunk;
    private final ConcurrentBitSet bits = new ConcurrentBitSet();
    private final long mask;
    private final int chunksPerWord;

    public ConcurrentPackedBitsArray(int bitsPerChunk) {
        if (bitsPerChunk <= 0 || bitsPerChunk > 64) {
            throw new IllegalArgumentException("Bits-to-pack number must be between 1 and 64, but got: " + bitsPerChunk);
        }
        this.bitsPerChunk = bitsPerChunk;
        this.mask = (1 << bitsPerChunk) - 1;
        this.chunksPerWord = 64 / bitsPerChunk;
    }

    public long get(int id) {
        int bitIndex = id / this.chunksPerWord * 64 + id % this.chunksPerWord * this.bitsPerChunk;
        long word = this.bits.getWord(bitIndex) >> bitIndex;
        return word;
    }

    public long set(int id, final long flags) {
        if ((flags & (this.mask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException("Flags must be between 0 and " + this.mask + " but got:" + flags);
        }
        final int bitIndex = id / this.chunksPerWord * 64 + id % this.chunksPerWord * this.bitsPerChunk;
        long prevChunk = this.bits.changeWord(bitIndex, new TLongFunction(){

            public long execute(long word) {
                return word & (ConcurrentPackedBitsArray.this.mask << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | flags << bitIndex;
            }
        }) >> bitIndex;
        return prevChunk;
    }

    public void clear() {
        this.bits.clear();
    }
}

