/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.lang.MemoryResource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

public class JarMemoryLoader {
    public static final String SIZE_ENTRY = "META-INF/jb/$$size$$";
    private final Map<String, Resource> myResources = Collections.synchronizedMap(new HashMap());

    private JarMemoryLoader() {
    }

    public Resource getResource(String entryName) {
        return this.myResources.remove(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static JarMemoryLoader load(File file, URL baseUrl) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            JarMemoryLoader jarMemoryLoader = JarMemoryLoader.load(zipFile, baseUrl);
            return jarMemoryLoader;
        }
        finally {
            zipFile.close();
        }
    }

    @Nullable
    public static JarMemoryLoader load(ZipFile zipFile, URL baseUrl) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        if (!entries.hasMoreElements()) {
            return null;
        }
        ZipEntry sizeEntry = entries.nextElement();
        if (sizeEntry == null || !sizeEntry.getName().equals(SIZE_ENTRY)) {
            return null;
        }
        byte[] bytes = FileUtilRt.loadBytes(zipFile.getInputStream(sizeEntry), 2);
        int size = ((bytes[1] & 0xFF) << 8) + (bytes[0] & 0xFF);
        JarMemoryLoader loader = new JarMemoryLoader();
        for (int i = 0; i < size && entries.hasMoreElements(); ++i) {
            ZipEntry entry = entries.nextElement();
            MemoryResource resource = MemoryResource.load(baseUrl, zipFile, entry);
            loader.myResources.put(entry.getName(), resource);
        }
        return loader;
    }
}

