/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class RemoveAttributeIntentionAction
implements LocalQuickFix {
    private final String myLocalName;

    public RemoveAttributeIntentionAction(String localName) {
        this.myLocalName = localName;
    }

    @Override
    @NotNull
    public String getName() {
        String string = XmlErrorMessages.message("remove.attribute.quickfix.text", this.myLocalName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RemoveAttributeIntentionAction", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RemoveAttributeIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/RemoveAttributeIntentionAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/RemoveAttributeIntentionAction", "applyFix"));
        }
        PsiElement e = descriptor.getPsiElement();
        final XmlAttribute myAttribute = PsiTreeUtil.getParentOfType(e, XmlAttribute.class);
        if (myAttribute == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(myAttribute.getContainingFile())) {
            return;
        }
        new WriteCommandAction(project, new PsiFile[0]){

            @Override
            protected void run(Result result) throws Throwable {
                myAttribute.delete();
            }
        }.execute();
    }
}

