/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class EmptyStatementBodyInspection
extends BaseInspection {
    public boolean m_reportEmptyBlocks = true;
    public boolean commentsAreContent = false;

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/bugs/EmptyStatementBodyInspection", "writeSettings"));
        }
        node.addContent(new Element("option").setAttribute("name", "m_reportEmptyBlocks").setAttribute("value", String.valueOf(this.m_reportEmptyBlocks)));
        if (this.commentsAreContent) {
            node.addContent(new Element("option").setAttribute("name", "commentsAreContent").setAttribute("value", "true"));
        }
    }

    @Override
    @NotNull
    public String getID() {
        if ("StatementWithEmptyBody" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyStatementBodyInspection", "getID"));
        }
        return "StatementWithEmptyBody";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyStatementBodyInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyStatementBodyInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("statement.with.empty.body.include.option", new Object[0]), "m_reportEmptyBlocks");
        panel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.comments.option", new Object[0]), "commentsAreContent");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyStatementVisitor();
    }

    private class EmptyStatementVisitor
    extends BaseInspectionVisitor {
        private EmptyStatementVisitor() {
        }

        @Override
        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitDoWhileStatement"));
            }
            super.visitDoWhileStatement(statement);
            this.checkLoopStatement(statement);
        }

        @Override
        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitWhileStatement"));
            }
            super.visitWhileStatement(statement);
            this.checkLoopStatement(statement);
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement);
            this.checkLoopStatement(statement);
        }

        @Override
        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitForeachStatement"));
            }
            super.visitForeachStatement(statement);
            this.checkLoopStatement(statement);
        }

        private void checkLoopStatement(PsiLoopStatement statement) {
            if (FileTypeUtils.isInServerPageFile(statement)) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (body == null || !this.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(statement);
            if (FileTypeUtils.isInServerPageFile(statement)) {
                return;
            }
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch != null && this.isEmpty(thenBranch)) {
                this.registerStatementError(statement, new Object[0]);
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch != null && this.isEmpty(elseBranch)) {
                PsiKeyword elseToken = statement.getElseElement();
                if (elseToken == null) {
                    return;
                }
                this.registerError((PsiElement)elseToken, new Object[0]);
            }
        }

        @Override
        public void visitSwitchStatement(PsiSwitchStatement statement) {
            super.visitSwitchStatement(statement);
            if (FileTypeUtils.isInServerPageFile(statement)) {
                return;
            }
            PsiCodeBlock body = statement.getBody();
            if (body == null || !this.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private boolean isEmpty(PsiElement element) {
            if (!EmptyStatementBodyInspection.this.commentsAreContent && element instanceof PsiComment) {
                return true;
            }
            if (element instanceof PsiEmptyStatement) {
                if (EmptyStatementBodyInspection.this.commentsAreContent) {
                    PsiElement[] children;
                    for (PsiElement child : children = element.getChildren()) {
                        if (!(child instanceof PsiComment)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (element instanceof PsiWhiteSpace) {
                return true;
            }
            if (element instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)element;
                return this.isEmpty(block.getCodeBlock());
            }
            if (EmptyStatementBodyInspection.this.m_reportEmptyBlocks && element instanceof PsiCodeBlock) {
                PsiCodeBlock codeBlock = (PsiCodeBlock)element;
                PsiElement[] children = codeBlock.getChildren();
                if (children.length == 2) {
                    return true;
                }
                for (int i = 1; i < children.length - 1; ++i) {
                    PsiElement child = children[i];
                    if (this.isEmpty(child)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

