/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntegerMultiplicationImplicitCastToLongInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> s_typesToCheck = new HashSet<String>(4);
    public boolean ignoreNonOverflowingCompileTimeConstants = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        IElementType tokenType = (IElementType)infos[0];
        if (JavaTokenType.ASTERISK.equals(tokenType)) {
            String string = InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("integer.shift.implicit.cast.to.long.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.option", new Object[0]), this, "ignoreNonOverflowingCompileTimeConstants");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerMultiplicationImplicitlyCastToLongVisitor();
    }

    static {
        s_typesToCheck.add("int");
        s_typesToCheck.add("short");
        s_typesToCheck.add("byte");
        s_typesToCheck.add("char");
        s_typesToCheck.add("java.lang.Integer");
        s_typesToCheck.add("java.lang.Short");
        s_typesToCheck.add("java.lang.Byte");
        s_typesToCheck.add("java.lang.Character");
    }

    private class IntegerMultiplicationImplicitlyCastToLongVisitor
    extends BaseInspectionVisitor {
        private IntegerMultiplicationImplicitlyCastToLongVisitor() {
        }

        @Override
        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection$IntegerMultiplicationImplicitlyCastToLongVisitor", "visitPolyadicExpression"));
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ASTERISK) && !tokenType.equals(JavaTokenType.LTLT)) {
                return;
            }
            PsiType type = expression.getType();
            if (!this.isNonLongInteger(type)) {
                return;
            }
            if (expression.getOperands().length < 2 || expression.getLastChild() instanceof PsiErrorElement) {
                return;
            }
            PsiExpression context = this.getContainingExpression(expression);
            if (context == null) {
                return;
            }
            PsiType contextType = ExpectedTypeUtils.findExpectedType(context, true);
            if (contextType == null) {
                return;
            }
            if (!contextType.equals(PsiType.LONG)) {
                return;
            }
            if (IntegerMultiplicationImplicitCastToLongInspection.this.ignoreNonOverflowingCompileTimeConstants) {
                try {
                    if (ExpressionUtils.computeConstantExpression(expression, true) != null) {
                        return;
                    }
                }
                catch (ConstantEvaluationOverflowException constantEvaluationOverflowException) {
                    // empty catch block
                }
            }
            this.registerError((PsiElement)expression, tokenType);
        }

        private PsiExpression getContainingExpression(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiBinaryExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
                return this.getContainingExpression((PsiExpression)parent);
            }
            return expression;
        }

        private boolean isNonLongInteger(PsiType type) {
            if (type == null) {
                return false;
            }
            String text = type.getCanonicalText();
            return text != null && s_typesToCheck.contains(text);
        }
    }
}

