/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.ArrayContentsAccessedVisitor;
import com.siyeh.ig.psiutils.ArrayContentsAssignedVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAssignedFromVisitor;
import com.siyeh.ig.psiutils.VariableAssignedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentExcludedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.VariableReturnedVisitor;
import com.siyeh.ig.psiutils.VariableUsedInArrayInitializerVisitor;
import com.siyeh.ig.psiutils.VariableUsedInInnerClassVisitor;
import com.siyeh.ig.psiutils.VariableUsedVisitor;
import com.siyeh.ig.psiutils.VariableValueUsedVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableAccessUtils {
    private VariableAccessUtils() {
    }

    public static boolean variableIsAssignedFrom(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsAssignedFrom"));
        }
        if (context == null) {
            return false;
        }
        VariableAssignedFromVisitor visitor = new VariableAssignedFromVisitor(variable);
        context.accept(visitor);
        return visitor.isAssignedFrom();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsPassedAsMethodArgument"));
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentVisitor visitor = new VariablePassedAsArgumentVisitor(variable);
        context.accept(visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context, Processor<PsiCall> callProcessor) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsPassedAsMethodArgument"));
        }
        return VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context, false, callProcessor);
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean builderPattern, Processor<PsiCall> callProcessor) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsPassedAsMethodArgument"));
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentExcludedVisitor visitor = new VariablePassedAsArgumentExcludedVisitor(variable, builderPattern, callProcessor);
        context.accept(visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsUsedInArrayInitializer(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsUsedInArrayInitializer"));
        }
        if (context == null) {
            return false;
        }
        VariableUsedInArrayInitializerVisitor visitor = new VariableUsedInArrayInitializerVisitor(variable);
        context.accept(visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsAssigned"));
        }
        if (variable instanceof PsiField) {
            if (variable.hasModifierProperty("private")) {
                PsiClass aClass = PsiUtil.getTopLevelClass(variable);
                return VariableAccessUtils.variableIsAssigned(variable, aClass);
            }
            return !ReferencesSearch.search(variable, variable.getUseScope()).forEach(new Processor<PsiReference>(){

                @Override
                public boolean process(PsiReference reference) {
                    PsiElement element = reference.getElement();
                    if (!(element instanceof PsiExpression)) {
                        return true;
                    }
                    PsiExpression expression = (PsiExpression)element;
                    return !PsiUtil.isAccessedForWriting(expression);
                }
            });
        }
        Object context = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, PsiMethod.class, PsiLambdaExpression.class, PsiCatchSection.class, PsiForStatement.class, PsiForeachStatement.class);
        return VariableAccessUtils.variableIsAssigned(variable, context);
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsAssigned"));
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variable, true);
        context.accept(visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean recurseIntoClasses) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsAssigned"));
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variable, recurseIntoClasses);
        context.accept(visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsReturned"));
        }
        return VariableAccessUtils.variableIsReturned(variable, context, false);
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean builderPattern) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsReturned"));
        }
        if (context == null) {
            return false;
        }
        VariableReturnedVisitor visitor = new VariableReturnedVisitor(variable, builderPattern);
        context.accept(visitor);
        return visitor.isReturned();
    }

    public static boolean variableValueIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableValueIsUsed"));
        }
        if (context == null) {
            return false;
        }
        VariableValueUsedVisitor visitor = new VariableValueUsedVisitor(variable);
        context.accept(visitor);
        return visitor.isVariableValueUsed();
    }

    public static boolean arrayContentsAreAccessed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "arrayContentsAreAccessed"));
        }
        if (context == null) {
            return false;
        }
        ArrayContentsAccessedVisitor visitor = new ArrayContentsAccessedVisitor(variable);
        context.accept(visitor);
        return visitor.isAccessed();
    }

    public static boolean arrayContentsAreAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "arrayContentsAreAssigned"));
        }
        if (context == null) {
            return false;
        }
        ArrayContentsAssignedVisitor visitor = new ArrayContentsAssignedVisitor(variable);
        context.accept(visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsUsedInInnerClass(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsUsedInInnerClass"));
        }
        if (context == null) {
            return false;
        }
        VariableUsedInInnerClassVisitor visitor = new VariableUsedInInnerClassVisitor(variable);
        context.accept(visitor);
        return visitor.isUsedInInnerClass();
    }

    public static boolean mayEvaluateToVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "mayEvaluateToVariable"));
        }
        return VariableAccessUtils.mayEvaluateToVariable(expression, variable, false);
    }

    public static boolean mayEvaluateToVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable, boolean builderPattern) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "mayEvaluateToVariable"));
        }
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression containedExpression = parenthesizedExpression.getExpression();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable, builderPattern);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            PsiExpression containedExpression = typeCastExpression.getOperand();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable, builderPattern);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            PsiExpression thenExpression = conditional.getThenExpression();
            PsiExpression elseExpression = conditional.getElseExpression();
            return VariableAccessUtils.mayEvaluateToVariable(thenExpression, variable, builderPattern) || VariableAccessUtils.mayEvaluateToVariable(elseExpression, variable, builderPattern);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                return false;
            }
            PsiType type = variable.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            int dimensions = arrayType.getArrayDimensions();
            if (dimensions <= 1) {
                return false;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            int count = 1;
            while (arrayExpression instanceof PsiArrayAccessExpression) {
                arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
                arrayExpression = arrayAccessExpression.getArrayExpression();
                ++count;
            }
            return count != dimensions && VariableAccessUtils.mayEvaluateToVariable(arrayExpression, variable, builderPattern);
        }
        if (builderPattern && expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            PsiType variableType = variable.getType();
            if (!variableType.equals(returnType)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return VariableAccessUtils.mayEvaluateToVariable(qualifier, variable, builderPattern);
        }
        return VariableAccessUtils.evaluatesToVariable(expression, variable);
    }

    public static boolean evaluatesToVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "evaluatesToVariable"));
        }
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement target = referenceExpression.resolve();
        return variable.equals(target);
    }

    public static boolean variableIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsUsed"));
        }
        if (context == null) {
            return false;
        }
        VariableUsedVisitor visitor = new VariableUsedVisitor(variable);
        context.accept(visitor);
        return visitor.isUsed();
    }

    public static boolean variableIsDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsDecremented"));
        }
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable, statement, false);
    }

    public static boolean variableIsIncremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsIncremented"));
        }
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable, statement, true);
    }

    private static boolean variableIsIncrementedOrDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement, boolean incremented) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsIncrementedOrDecremented"));
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (incremented ? !tokenType.equals(JavaTokenType.PLUSPLUS) : !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand = prefixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable);
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            IElementType tokenType = postfixExpression.getOperationTokenType();
            if (incremented ? !tokenType.equals(JavaTokenType.PLUSPLUS) : !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand = postfixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = ParenthesesUtils.stripParentheses(rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType binaryTokenType = binaryExpression.getOperationTokenType();
                if (incremented ? binaryTokenType != JavaTokenType.PLUS : binaryTokenType != JavaTokenType.MINUS) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isOne(lOperand) ? VariableAccessUtils.evaluatesToVariable(rOperand, variable) : ExpressionUtils.isOne(rOperand) && VariableAccessUtils.evaluatesToVariable(lOperand, variable)) {
                    return true;
                }
            } else if ((incremented ? tokenType == JavaTokenType.PLUSEQ : tokenType == JavaTokenType.MINUSEQ) && ExpressionUtils.isOne(rhs)) {
                return true;
            }
        }
        return false;
    }

    public static boolean variableIsAssignedBeforeReference(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiElement context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsAssignedBeforeReference"));
        }
        if (context == null) {
            return false;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)target;
        return VariableAccessUtils.variableIsAssignedAtPoint(variable, context, referenceExpression);
    }

    public static boolean variableIsAssignedAtPoint(@NotNull PsiVariable variable, @Nullable PsiElement context, @NotNull PsiElement point) {
        PsiElement[] children;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsAssignedAtPoint"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/siyeh/ig/psiutils/VariableAccessUtils", "variableIsAssignedAtPoint"));
        }
        if (context == null) {
            return false;
        }
        PsiElement directChild = VariableAccessUtils.getDirectChildWhichContainsElement(context, point);
        if (directChild == null) {
            return false;
        }
        for (PsiElement child : children = context.getChildren()) {
            if (child == directChild) {
                return VariableAccessUtils.variableIsAssignedAtPoint(variable, directChild, point);
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getDirectChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/siyeh/ig/psiutils/VariableAccessUtils", "getDirectChildWhichContainsElement"));
        }
        if (descendant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendant", "com/siyeh/ig/psiutils/VariableAccessUtils", "getDirectChildWhichContainsElement"));
        }
        if (ancestor == descendant) {
            return null;
        }
        PsiElement child = descendant;
        PsiElement parent = child.getParent();
        while (!parent.equals(ancestor)) {
            child = parent;
            if ((parent = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }

    public static Set<PsiVariable> collectUsedVariables(PsiElement context) {
        if (context == null) {
            return Collections.emptySet();
        }
        VariableCollectingVisitor visitor = new VariableCollectingVisitor();
        context.accept(visitor);
        return visitor.getUsedVariables();
    }

    public static boolean isAnyVariableAssigned(@NotNull Collection<PsiVariable> variables, @Nullable PsiElement context) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/siyeh/ig/psiutils/VariableAccessUtils", "isAnyVariableAssigned"));
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variables, true);
        context.accept(visitor);
        return visitor.isAssigned();
    }

    private static class VariableCollectingVisitor
    extends JavaRecursiveElementVisitor {
        private final Set<PsiVariable> usedVariables = new HashSet<PsiVariable>();

        private VariableCollectingVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            this.usedVariables.add(variable);
        }

        public Set<PsiVariable> getUsedVariables() {
            return this.usedVariables;
        }
    }
}

