/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsLoaderBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetSerializer;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleClasspathSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationSerializer;
import org.jetbrains.jps.service.SharedThreadPool;

public class JpsProjectLoader
extends JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsProjectLoader.class);
    private static final BoundedTaskExecutor ourThreadPool = new BoundedTaskExecutor(SharedThreadPool.getInstance(), Runtime.getRuntime().availableProcessors());
    public static final String CLASSPATH_ATTRIBUTE = "classpath";
    public static final String CLASSPATH_DIR_ATTRIBUTE = "classpath-dir";
    private final JpsProject myProject;
    private final Map<String, String> myPathVariables;

    private JpsProjectLoader(JpsProject project, Map<String, String> pathVariables, File baseDir) {
        super(JpsProjectLoader.createProjectMacroExpander(pathVariables, baseDir));
        this.myProject = project;
        this.myPathVariables = pathVariables;
        this.myProject.getContainer().setChild(JpsProjectSerializationDataExtensionImpl.ROLE, new JpsProjectSerializationDataExtensionImpl(baseDir));
    }

    static JpsMacroExpander createProjectMacroExpander(Map<String, String> pathVariables, File baseDir) {
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        expander.addFileHierarchyReplacements("PROJECT_DIR", baseDir);
        return expander;
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, String projectPath) throws IOException {
        File file = new File(FileUtil.toCanonicalPath(projectPath));
        if (file.isFile() && projectPath.endsWith(".ipr")) {
            new JpsProjectLoader(project, pathVariables, file.getParentFile()).loadFromIpr(file);
        } else {
            File directory;
            File dotIdea = new File(file, ".idea");
            if (dotIdea.isDirectory()) {
                directory = dotIdea;
            } else if (file.isDirectory() && file.getName().equals(".idea")) {
                directory = file;
            } else {
                throw new IOException("Cannot find IntelliJ IDEA project files at " + projectPath);
            }
            new JpsProjectLoader(project, pathVariables, directory.getParentFile()).loadFromDirectory(directory);
        }
    }

    public static String getDirectoryBaseProjectName(File dir) {
        File nameFile = new File(dir, ".name");
        if (nameFile.isFile()) {
            try {
                return FileUtilRt.loadFile(nameFile).trim();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return dir.getParentFile().getName();
    }

    /*
     * WARNING - void declaration
     */
    private void loadFromDirectory(File dir) {
        void var6_12;
        this.myProject.setName(JpsProjectLoader.getDirectoryBaseProjectName(dir));
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(this.loadRootElement(new File(dir, "misc.xml")));
        for (JpsModelSerializerExtension jpsModelSerializerExtension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : jpsModelSerializerExtension.getProjectExtensionSerializers()) {
                this.loadComponents(dir, "misc.xml", jpsProjectExtensionSerializer, this.myProject);
            }
        }
        this.loadModules(this.loadRootElement(new File(dir, "modules.xml")), projectSdkType);
        Runnable timingLog = TimingLog.startActivity("loading project libraries");
        File[] fileArray = JpsProjectLoader.listXmlFiles(new File(dir, "libraries"));
        int n = fileArray.length;
        boolean bl = false;
        while (var6_12 < n) {
            File libraryFile = fileArray[var6_12];
            this.loadProjectLibraries(this.loadRootElement(libraryFile));
            ++var6_12;
        }
        timingLog.run();
        Runnable runnable = TimingLog.startActivity("loading artifacts");
        for (File artifactFile : JpsProjectLoader.listXmlFiles(new File(dir, "artifacts"))) {
            this.loadArtifacts(this.loadRootElement(artifactFile));
        }
        runnable.run();
        if (JpsProjectLoader.hasRunConfigurationSerializers()) {
            Runnable runConfTimingLog = TimingLog.startActivity("loading run configurations");
            for (File configurationFile : JpsProjectLoader.listXmlFiles(new File(dir, "runConfigurations"))) {
                JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, this.loadRootElement(configurationFile));
            }
            File file = new File(dir, "workspace.xml");
            if (file.exists()) {
                Element runManager = JDomSerializationUtil.findComponent(this.loadRootElement(file), "RunManager");
                JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, runManager);
            }
            runConfTimingLog.run();
        }
    }

    private static boolean hasRunConfigurationSerializers() {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            if (extension.getRunConfigurationPropertiesSerializers().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static File[] listXmlFiles(File dir) {
        File[] files = dir.listFiles(FileFilters.filesWithExtension("xml"));
        File[] fileArray = files != null ? files : ArrayUtil.EMPTY_FILE_ARRAY;
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "listXmlFiles"));
        }
        return fileArray;
    }

    private void loadFromIpr(File iprFile) {
        Element iprRoot = this.loadRootElement(iprFile);
        String projectName = FileUtil.getNameWithoutExtension(iprFile);
        this.myProject.setName(projectName);
        File iwsFile = new File(iprFile.getParent(), projectName + ".iws");
        Element iwsRoot = iwsFile.exists() ? this.loadRootElement(iwsFile) : null;
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(iprRoot);
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                Element rootTag = "workspace.xml".equals(jpsProjectExtensionSerializer.getConfigFileName()) ? iwsRoot : iprRoot;
                Element component = JDomSerializationUtil.findComponent(rootTag, jpsProjectExtensionSerializer.getComponentName());
                if (component != null) {
                    jpsProjectExtensionSerializer.loadExtension(this.myProject, component);
                    continue;
                }
                jpsProjectExtensionSerializer.loadExtensionWithDefaultSettings(this.myProject);
            }
        }
        this.loadModules(iprRoot, projectSdkType);
        this.loadProjectLibraries(JDomSerializationUtil.findComponent(iprRoot, "libraryTable"));
        this.loadArtifacts(JDomSerializationUtil.findComponent(iprRoot, "ArtifactManager"));
        if (JpsProjectLoader.hasRunConfigurationSerializers()) {
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(iprRoot, "ProjectRunConfigurationManager"));
            JpsRunConfigurationSerializer.loadRunConfigurations(this.myProject, JDomSerializationUtil.findComponent(iwsRoot, "RunManager"));
        }
    }

    private void loadArtifacts(@Nullable Element artifactManagerComponent) {
        JpsArtifactSerializer.loadArtifacts(this.myProject, artifactManagerComponent);
    }

    @Nullable
    private JpsSdkType<?> loadProjectRoot(Element root) {
        JpsSdkType<?> sdkType = null;
        Element rootManagerElement = JDomSerializationUtil.findComponent(root, "ProjectRootManager");
        if (rootManagerElement != null) {
            String sdkName = rootManagerElement.getAttributeValue("project-jdk-name");
            String sdkTypeId = rootManagerElement.getAttributeValue("project-jdk-type");
            if (sdkName != null) {
                sdkType = JpsSdkTableSerializer.getSdkType(sdkTypeId);
                JpsSdkTableSerializer.setSdkReference(this.myProject.getSdkReferencesTable(), sdkName, sdkType);
            }
        }
        return sdkType;
    }

    private void loadProjectLibraries(@Nullable Element libraryTableElement) {
        JpsLibraryTableSerializer.loadLibraries(libraryTableElement, this.myProject.getLibraryCollection());
    }

    private void loadModules(Element root, @Nullable JpsSdkType<?> projectSdkType) {
        Runnable timingLog = TimingLog.startActivity("loading modules");
        Element componentRoot = JDomSerializationUtil.findComponent(root, "ProjectModuleManager");
        if (componentRoot == null) {
            return;
        }
        THashSet moduleFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (Element moduleElement : JDOMUtil.getChildren(componentRoot.getChild("modules"), "module")) {
            String path = moduleElement.getAttributeValue("filepath");
            File file = new File(path);
            if (file.exists()) {
                moduleFiles.add(file);
                continue;
            }
            LOG.info("Module '" + FileUtil.getNameWithoutExtension(file) + "' is skipped: " + file.getAbsolutePath() + " doesn't exist");
        }
        List<JpsModule> modules = JpsProjectLoader.loadModules((Collection<File>)moduleFiles, projectSdkType, this.myPathVariables);
        for (JpsModule module : modules) {
            this.myProject.addModule(module);
        }
        timingLog.run();
    }

    @NotNull
    public static List<JpsModule> loadModules(@NotNull Collection<File> moduleFiles, final @Nullable JpsSdkType<?> projectSdkType, final @NotNull Map<String, String> pathVariables) {
        ArrayList<JpsModule> arrayList;
        if (moduleFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFiles", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModules"));
        }
        if (pathVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathVariables", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModules"));
        }
        ArrayList<JpsModule> modules = new ArrayList<JpsModule>();
        ArrayList<Future<Pair<File, Element>>> futureModuleFilesContents = new ArrayList<Future<Pair<File, Element>>>();
        for (final File file : moduleFiles) {
            futureModuleFilesContents.add(ourThreadPool.submit(new Callable<Pair<File, Element>>(){

                @Override
                public Pair<File, Element> call() throws Exception {
                    JpsMacroExpander expander = JpsProjectLoader.createModuleMacroExpander(pathVariables, file);
                    Element moduleRoot = JpsLoaderBase.loadRootElement(file, expander);
                    return Pair.create(file, moduleRoot);
                }
            }));
        }
        try {
            final ArrayList<String> classpathDirs = new ArrayList<String>();
            for (Future future : futureModuleFilesContents) {
                String string = ((Element)((Pair)future.get()).getSecond()).getAttributeValue(CLASSPATH_DIR_ATTRIBUTE);
                if (string == null) continue;
                classpathDirs.add(string);
            }
            ArrayList<Future<JpsModule>> arrayList2 = new ArrayList<Future<JpsModule>>();
            for (Future future : futureModuleFilesContents) {
                final Pair moduleFile = (Pair)future.get();
                arrayList2.add(ourThreadPool.submit(new Callable<JpsModule>(){

                    @Override
                    public JpsModule call() throws Exception {
                        return JpsProjectLoader.loadModule((File)moduleFile.getFirst(), (Element)moduleFile.getSecond(), classpathDirs, projectSdkType, pathVariables);
                    }
                }));
            }
            for (Future future : arrayList2) {
                JpsModule module = (JpsModule)future.get();
                if (module == null) continue;
                modules.add(module);
            }
            arrayList = modules;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModules"));
        }
        return arrayList;
    }

    @Nullable
    private static JpsModule loadModule(@NotNull File file, @NotNull Element moduleRoot, List<String> paths, @Nullable JpsSdkType<?> projectSdkType, Map<String, String> pathVariables) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModule"));
        }
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "org/jetbrains/jps/model/serialization/JpsProjectLoader", "loadModule"));
        }
        String name = FileUtil.getNameWithoutExtension(file);
        String typeId = moduleRoot.getAttributeValue("type");
        JpsModulePropertiesSerializer<?> serializer = JpsProjectLoader.getModulePropertiesSerializer(typeId);
        JpsModule module = JpsProjectLoader.createModule(name, moduleRoot, serializer);
        module.getContainer().setChild(JpsModuleSerializationDataExtensionImpl.ROLE, new JpsModuleSerializationDataExtensionImpl(file.getParentFile()));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadModuleOptions(module, moduleRoot);
        }
        String baseModulePath = FileUtil.toSystemIndependentName(file.getParent());
        String classpath = moduleRoot.getAttributeValue(CLASSPATH_ATTRIBUTE);
        if (classpath == null) {
            JpsModuleRootModelSerializer.loadRootModel(module, JDomSerializationUtil.findComponent(moduleRoot, "NewModuleRootManager"), projectSdkType);
        } else {
            for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
                JpsModuleClasspathSerializer classpathSerializer = extension.getClasspathSerializer();
                if (classpathSerializer == null || !classpathSerializer.getClasspathId().equals(classpath)) continue;
                String classpathDir = moduleRoot.getAttributeValue(CLASSPATH_DIR_ATTRIBUTE);
                JpsMacroExpander expander = JpsProjectLoader.createModuleMacroExpander(pathVariables, file);
                classpathSerializer.loadClasspath(module, classpathDir, baseModulePath, expander, paths, projectSdkType);
            }
        }
        JpsFacetSerializer.loadFacets(module, JDomSerializationUtil.findComponent(moduleRoot, "FacetManager"));
        return module;
    }

    static JpsMacroExpander createModuleMacroExpander(Map<String, String> pathVariables, File moduleFile) {
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        String moduleDirPath = PathMacroUtil.getModuleDir(moduleFile.getAbsolutePath());
        if (moduleDirPath != null) {
            expander.addFileHierarchyReplacements("MODULE_DIR", new File(FileUtil.toSystemDependentName(moduleDirPath)));
        }
        return expander;
    }

    private static <P extends JpsElement> JpsModule createModule(String name, Element moduleRoot, JpsModulePropertiesSerializer<P> loader) {
        String componentName = loader.getComponentName();
        Element component = componentName != null ? JDomSerializationUtil.findComponent(moduleRoot, componentName) : null;
        return JpsElementFactory.getInstance().createModule(name, (JpsModuleType)loader.getType(), loader.loadProperties(component));
    }

    private static JpsModulePropertiesSerializer<?> getModulePropertiesSerializer(@Nullable String typeId) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModulePropertiesSerializer<?> loader : extension.getModulePropertiesSerializers()) {
                if (!loader.getTypeId().equals(typeId)) continue;
                return loader;
            }
        }
        return new JpsModulePropertiesSerializer<JpsDummyElement>((JpsModuleType)JpsJavaModuleType.INSTANCE, "JAVA_MODULE", null){

            @Override
            public JpsDummyElement loadProperties(@Nullable Element componentElement) {
                return JpsElementFactory.getInstance().createDummyElement();
            }

            @Override
            public void saveProperties(@NotNull JpsDummyElement properties, @NotNull Element componentElement) {
                if (properties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/serialization/JpsProjectLoader$3", "saveProperties"));
                }
                if (componentElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentElement", "org/jetbrains/jps/model/serialization/JpsProjectLoader$3", "saveProperties"));
                }
            }
        };
    }
}

