/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualRangeMarker {
    private ProperTextRange myRange;
    private boolean myValid;
    private final boolean myGreedyLeft;
    private final boolean myGreedyRight;
    private PersistentRangeMarker.LinesCols myLinesCols;

    public ManualRangeMarker(@NotNull FrozenDocument document, @NotNull ProperTextRange range, boolean greedyLeft, boolean greedyRight, boolean surviveOnExternalChange) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/ManualRangeMarker", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/ManualRangeMarker", "<init>"));
        }
        this.myValid = true;
        this.myRange = range;
        this.myGreedyLeft = greedyLeft;
        this.myGreedyRight = greedyRight;
        this.myLinesCols = surviveOnExternalChange ? PersistentRangeMarker.storeLinesAndCols(range, document) : null;
    }

    @Nullable
    public ProperTextRange getUpdatedRange(@NotNull List<DocumentEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/editor/impl/ManualRangeMarker", "getUpdatedRange"));
        }
        Pair<ProperTextRange, PersistentRangeMarker.LinesCols> pair = this.getUpdatedState(events);
        return pair == null ? null : (ProperTextRange)pair.first;
    }

    @Nullable
    private Pair<ProperTextRange, PersistentRangeMarker.LinesCols> getUpdatedState(@NotNull List<DocumentEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/editor/impl/ManualRangeMarker", "getUpdatedState"));
        }
        ProperTextRange range = this.myRange;
        PersistentRangeMarker.LinesCols linesCols = this.myLinesCols;
        for (DocumentEvent event : events) {
            if (linesCols != null) {
                Pair<ProperTextRange, PersistentRangeMarker.LinesCols> pair = PersistentRangeMarker.applyChange(event, range, range.getStartOffset(), range.getEndOffset(), this.myGreedyLeft, this.myGreedyRight, linesCols);
                if (pair == null) {
                    return null;
                }
                range = (ProperTextRange)pair.first;
                linesCols = (PersistentRangeMarker.LinesCols)pair.second;
                continue;
            }
            if ((range = RangeMarkerImpl.applyChange(event, range.getStartOffset(), range.getEndOffset(), this.myGreedyLeft, this.myGreedyRight)) != null) continue;
            return null;
        }
        return Pair.create(range, linesCols);
    }

    public void applyEvents(List<DocumentEvent> events) {
        if (!this.myValid) {
            return;
        }
        Pair<ProperTextRange, PersistentRangeMarker.LinesCols> pair = this.getUpdatedState(events);
        if (pair != null) {
            this.myRange = (ProperTextRange)pair.first;
            this.myLinesCols = (PersistentRangeMarker.LinesCols)pair.second;
        } else {
            this.myValid = false;
        }
    }

    @Nullable
    public ProperTextRange getRange() {
        return this.myValid ? this.myRange : null;
    }

    public boolean isValid() {
        return this.myValid;
    }
}

