/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringSearcher {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.text.StringSearcher");
    private final String myPattern;
    private final char[] myPatternArray;
    private final int myPatternLength;
    private final int[] mySearchTable;
    private final boolean myCaseSensitive;
    private final boolean myForwardDirection;
    private final boolean myJavaIdentifier;
    private final boolean myHandleEscapeSequences;

    public int getPatternLength() {
        return this.myPatternLength;
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/util/text/StringSearcher", "<init>"));
        }
        this(pattern, caseSensitive, forwardDirection, false);
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection, boolean handleEscapeSequences) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/util/text/StringSearcher", "<init>"));
        }
        this(pattern, caseSensitive, forwardDirection, handleEscapeSequences, true);
    }

    public StringSearcher(@NotNull String pattern, boolean caseSensitive, boolean forwardDirection, boolean handleEscapeSequences, boolean lookForJavaIdentifiersOnlyIfPossible) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/util/text/StringSearcher", "<init>"));
        }
        this.mySearchTable = new int[128];
        this.myHandleEscapeSequences = handleEscapeSequences;
        LOG.assertTrue(!pattern.isEmpty());
        this.myPattern = pattern;
        this.myCaseSensitive = caseSensitive;
        this.myForwardDirection = forwardDirection;
        this.myPatternArray = this.myCaseSensitive ? this.myPattern.toCharArray() : this.myPattern.toLowerCase(Locale.US).toCharArray();
        this.myPatternLength = this.myPatternArray.length;
        Arrays.fill(this.mySearchTable, -1);
        this.myJavaIdentifier = lookForJavaIdentifiersOnlyIfPossible && (pattern.isEmpty() || Character.isJavaIdentifierPart(pattern.charAt(0)) && Character.isJavaIdentifierPart(pattern.charAt(pattern.length() - 1)));
    }

    @NotNull
    public String getPattern() {
        String string = this.myPattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/StringSearcher", "getPattern"));
        }
        return string;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isJavaIdentifier() {
        return this.myJavaIdentifier;
    }

    public boolean isForwardDirection() {
        return this.myForwardDirection;
    }

    public boolean isHandleEscapeSequences() {
        return this.myHandleEscapeSequences;
    }

    public int scan(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/StringSearcher", "scan"));
        }
        return this.scan(text, 0, text.length());
    }

    public int scan(@NotNull CharSequence text, int _start, int _end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/StringSearcher", "scan"));
        }
        return this.scan(text, null, _start, _end);
    }

    public int scan(@NotNull CharSequence text, @Nullable char[] textArray, int _start, int _end) {
        int step;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/StringSearcher", "scan"));
        }
        if (_start > _end) {
            throw new AssertionError((Object)("start > end, " + _start + ">" + _end));
        }
        int textLength = text.length();
        if (_end > textLength) {
            throw new AssertionError((Object)("end > length, " + _end + ">" + textLength));
        }
        if (this.myForwardDirection) {
            int step2;
            if (this.myPatternLength == 1) {
                return StringUtil.indexOf(text, this.myPatternArray[0], _start, _end, this.myCaseSensitive);
            }
            int end = _end - this.myPatternLength;
            for (int start = _start; start <= end; start += step2) {
                int index;
                char lastChar;
                int i = this.myPatternLength - 1;
                char c = lastChar = textArray != null ? textArray[start + i] : text.charAt(start + i);
                if (!this.myCaseSensitive) {
                    lastChar = StringUtil.toLowerCase(lastChar);
                }
                if (this.myPatternArray[i] == lastChar) {
                    --i;
                    while (i >= 0) {
                        char c2;
                        char c3 = c2 = textArray != null ? textArray[start + i] : text.charAt(start + i);
                        if (!this.myCaseSensitive) {
                            c2 = StringUtil.toLowerCase(c2);
                        }
                        if (this.myPatternArray[i] != c2) break;
                        --i;
                    }
                    if (i < 0) {
                        return start;
                    }
                }
                int n = step2 = lastChar < '\u0080' ? this.mySearchTable[lastChar] : 1;
                if (step2 > 0) continue;
                for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[index] != lastChar; --index) {
                }
                this.mySearchTable[lastChar] = step2 = this.myPatternLength - index - 1;
            }
            return -1;
        }
        int end = _end + 1;
        for (int start = 1; start <= end - this.myPatternLength + 1; start += step) {
            int index;
            char lastChar;
            int i = this.myPatternLength - 1;
            char c = lastChar = textArray != null ? textArray[end - (start + i)] : text.charAt(end - (start + i));
            if (!this.myCaseSensitive) {
                lastChar = StringUtil.toLowerCase(lastChar);
            }
            if (this.myPatternArray[this.myPatternLength - 1 - i] == lastChar) {
                --i;
                while (i >= 0) {
                    char c4;
                    char c5 = c4 = textArray != null ? textArray[end - (start + i)] : text.charAt(end - (start + i));
                    if (!this.myCaseSensitive) {
                        c4 = StringUtil.toLowerCase(c4);
                    }
                    if (this.myPatternArray[this.myPatternLength - 1 - i] != c4) break;
                    --i;
                }
                if (i < 0) {
                    return end - start - this.myPatternLength + 1;
                }
            }
            int n = step = lastChar < '\u0080' ? this.mySearchTable[lastChar] : 1;
            if (step > 0) continue;
            for (index = this.myPatternLength - 2; index >= 0 && this.myPatternArray[this.myPatternLength - 1 - index] != lastChar; --index) {
            }
            this.mySearchTable[lastChar] = step = this.myPatternLength - index - 1;
        }
        return -1;
    }

    public int scan(char[] text, int startOffset, int endOffset) {
        int res = this.scan(new CharArrayCharSequence(text), text, startOffset, endOffset);
        return res >= 0 ? res : -1;
    }

    public String toString() {
        return "pattern " + this.myPattern;
    }
}

