/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SmartHashMap;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEngine {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.InspectionEngine");

    @NotNull
    public static PsiElementVisitor createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session, @NotNull List<PsiElement> elements, @Nullable Collection<String> languages) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        PsiElementVisitor visitor = tool.buildVisitor(holder, isOnTheFly, session);
        if (visitor == null) {
            LOG.error("Tool " + tool + " must not return null from the buildVisitor() method");
        }
        assert (!(visitor instanceof PsiRecursiveElementVisitor) && !(visitor instanceof PsiRecursiveElementWalkingVisitor)) : "The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive. " + tool;
        tool.inspectionStarted(session, isOnTheFly);
        InspectionEngine.acceptElements(elements, visitor, languages);
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "createVisitorAndAcceptElements"));
        }
        return psiElementVisitor;
    }

    public static void acceptElements(@NotNull List<PsiElement> elements, @NotNull PsiElementVisitor elementVisitor, @Nullable Collection<String> languages) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInspection/InspectionEngine", "acceptElements"));
        }
        if (elementVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementVisitor", "com/intellij/codeInspection/InspectionEngine", "acceptElements"));
        }
        int elementsSize = elements.size();
        for (int i = 0; i < elementsSize; ++i) {
            PsiElement element = elements.get(i);
            if (languages == null || languages.contains(element.getLanguage().getID())) {
                element.accept(elementVisitor);
            }
            ProgressManager.checkCanceled();
        }
    }

    @NotNull
    public static List<ProblemDescriptor> inspect(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        Map<String, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(toolWrappers, file, iManager, isOnTheFly, failFastOnAcquireReadAction, indicator);
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (List<ProblemDescriptor> group : problemDescriptors.values()) {
            result.addAll(group);
        }
        ArrayList<ProblemDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "inspect"));
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<LocalInspectionToolWrapper> toolWrappers, final @NotNull PsiFile file, final @NotNull InspectionManager iManager, final boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        if (iManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iManager", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        if (toolWrappers.isEmpty()) {
            Map<String, List<ProblemDescriptor>> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
            }
            return map;
        }
        final ConcurrentHashMap<String, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<String, List<ProblemDescriptor>>();
        final ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        TextRange range = file.getTextRange();
        final LocalInspectionToolSession session = new LocalInspectionToolSession(file, range.getStartOffset(), range.getEndOffset());
        Divider.divideInsideAndOutside(file, range.getStartOffset(), range.getEndOffset(), range, elements, new ArrayList<ProperTextRange>(), Collections.<PsiElement>emptyList(), Collections.<ProperTextRange>emptyList(), true, Conditions.<PsiFile>alwaysTrue());
        MultiMap<LocalInspectionToolWrapper, String> toolToLanguages = InspectionEngine.getToolsForElements(toolWrappers, elements, Collections.<PsiElement>emptyList());
        ArrayList<Map.Entry<LocalInspectionToolWrapper, Collection<String>>> entries = new ArrayList<Map.Entry<LocalInspectionToolWrapper, Collection<String>>>(toolToLanguages.entrySet());
        Processor<Map.Entry<LocalInspectionToolWrapper, Collection<String>>> processor = new Processor<Map.Entry<LocalInspectionToolWrapper, Collection<String>>>(){

            @Override
            public boolean process(Map.Entry<LocalInspectionToolWrapper, Collection<String>> entry) {
                ProblemsHolder holder = new ProblemsHolder(iManager, file, isOnTheFly);
                final LocalInspectionTool tool = (LocalInspectionTool)entry.getKey().getTool();
                Collection<String> languages = entry.getValue();
                InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session, elements, languages);
                tool.inspectionFinished(session, holder);
                if (holder.hasResults()) {
                    resultDescriptors.put(tool.getShortName(), ContainerUtil.filter(holder.getResults(), new Condition<ProblemDescriptor>(){

                        @Override
                        public boolean value(ProblemDescriptor descriptor) {
                            PsiElement element = descriptor.getPsiElement();
                            return element == null || !SuppressionUtil.inspectionResultSuppressed(element, tool);
                        }
                    }));
                }
                return true;
            }
        };
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(entries, indicator, failFastOnAcquireReadAction, processor);
        ConcurrentHashMap<String, List<ProblemDescriptor>> concurrentHashMap = resultDescriptors;
        if (concurrentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "inspectEx"));
        }
        return concurrentHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file, @NotNull InspectionToolWrapper toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        block14: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
            }
            if (toolWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
            }
            if (inspectionContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionContext", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
            }
            final InspectionManager inspectionManager = InspectionManager.getInstance(file.getProject());
            toolWrapper.initialize(inspectionContext);
            RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
            refManager.inspectionReadActionStarted();
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                List<ProblemDescriptor> list = InspectionEngine.inspect(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file, inspectionManager, false, false, new EmptyProgressIndicator());
                List<ProblemDescriptor> list2 = list;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
                }
                return list2;
            }
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) break block14;
            final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            final ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
            if (globalTool instanceof GlobalSimpleInspectionTool) {
                GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file, false);
                ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                    @Override
                    @Nullable
                    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/InspectionEngine$2", "getDescriptions"));
                        }
                        return descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
                    }

                    @Override
                    public void ignoreElement(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/InspectionEngine$2", "ignoreElement"));
                        }
                        throw new RuntimeException();
                    }

                    @Override
                    public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                        if (commonProblemDescriptors == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonProblemDescriptors", "com/intellij/codeInspection/InspectionEngine$2", "addProblemElement"));
                        }
                        if (!(refEntity instanceof RefElement)) {
                            return;
                        }
                        PsiElement element = ((RefElement)refEntity).getElement();
                        InspectionEngine.convertToProblemDescriptors(element, commonProblemDescriptors, descriptors);
                    }

                    @Override
                    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
                        if (descriptor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/InspectionEngine$2", "getElement"));
                        }
                        throw new RuntimeException();
                    }
                };
                simpleTool.checkFile(file, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                ArrayList<ProblemDescriptor> arrayList = descriptors;
                ArrayList<ProblemDescriptor> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
                }
                return arrayList2;
            }
            RefElement fileRef = refManager.getReference(file);
            final AnalysisScope scope = new AnalysisScope(file);
            fileRef.accept(new RefVisitor(){

                @Override
                public void visitElement(@NotNull RefEntity elem) {
                    if (elem == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/InspectionEngine$3", "visitElement"));
                    }
                    CommonProblemDescriptor[] elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext);
                    if (descriptors != null) {
                        InspectionEngine.convertToProblemDescriptors(file, elemDescriptors, descriptors);
                    }
                    for (RefEntity child : elem.getChildren()) {
                        child.accept(this);
                    }
                }
            });
            ArrayList<ProblemDescriptor> arrayList = descriptors;
            ArrayList<ProblemDescriptor> arrayList3 = arrayList;
            if (arrayList3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
            }
            return arrayList3;
            finally {
                refManager.inspectionReadActionFinished();
                toolWrapper.cleanup(file.getProject());
                inspectionContext.cleanup();
            }
        }
        List<ProblemDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "runInspectionOnFile"));
        }
        return list;
    }

    private static void convertToProblemDescriptors(PsiElement element, CommonProblemDescriptor[] commonProblemDescriptors, List<ProblemDescriptor> descriptors) {
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                descriptors.add((ProblemDescriptor)common);
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element, element, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            descriptors.add(base);
        }
    }

    @NotNull
    public static <T extends InspectionToolWrapper> MultiMap<T, String> getToolsForElements(@NotNull List<T> toolWrappers, @NotNull List<PsiElement> inside, @NotNull List<PsiElement> outside) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/InspectionEngine", "getToolsForElements"));
        }
        if (inside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inside", "com/intellij/codeInspection/InspectionEngine", "getToolsForElements"));
        }
        if (outside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outside", "com/intellij/codeInspection/InspectionEngine", "getToolsForElements"));
        }
        SmartHashSet languages = new SmartHashSet();
        SmartHashMap langIds = new SmartHashMap();
        SmartHashSet dialects = new SmartHashSet();
        InspectionEngine.calculateDialects(inside, languages, langIds, dialects);
        InspectionEngine.calculateDialects(outside, languages, langIds, dialects);
        MultiMap toolToLanguages = new MultiMap<T, String>(){

            @Override
            @NotNull
            protected Collection<String> createCollection() {
                SmartHashSet smartHashSet = new SmartHashSet();
                if (smartHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine$4", "createCollection"));
                }
                return smartHashSet;
            }

            @Override
            @NotNull
            protected Collection<String> createEmptyCollection() {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine$4", "createEmptyCollection"));
                }
                return set;
            }
        };
        for (InspectionToolWrapper wrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            String language = wrapper.getLanguage();
            if (language == null) {
                toolToLanguages.put(wrapper, null);
                continue;
            }
            Language lang = (Language)langIds.get(language);
            if (lang != null) {
                toolToLanguages.putValue(wrapper, language);
                if (!wrapper.applyToDialects()) continue;
                for (Language dialect : lang.getDialects()) {
                    toolToLanguages.putValue(wrapper, dialect.getID());
                }
                continue;
            }
            if (!wrapper.applyToDialects() || !dialects.contains(language)) continue;
            toolToLanguages.putValue(wrapper, language);
        }
        MultiMap multiMap = toolToLanguages;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionEngine", "getToolsForElements"));
        }
        return multiMap;
    }

    private static void calculateDialects(@NotNull List<PsiElement> inside, @NotNull Set<Language> languages, @NotNull Map<String, Language> langIds, @NotNull Set<String> dialects) {
        if (inside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inside", "com/intellij/codeInspection/InspectionEngine", "calculateDialects"));
        }
        if (languages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languages", "com/intellij/codeInspection/InspectionEngine", "calculateDialects"));
        }
        if (langIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langIds", "com/intellij/codeInspection/InspectionEngine", "calculateDialects"));
        }
        if (dialects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialects", "com/intellij/codeInspection/InspectionEngine", "calculateDialects"));
        }
        for (PsiElement element : inside) {
            Language language = element.getLanguage();
            if (!languages.add(language)) continue;
            langIds.put(language.getID(), language);
            for (Language dialect : language.getDialects()) {
                dialects.add(dialect.getID());
            }
        }
    }
}

