/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyAnnotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryModuleDependencyInspection
extends GlobalInspectionTool {
    private SoftReference<Graph<Module>> myGraph = new SoftReference<Object>(null);

    @Override
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "getAnnotator"));
        }
        return new UnnecessaryModuleDependencyAnnotator(refManager);
    }

    @Override
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "checkElement"));
        }
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module = refModule.getModule();
            if (module.isDisposed() || !scope.containsModule(module)) {
                return CommonProblemDescriptor.EMPTY_ARRAY;
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            OrderEntry[] declaredDependencies = moduleRootManager.getOrderEntries();
            Module[] declaredModuleDependencies = moduleRootManager.getDependencies();
            ArrayList<CommonProblemDescriptor> descriptors = new ArrayList<CommonProblemDescriptor>();
            Set<Module> modules = refModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES);
            Graph<Module> graph = (Graph<Module>)this.myGraph.get();
            if (graph == null) {
                graph = ModuleManager.getInstance(globalContext.getProject()).moduleGraph();
                this.myGraph = new SoftReference<Graph<Module>>(graph);
            }
            RefManager refManager = globalContext.getRefManager();
            for (OrderEntry entry : declaredDependencies) {
                Module dependency;
                if (!(entry instanceof ModuleOrderEntry) || (dependency = ((ModuleOrderEntry)entry).getModule()) == null || modules != null && modules.contains(dependency)) continue;
                ArrayList<String> dependenciesThroughExported = null;
                if (((ModuleOrderEntry)entry).isExported()) {
                    Iterator<Module> iterator = graph.getOut(module);
                    while (iterator.hasNext()) {
                        Set<Module> neededModules;
                        Module dep = iterator.next();
                        RefModule depRefModule = refManager.getRefModule(dep);
                        if (depRefModule == null || (neededModules = depRefModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES)) == null || !neededModules.contains(dependency)) continue;
                        if (dependenciesThroughExported == null) {
                            dependenciesThroughExported = new ArrayList<String>();
                        }
                        dependenciesThroughExported.add(dep.getName());
                    }
                }
                if (modules != null) {
                    ArrayList<String> transitiveDependencies = new ArrayList<String>();
                    OrderEntry[] dependenciesOfDependencies = ModuleRootManager.getInstance(dependency).getOrderEntries();
                    for (OrderEntry secondDependency : dependenciesOfDependencies) {
                        Module mod;
                        if (!(secondDependency instanceof ModuleOrderEntry) || !((ModuleOrderEntry)secondDependency).isExported() || (mod = ((ModuleOrderEntry)secondDependency).getModule()) == null || !modules.contains(mod) || ArrayUtil.find(declaredModuleDependencies, mod) >= 0) continue;
                        transitiveDependencies.add(mod.getName());
                    }
                    if (!transitiveDependencies.isEmpty()) {
                        String exported = StringUtil.join(transitiveDependencies, ", ");
                        descriptors.add(manager.createProblemDescriptor(InspectionsBundle.message("unnecessary.module.dependency.exported.problem.descriptor1", module.getName(), dependency.getName(), exported), new QuickFix[0]));
                        continue;
                    }
                }
                descriptors.add(UnnecessaryModuleDependencyInspection.createDescriptor(scope, manager, module, dependency, dependenciesThroughExported));
            }
            return descriptors.isEmpty() ? null : descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
        }
        return null;
    }

    private static CommonProblemDescriptor createDescriptor(AnalysisScope scope, InspectionManager manager, Module module, Module dependency, List<String> exportedDependencies) {
        if (exportedDependencies != null) {
            String exported = StringUtil.join(exportedDependencies, ", ");
            return manager.createProblemDescriptor(InspectionsBundle.message("unnecessary.module.dependency.exported.problem.descriptor", module.getName(), dependency.getName(), exported), new QuickFix[0]);
        }
        if (scope.containsModule(dependency)) {
            String allContainsMessage = InspectionsBundle.message("unnecessary.module.dependency.problem.descriptor", module.getName(), dependency.getName());
            return manager.createProblemDescriptor(allContainsMessage, new RemoveModuleDependencyFix(module, dependency));
        }
        String message = InspectionsBundle.message("suspected.module.dependency.problem.descriptor", module.getName(), dependency.getName(), scope.getDisplayName(), dependency.getName());
        return manager.createProblemDescriptor(message, new QuickFix[0]);
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("unnecessary.module.dependency.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("UnnecessaryModuleDependencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "getShortName"));
        }
        return "UnnecessaryModuleDependencyInspection";
    }

    public static class RemoveModuleDependencyFix
    implements QuickFix {
        private final Module myModule;
        private final Module myDependency;

        public RemoveModuleDependencyFix(Module module, Module dependency) {
            this.myModule = module;
            this.myDependency = dependency;
        }

        @Override
        @NotNull
        public String getName() {
            if ("Remove dependency" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix", "getName"));
            }
            return "Remove dependency";
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix", "applyFix"));
            }
            ModifiableRootModel model = ModuleRootManager.getInstance(this.myModule).getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                Module mDependency;
                if (!(entry instanceof ModuleOrderEntry) || !Comparing.equal(mDependency = ((ModuleOrderEntry)entry).getModule(), this.myDependency)) continue;
                model.removeOrderEntry(entry);
                break;
            }
            model.commit();
        }
    }
}

