/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaCodeBlockInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance("#" + RedundantLambdaCodeBlockInspection.class.getName());

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Statement lambda can be replaced with expression lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getDisplayName"));
        }
        return "Statement lambda can be replaced with expression lambda";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("CodeBlock2Expr" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getShortName"));
        }
        return "CodeBlock2Expr";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
                PsiElement body;
                PsiExpression psiExpression;
                super.visitLambdaExpression(expression);
                if (PsiUtil.isLanguageLevel8OrHigher(expression) && (psiExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(expression, body = expression.getBody())) != null) {
                    PsiElement parent = psiExpression.getParent();
                    PsiElement errorElement = parent instanceof PsiReturnStatement ? parent.getFirstChild() : body.getFirstChild();
                    holder.registerProblem(errorElement, "Statement lambda can be replaced with expression lambda", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new ReplaceWithExprFix());
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public static PsiExpression isCodeBlockRedundant(PsiExpression expression, PsiElement body) {
        PsiExpression psiExpression;
        if (body instanceof PsiCodeBlock && (psiExpression = LambdaUtil.extractSingleExpressionFromBody(body)) != null && !RedundantLambdaCodeBlockInspection.findCommentsOutsideExpression(body, psiExpression)) {
            CandidateInfo[] candidates;
            PsiElement gParent;
            PsiElement parent;
            if (LambdaUtil.isExpressionStatementExpression(psiExpression) && (parent = PsiUtil.skipParenthesizedExprUp(expression.getParent())) instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCallExpression && (candidates = PsiResolveHelper.SERVICE.getInstance(gParent.getProject()).getReferencedMethodCandidates((PsiCallExpression)gParent, false, true)).length > 1) {
                ArrayList<CandidateInfo> info = new ArrayList<CandidateInfo>(Arrays.asList(candidates));
                LanguageLevel level = PsiUtil.getLanguageLevel(parent);
                JavaMethodsConflictResolver conflictResolver = new JavaMethodsConflictResolver((PsiExpressionList)parent, level);
                PsiExpressionList argumentList = ((PsiCallExpression)gParent).getArgumentList();
                if (argumentList == null) {
                    return null;
                }
                conflictResolver.checkParametersNumber(info, argumentList.getExpressions().length, false);
                conflictResolver.checkSpecifics(info, 2, level);
                if (info.size() > 1) {
                    return null;
                }
            }
            return psiExpression;
        }
        return null;
    }

    private static boolean findCommentsOutsideExpression(PsiElement body, PsiExpression psiExpression) {
        Collection<PsiComment> comments = PsiTreeUtil.findChildrenOfType(body, PsiComment.class);
        for (PsiComment comment : comments) {
            if (PsiTreeUtil.isAncestor(psiExpression, comment, true)) continue;
            return true;
        }
        return false;
    }

    private static class ReplaceWithExprFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithExprFix() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("Replace with expression lambda" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "getName"));
            }
            return "Replace with expression lambda";
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element != null) {
                PsiExpression expression;
                PsiElement body;
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType(element, PsiLambdaExpression.class);
                if (lambdaExpression != null && (body = lambdaExpression.getBody()) != null && (expression = LambdaUtil.extractSingleExpressionFromBody(body)) != null) {
                    body.replace(expression);
                }
            }
        }
    }
}

