/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WriteAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.application.WriteAction");

    @Override
    @NotNull
    public RunResult<T> execute() {
        final RunResult result = new RunResult(this);
        final Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            result.run();
            RunResult runResult = result;
            if (runResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "execute"));
            }
            return runResult;
        }
        try {
            boolean dispatchThread = application.isDispatchThread();
            if (!dispatchThread && application.isReadAccessAllowed()) {
                LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            result.run();
                        }
                    });
                }
            };
            if (dispatchThread) {
                runnable.run();
            } else if (application.isReadAccessAllowed()) {
                LOG.error("Calling write action from read-action leads to deadlock.");
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable cause = e.getCause();
                Exception exception = e = cause instanceof Exception ? (Exception)cause : new RuntimeException(e);
            }
            if (this.isSilentExecution()) {
                result.setThrowable(e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new Error(e);
        }
        RunResult runResult = result;
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "execute"));
        }
        return runResult;
    }

    @NotNull
    public static AccessToken start() {
        AccessToken accessToken = WriteAction.start(null);
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "start"));
        }
        return accessToken;
    }

    @NotNull
    public static AccessToken start(@Nullable Class clazz) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireWriteActionLock(clazz);
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "start"));
        }
        return accessToken;
    }
}

