/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.CollectionPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    public static StringPattern string() {
        return new StringPattern();
    }

    public static CharPattern character() {
        return new CharPattern();
    }

    public static <T> ObjectPattern.Capture<T> instanceOf(Class<T> aClass) {
        return new ObjectPattern.Capture<T>(aClass);
    }

    public static <T> ElementPattern save(final Key<T> key) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                context.put(key, o);
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$1", "append"));
                }
                builder.append("save(").append(key).append(")");
            }
        });
    }

    public static ObjectPattern.Capture<Object> object() {
        return StandardPatterns.instanceOf(Object.class);
    }

    public static <T> ObjectPattern.Capture<T> object(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/patterns/StandardPatterns", "object"));
        }
        return (ObjectPattern.Capture)StandardPatterns.instanceOf(value.getClass()).equalTo(value);
    }

    public static <T> CollectionPattern<T> collection(Class<T> aClass) {
        return new CollectionPattern();
    }

    public static ElementPattern get(final @NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/patterns/StandardPatterns", "get"));
        }
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return Comparing.equal(o, context.get(key));
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$2", "append"));
                }
                builder.append("get(").append(key).append(")");
            }
        });
    }

    public static <T> CollectionPattern<T> collection() {
        return new CollectionPattern();
    }

    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.accepts(o, context)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$3", "append"));
                }
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Arrays.asList(patterns);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ElementPattern<E> and(ElementPattern<? extends E> ... patterns) {
        void var5_8;
        List<InitialPatternCondition> initial = ContainerUtil.newSmartList();
        for (ElementPattern<E> elementPattern : patterns) {
            initial.add(elementPattern.getCondition().getInitialCondition());
        }
        ObjectPattern.Capture result = StandardPatterns.composeInitialConditions(initial);
        ElementPattern<? extends E>[] elementPatternArray = patterns;
        int n = elementPatternArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            ElementPattern<E> elementPattern = elementPatternArray[var5_8];
            for (PatternCondition<? extends E> patternCondition : elementPattern.getCondition().getConditions()) {
                result = (ObjectPattern.Capture)result.with(patternCondition);
            }
            ++var5_8;
        }
        return result;
    }

    @NotNull
    private static <E> ObjectPattern.Capture<E> composeInitialConditions(final List<InitialPatternCondition> initial) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (InitialPatternCondition pattern : initial) {
                    if (pattern.accepts(o, context)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$4", "append"));
                }
                boolean first = true;
                for (InitialPatternCondition pattern : initial) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.append(builder, indent + "  ");
                }
            }
        });
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "composeInitialConditions"));
        }
        return capture;
    }

    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return !pattern.accepts(o, context);
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$5", "append"));
                }
                pattern.getCondition().append(builder.append("not("), indent + "  ");
                builder.append(")");
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(pattern);
            }
        });
    }

    public static <T> ObjectPattern.Capture<T> optional(final ElementPattern<T> pattern) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                pattern.accepts(o, context);
                return true;
            }
        });
    }

    public static <E> ElementPattern<E> alwaysFalse() {
        return FALSE_PATTERN;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(@Nullable Object o) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(@Nullable Object o, ProcessingContext context) {
                    return false;
                }
            });
        }
    }
}

