/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class URIReferenceProvider
extends PsiReferenceProvider {
    public static final ElementFilter ELEMENT_FILTER = new ElementFilter(){

        @Override
        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement parent = context.getParent();
            if (parent instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)parent;
                return attribute.isNamespaceDeclaration();
            }
            return false;
        }

        @Override
        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    };
    @NonNls
    private static final String NAMESPACE_ATTR_NAME = "namespace";

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider", "getReferencesByElement"));
        }
        String text = element.getText();
        String s = StringUtil.unquoteString(text);
        final PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute && "schemaLocation".equals(((XmlAttribute)parent).getLocalName()) && "http://www.w3.org/2001/XMLSchema-instance".equals(((XmlAttribute)parent).getNamespace())) {
            final ArrayList<PsiReference> refs = new ArrayList<PsiReference>(2);
            StringTokenizer tokenizer = new StringTokenizer(s);
            while (tokenizer.hasMoreElements()) {
                String namespace = tokenizer.nextToken();
                int offset = text.indexOf(namespace);
                TextRange range = new TextRange(offset, offset + namespace.length());
                URLReference urlReference = new URLReference(element, range, true){

                    @Override
                    @NotNull
                    public Object[] getVariants() {
                        XmlTag tag = (XmlTag)parent.getParent();
                        XmlAttribute[] attributes = tag.getAttributes();
                        Object[] objectArray = ContainerUtil.mapNotNull(attributes, new Function<XmlAttribute, Object>(){

                            @Override
                            public Object fun(XmlAttribute attribute) {
                                final String attributeValue = attribute.getValue();
                                return attributeValue != null && attribute.isNamespaceDeclaration() && ContainerUtil.find(refs, new Condition<PsiReference>(){

                                    @Override
                                    public boolean value(PsiReference ref) {
                                        return ref.getCanonicalText().equals(attributeValue);
                                    }
                                }) == null ? attributeValue + " " : null;
                            }
                        }, ArrayUtil.EMPTY_OBJECT_ARRAY);
                        if (objectArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider$2", "getVariants"));
                        }
                        return objectArray;
                    }
                };
                refs.add(urlReference);
                if (!tokenizer.hasMoreElements()) break;
                String url = tokenizer.nextToken();
                offset = text.indexOf(url);
                refs.add(new DependentNSReference(element, new TextRange(offset, offset + url.length()), urlReference));
                if (XmlUtil.isUrlText(url, element.getProject())) continue;
                ContainerUtil.addAll(refs, new FileReferenceSet(url, element, offset, this, false).getAllReferences());
            }
            PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[refs.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        PsiReference reference = URIReferenceProvider.getUrlReference(element, s);
        if (reference != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        s = s.substring(XmlUtil.getPrefixLength(s));
        PsiReference[] psiReferenceArray = new FileReferenceSet(s, element, text.indexOf(s), this, true).getAllReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    static PsiReference getUrlReference(PsiElement element, String s) {
        PsiElement parent = element.getParent();
        if ((XmlUtil.isUrlText(s, element.getProject()) || parent instanceof XmlAttribute && (((XmlAttribute)parent).isNamespaceDeclaration() || NAMESPACE_ATTR_NAME.equals(((XmlAttribute)parent).getName()))) && !s.startsWith("urn:jsptagdir:")) {
            boolean namespaceSoftRef;
            boolean bl = namespaceSoftRef = parent instanceof XmlAttribute && NAMESPACE_ATTR_NAME.equals(((XmlAttribute)parent).getName()) && ((XmlAttribute)parent).getParent().getAttributeValue("schemaLocation") != null;
            if (!namespaceSoftRef && parent instanceof XmlAttribute && ((XmlAttribute)parent).isNamespaceDeclaration()) {
                namespaceSoftRef = parent.getContainingFile().getContext() != null;
            }
            return new URLReference(element, null, namespaceSoftRef);
        }
        return null;
    }
}

