/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubTreeBuilder {
    private static final Key<Stub> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(FileContent inputData) {
        Stub data = inputData.getUserData(stubElementKey);
        if (data != null) {
            return data;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data = inputData.getUserData(stubElementKey);
            if (data != null) {
                return data;
            }
            FileType fileType = inputData.getFileType();
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            if (builder != null) {
                data = builder.buildStubTree(inputData);
                if (data instanceof PsiFileStubImpl && !((PsiFileStubImpl)data).rootsAreSet()) {
                    ((PsiFileStubImpl)data).setStubRoots(new PsiFileStub[]{(PsiFileStubImpl)data});
                }
            } else {
                LanguageFileType languageFileType = (LanguageFileType)fileType;
                CharSequence contentAsText = inputData.getContentAsText();
                FileContentImpl fileContent2 = (FileContentImpl)inputData;
                PsiFile psi = fileContent2.getPsiFileForPsiDependentIndex();
                FileViewProvider viewProvider = psi.getViewProvider();
                psi = viewProvider.getStubBindingRoot();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, contentAsText);
                IStubFileElementType type = ((PsiFileImpl)psi).getElementTypeForStubBuilder();
                psi.getManager().startBatchFilesProcessingMode();
                try {
                    SubstitutedFileType substituted;
                    LanguageFileType original;
                    IFileElementType originalType;
                    IStubFileElementType stubFileElementType = type != null ? type : (languageFileType instanceof SubstitutedFileType ? ((originalType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((original = (LanguageFileType)(substituted = (SubstitutedFileType)languageFileType).getOriginalFileType()).getLanguage())).getFileNodeType()) instanceof IStubFileElementType ? (IStubFileElementType)originalType : null) : null);
                    if (stubFileElementType != null) {
                        PsiFileStub[] stubsArray;
                        StubBuilder stubBuilder = stubFileElementType.getBuilder();
                        if (stubBuilder instanceof LightStubBuilder) {
                            LightStubBuilder.FORCED_AST.set(fileContent2.getLighterASTForPsiDependentIndex());
                        }
                        data = stubBuilder.buildStubTree(psi);
                        List<Pair<IStubFileElementType, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRoots(viewProvider);
                        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubbedRoots.size());
                        stubs.add((PsiFileStub)data);
                        for (Pair<IStubFileElementType, PsiFile> stubbedRoot : stubbedRoots) {
                            StubElement element;
                            PsiFile secondaryPsi = (PsiFile)stubbedRoot.second;
                            if (psi == secondaryPsi) continue;
                            StubBuilder stubbedRootBuilder = ((IStubFileElementType)stubbedRoot.first).getBuilder();
                            if (stubbedRootBuilder instanceof LightStubBuilder) {
                                LightStubBuilder.FORCED_AST.set(new TreeBackedLighterAST(secondaryPsi.getNode()));
                            }
                            if (!((element = stubbedRootBuilder.buildStubTree(secondaryPsi)) instanceof PsiFileStub)) continue;
                            stubs.add((PsiFileStub)element);
                        }
                        for (PsiFileStub stub : stubsArray = stubs.toArray(new PsiFileStub[stubs.size()])) {
                            if (!(stub instanceof PsiFileStubImpl)) continue;
                            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
                        }
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                    psi.getManager().finishBatchFilesProcessingMode();
                }
            }
            inputData.putUserData(stubElementKey, data);
            return data;
        }
    }

    @NotNull
    public static List<Pair<IStubFileElementType, PsiFile>> getStubbedRoots(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/stubs/StubTreeBuilder", "getStubbedRoots"));
        }
        SmartList<Trinity<Language, IStubFileElementType, PsiFile>> roots = new SmartList<Trinity<Language, IStubFileElementType, PsiFile>>();
        final PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        for (Language language : viewProvider.getLanguages()) {
            IStubFileElementType type;
            PsiFile file = viewProvider.getPsi(language);
            if (!(file instanceof PsiFileImpl) || (type = ((PsiFileImpl)file).getElementTypeForStubBuilder()) == null) continue;
            roots.add(Trinity.create(language, type, file));
        }
        ContainerUtil.sort(roots, new Comparator<Trinity<Language, IStubFileElementType, PsiFile>>(){

            @Override
            public int compare(Trinity<Language, IStubFileElementType, PsiFile> o1, Trinity<Language, IStubFileElementType, PsiFile> o2) {
                if (o1.third == stubBindingRoot) {
                    return o2.third == stubBindingRoot ? 0 : -1;
                }
                if (o2.third == stubBindingRoot) {
                    return 1;
                }
                return StringUtil.compare(((Language)o1.first).getID(), ((Language)o2.first).getID(), false);
            }
        });
        List<Pair<IStubFileElementType, PsiFile>> list = ContainerUtil.map(roots, new Function<Trinity<Language, IStubFileElementType, PsiFile>, Pair<IStubFileElementType, PsiFile>>(){

            @Override
            public Pair<IStubFileElementType, PsiFile> fun(Trinity<Language, IStubFileElementType, PsiFile> trinity) {
                return Pair.create(trinity.second, trinity.third);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTreeBuilder", "getStubbedRoots"));
        }
        return list;
    }
}

