/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.redundantCast.RedundantCastUtil");

    private RedundantCastUtil() {
    }

    @NotNull
    public static List<PsiTypeCastExpression> getRedundantCastsInside(PsiElement where) {
        MyCollectingVisitor visitor = new MyCollectingVisitor();
        if (where instanceof PsiEnumConstant) {
            where.accept(visitor);
        } else {
            where.acceptChildren(visitor);
        }
        ArrayList<PsiTypeCastExpression> arrayList = new ArrayList<PsiTypeCastExpression>(visitor.myFoundCasts);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/RedundantCastUtil", "getRedundantCastsInside"));
        }
        return arrayList;
    }

    public static boolean isCastRedundant(PsiTypeCastExpression typeCast) {
        PsiElement parent = typeCast.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiReferenceExpression) {
            parent = parent.getParent();
        }
        MyIsRedundantVisitor visitor = new MyIsRedundantVisitor(false);
        parent.accept(visitor);
        return visitor.isRedundant;
    }

    @Nullable
    private static PsiExpression deparenthesizeExpression(PsiExpression arg) {
        while (arg instanceof PsiParenthesizedExpression) {
            arg = ((PsiParenthesizedExpression)arg).getExpression();
        }
        return arg;
    }

    public static void removeCast(PsiTypeCastExpression castExpression) {
        if (castExpression == null) {
            return;
        }
        PsiExpression operand = castExpression.getOperand();
        if (operand instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parExpr = (PsiParenthesizedExpression)operand;
            operand = parExpr.getExpression();
        }
        if (operand == null) {
            return;
        }
        PsiElement toBeReplaced = castExpression;
        PsiElement parent = castExpression.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            toBeReplaced = parent;
            parent = parent.getParent();
        }
        try {
            toBeReplaced.replace(operand);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    private static boolean isCastRedundantInRefExpression(final PsiReferenceExpression refExpression, final PsiExpression castOperand) {
        final PsiElement resolved = refExpression.resolve();
        final Ref<Boolean> result = new Ref<Boolean>(Boolean.FALSE);
        CodeStyleManager.getInstance(refExpression.getProject()).performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiReferenceExpression copy;
                    PsiExpression qualifier;
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance(refExpression.getProject()).getElementFactory();
                    PsiExpression copyExpression = elementFactory.createExpressionFromText(refExpression.getText(), refExpression);
                    if (copyExpression instanceof PsiReferenceExpression && (qualifier = (copy = (PsiReferenceExpression)copyExpression).getQualifierExpression()) != null) {
                        qualifier.replace(castOperand);
                        result.set(copy.resolve() == resolved);
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
        });
        return result.get();
    }

    private static boolean isTypeCastSemantic(PsiTypeCastExpression typeCast) {
        PsiExpression operand = typeCast.getOperand();
        if (operand == null) {
            return false;
        }
        if (RedundantCastUtil.isInPolymorphicCall(typeCast)) {
            return true;
        }
        PsiType opType = operand.getType();
        PsiTypeElement typeElement = typeCast.getCastType();
        if (typeElement == null) {
            return false;
        }
        PsiType castType = typeElement.getType();
        if (castType instanceof PsiPrimitiveType) {
            if (opType instanceof PsiPrimitiveType) {
                return !opType.equals(castType);
            }
            PsiPrimitiveType unboxedOpType = PsiPrimitiveType.getUnboxedType(opType);
            if (unboxedOpType != null && !unboxedOpType.equals(castType)) {
                return true;
            }
        } else if (castType instanceof PsiClassType && ((PsiClassType)castType).hasParameters() ? opType instanceof PsiClassType && ((PsiClassType)opType).isRaw() : castType instanceof PsiClassType && ((PsiClassType)castType).isRaw() && opType instanceof PsiClassType && ((PsiClassType)opType).hasParameters()) {
            return true;
        }
        if (operand instanceof PsiLambdaExpression || operand instanceof PsiMethodReferenceExpression) {
            if (castType instanceof PsiClassType && InheritanceUtil.isInheritor(PsiUtil.resolveClassInType(castType), "java.io.Serializable")) {
                return true;
            }
            if (castType instanceof PsiIntersectionType) {
                return true;
            }
        }
        PsiElement parent = typeCast.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)parent;
            PsiExpression firstOperand = expression.getLOperand();
            PsiExpression otherOperand = expression.getROperand();
            if (PsiTreeUtil.isAncestor(otherOperand, typeCast, false)) {
                PsiExpression temp = otherOperand;
                otherOperand = firstOperand;
                firstOperand = temp;
            }
            if (firstOperand != null && otherOperand != null && RedundantCastUtil.wrapperCastChangeSemantics(firstOperand, otherOperand, operand)) {
                return true;
            }
        } else if (parent instanceof PsiConditionalExpression && opType instanceof PsiPrimitiveType && !(((PsiConditionalExpression)parent).getType() instanceof PsiPrimitiveType) && PsiPrimitiveType.getUnboxedType(PsiTypesUtil.getExpectedTypeByParent((PsiExpression)parent)) != null) {
            return true;
        }
        return false;
    }

    private static boolean wrapperCastChangeSemantics(PsiExpression operand, PsiExpression otherOperand, PsiExpression toCast) {
        boolean isPrimitiveComparisonWithoutCast;
        boolean isPrimitiveComparisonWithCast;
        if (TypeConversionUtil.isPrimitiveAndNotNull(otherOperand.getType())) {
            isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(operand.getType());
            isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(toCast.getType());
        } else {
            isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNull(operand.getType());
            isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNull(toCast.getType());
        }
        return isPrimitiveComparisonWithCast != isPrimitiveComparisonWithoutCast;
    }

    public static boolean isInPolymorphicCall(PsiTypeCastExpression typeCast) {
        PsiElement methodCall;
        if (!PsiUtil.isLanguageLevel7OrHigher(typeCast)) {
            return false;
        }
        PsiExpression operand = typeCast.getOperand();
        if (operand instanceof PsiMethodCallExpression && RedundantCastUtil.isPolymorphicMethod((PsiMethodCallExpression)operand)) {
            return true;
        }
        PsiElement exprList = typeCast.getParent();
        return exprList instanceof PsiExpressionList && (methodCall = exprList.getParent()) instanceof PsiMethodCallExpression && RedundantCastUtil.isPolymorphicMethod((PsiMethodCallExpression)methodCall);
    }

    private static boolean isPolymorphicMethod(PsiMethodCallExpression expression) {
        PsiElement method = expression.getMethodExpression().resolve();
        return method instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)method), "java.lang.invoke.MethodHandle.PolymorphicSignature", false, true);
    }

    private static class MyIsRedundantVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean isRedundant;
        private final boolean myRecursive;

        private MyIsRedundantVisitor(boolean recursive) {
            this.myRecursive = recursive;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.myRecursive) {
                super.visitElement(element);
            }
        }

        protected void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCast", "com/intellij/psi/util/RedundantCastUtil$MyIsRedundantVisitor", "addToResults"));
            }
            if (!RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                this.isRedundant = true;
            }
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            this.processPossibleTypeCast(expression.getRExpression(), expression.getLExpression().getType());
            super.visitAssignmentExpression(expression);
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            this.processPossibleTypeCast(variable.getInitializer(), variable.getType());
            super.visitVariable(variable);
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, true, PsiLambdaExpression.class);
            if (method != null) {
                PsiType returnType = method.getReturnType();
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    this.processPossibleTypeCast(returnValue, returnType);
                }
            }
            super.visitReturnStatement(statement);
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            PsiExpression[] operands = expression.getOperands();
            if (operands.length >= 2) {
                PsiType lType = operands[0].getType();
                this.processBinaryExpressionOperand(RedundantCastUtil.deparenthesizeExpression(operands[0]), operands[1].getType(), tokenType);
                for (int i = 1; i < operands.length; ++i) {
                    PsiExpression operand = RedundantCastUtil.deparenthesizeExpression(operands[i]);
                    if (operand == null) continue;
                    this.processBinaryExpressionOperand(operand, lType, tokenType);
                    lType = TypeConversionUtil.calcTypeForBinaryExpression(lType, operand.getType(), tokenType, true);
                }
            }
            super.visitPolyadicExpression(expression);
        }

        private void processBinaryExpressionOperand(PsiExpression operand, PsiType otherType, IElementType binaryToken) {
            PsiTypeCastExpression typeCast;
            PsiExpression toCast;
            if (operand instanceof PsiTypeCastExpression && (toCast = (typeCast = (PsiTypeCastExpression)operand).getOperand()) != null && TypeConversionUtil.isBinaryOperatorApplicable(binaryToken, toCast.getType(), otherType, false)) {
                this.addToResults(typeCast);
            }
        }

        private void processPossibleTypeCast(PsiExpression rExpr, @Nullable PsiType lType) {
            PsiExpression nestedCastOperand;
            PsiType operandType;
            PsiExpression castOperand;
            if ((rExpr = RedundantCastUtil.deparenthesizeExpression(rExpr)) instanceof PsiTypeCastExpression && (castOperand = ((PsiTypeCastExpression)rExpr).getOperand()) != null && (operandType = castOperand instanceof PsiTypeCastExpression ? ((nestedCastOperand = ((PsiTypeCastExpression)castOperand).getOperand()) != null ? nestedCastOperand.getType() : null) : castOperand.getType()) != null && lType != null && TypeConversionUtil.isAssignable(lType, operandType, false)) {
                this.addToResults((PsiTypeCastExpression)rExpr);
            }
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            this.processCall(expression);
            this.checkForVirtual(expression);
            super.visitMethodCallExpression(expression);
        }

        private void checkForVirtual(PsiMethodCallExpression methodCall) {
            PsiReferenceExpression methodExpr = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpr.getQualifierExpression();
            if (!(qualifier instanceof PsiParenthesizedExpression)) {
                return;
            }
            PsiExpression operand = ((PsiParenthesizedExpression)qualifier).getExpression();
            if (!(operand instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)operand;
            PsiExpression castOperand = typeCast.getOperand();
            if (castOperand == null) {
                return;
            }
            PsiType type = castOperand.getType();
            if (type == null) {
                return;
            }
            if (type instanceof PsiPrimitiveType) {
                return;
            }
            JavaResolveResult resolveResult = methodExpr.advancedResolve(false);
            PsiMethod targetMethod = (PsiMethod)resolveResult.getElement();
            if (targetMethod == null) {
                return;
            }
            if (targetMethod.hasModifierProperty("static")) {
                return;
            }
            try {
                PsiType oldReturnType;
                PsiManager manager = methodExpr.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
                PsiExpression expressionFromText = factory.createExpressionFromText(methodCall.getText(), methodCall);
                if (!(expressionFromText instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression newCall = (PsiMethodCallExpression)expressionFromText;
                PsiExpression newQualifier = newCall.getMethodExpression().getQualifierExpression();
                PsiExpression newOperand = ((PsiTypeCastExpression)((PsiParenthesizedExpression)newQualifier).getExpression()).getOperand();
                newQualifier.replace(newOperand);
                JavaResolveResult newResult = newCall.getMethodExpression().advancedResolve(false);
                if (!newResult.isValidResult()) {
                    return;
                }
                PsiMethod newTargetMethod = (PsiMethod)newResult.getElement();
                PsiType newReturnType = newCall.getType();
                if (Comparing.equal(newReturnType, oldReturnType = methodCall.getType()) && (newTargetMethod.equals(targetMethod) || newTargetMethod.getSignature(newResult.getSubstitutor()).equals(targetMethod.getSignature(resolveResult.getSubstitutor())) && (!newTargetMethod.isDeprecated() || targetMethod.isDeprecated()) && MyIsRedundantVisitor.areThrownExceptionsCompatible(targetMethod, newTargetMethod))) {
                    this.addToResults(typeCast);
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }

        private static boolean areThrownExceptionsCompatible(PsiMethod targetMethod, PsiMethod newTargetMethod) {
            PsiClassType[] newThrowsTypes;
            PsiClassType[] oldThrowsTypes = targetMethod.getThrowsList().getReferencedTypes();
            for (PsiClassType throwsType : newThrowsTypes = newTargetMethod.getThrowsList().getReferencedTypes()) {
                if (MyIsRedundantVisitor.isExceptionThrown(throwsType, oldThrowsTypes)) continue;
                return false;
            }
            return true;
        }

        private static boolean isExceptionThrown(PsiClassType exceptionType, PsiClassType[] thrownTypes) {
            for (PsiClassType type : thrownTypes) {
                if (!type.equals(exceptionType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            this.processCall(expression);
            super.visitNewExpression(expression);
        }

        @Override
        public void visitEnumConstant(PsiEnumConstant enumConstant) {
            this.processCall(enumConstant);
            super.visitEnumConstant(enumConstant);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        private void processCall(PsiCall expression) {
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            PsiMethod oldMethod = expression.resolveMethod();
            if (oldMethod == null) {
                return;
            }
            PsiParameter[] parameters = oldMethod.getParameterList().getParameters();
            try {
                for (int i = 0; i < args.length; ++i) {
                    PsiType interfaceType;
                    PsiExpression arg = RedundantCastUtil.deparenthesizeExpression(args[i]);
                    if (arg instanceof PsiTypeCastExpression) {
                        PsiTypeCastExpression cast = (PsiTypeCastExpression)arg;
                        if (i == args.length - 1 && args.length == parameters.length && parameters[i].isVarArgs()) continue;
                        PsiCall newCall = (PsiCall)expression.copy();
                        PsiExpressionList argList = newCall.getArgumentList();
                        LOG.assertTrue(argList != null);
                        PsiExpression[] newArgs = argList.getExpressions();
                        PsiTypeCastExpression castExpression = (PsiTypeCastExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
                        PsiExpression castOperand = castExpression.getOperand();
                        if (castOperand == null) {
                            return;
                        }
                        PsiMethod oldFunctionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(castOperand);
                        newArgs[i] = (PsiExpression)castExpression.replace(castOperand);
                        if (newCall instanceof PsiEnumConstant) {
                            PsiEnumConstant enumConstant = (PsiEnumConstant)expression;
                            PsiClass containingClass = enumConstant.getContainingClass();
                            JavaPsiFacade facade = JavaPsiFacade.getInstance(enumConstant.getProject());
                            PsiClassType type = facade.getElementFactory().createType(containingClass);
                            JavaResolveResult newResult = facade.getResolveHelper().resolveConstructor(type, newCall.getArgumentList(), enumConstant);
                            if (!oldMethod.equals(newResult.getElement()) || !newResult.isValidResult()) continue;
                            this.addToResults(cast);
                            continue;
                        }
                        JavaResolveResult newResult = newCall.resolveMethodGenerics();
                        if (!oldMethod.equals(newResult.getElement()) || !newResult.isValidResult() || !Comparing.equal(((PsiCallExpression)newCall).getType(), ((PsiCallExpression)expression).getType())) continue;
                        PsiMethod newFunctionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(newArgs[i]);
                        if (oldFunctionalInterfaceMethod != null && (newFunctionalInterfaceMethod == null || newFunctionalInterfaceMethod != oldFunctionalInterfaceMethod && !MethodSignatureUtil.isSuperMethod(newFunctionalInterfaceMethod, oldFunctionalInterfaceMethod))) continue;
                        this.addToResults(cast);
                        continue;
                    }
                    if (!(arg instanceof PsiLambdaExpression) || (interfaceType = ((PsiLambdaExpression)arg).getFunctionalInterfaceType()) == null) continue;
                    List<PsiExpression> expressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
                    for (int returnExprIdx = 0; returnExprIdx < expressions.size(); ++returnExprIdx) {
                        PsiExpression elseExpression;
                        PsiExpression returnExpression = RedundantCastUtil.deparenthesizeExpression(expressions.get(returnExprIdx));
                        if (returnExpression instanceof PsiTypeCastExpression) {
                            this.processLambdaReturnExpression(expression, i, interfaceType, (PsiTypeCastExpression)returnExpression, returnExprIdx, new Function<PsiExpression, PsiTypeCastExpression>(){

                                @Override
                                public PsiTypeCastExpression fun(PsiExpression expression) {
                                    return (PsiTypeCastExpression)expression;
                                }
                            });
                            continue;
                        }
                        if (!(returnExpression instanceof PsiConditionalExpression)) continue;
                        PsiExpression thenExpression = ((PsiConditionalExpression)returnExpression).getThenExpression();
                        if (thenExpression instanceof PsiTypeCastExpression) {
                            this.processLambdaReturnExpression(expression, i, interfaceType, (PsiTypeCastExpression)thenExpression, returnExprIdx, new Function<PsiExpression, PsiTypeCastExpression>(){

                                @Override
                                public PsiTypeCastExpression fun(PsiExpression expression) {
                                    return (PsiTypeCastExpression)((PsiConditionalExpression)expression).getThenExpression();
                                }
                            });
                        }
                        if (!((elseExpression = ((PsiConditionalExpression)returnExpression).getElseExpression()) instanceof PsiTypeCastExpression)) continue;
                        this.processLambdaReturnExpression(expression, i, interfaceType, (PsiTypeCastExpression)elseExpression, returnExprIdx, new Function<PsiExpression, PsiTypeCastExpression>(){

                            @Override
                            public PsiTypeCastExpression fun(PsiExpression expression) {
                                return (PsiTypeCastExpression)((PsiConditionalExpression)expression).getElseExpression();
                            }
                        });
                    }
                }
            }
            catch (IncorrectOperationException e) {
                return;
            }
            for (PsiExpression arg : args) {
                if (arg instanceof PsiTypeCastExpression) {
                    PsiExpression castOperand = ((PsiTypeCastExpression)arg).getOperand();
                    if (castOperand == null) continue;
                    castOperand.accept(this);
                    continue;
                }
                arg.accept(this);
            }
        }

        private void processLambdaReturnExpression(PsiCall expression, int i, PsiType interfaceType, PsiTypeCastExpression returnExpression, int returnExprIdx, Function<PsiExpression, PsiTypeCastExpression> computeCastExpression) {
            PsiCall newCall = (PsiCall)expression.copy();
            PsiExpressionList newArgsList = newCall.getArgumentList();
            LOG.assertTrue(newArgsList != null);
            PsiExpression[] newArgs = newArgsList.getExpressions();
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
            LOG.assertTrue(lambdaExpression != null, newCall);
            PsiExpression newReturnExpression = RedundantCastUtil.deparenthesizeExpression(LambdaUtil.getReturnExpressions(lambdaExpression).get(returnExprIdx));
            PsiTypeCastExpression castExpression = computeCastExpression.fun(newReturnExpression);
            PsiExpression castOperand = castExpression.getOperand();
            if (castOperand == null) {
                return;
            }
            castOperand = (PsiExpression)castExpression.replace(castOperand);
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (interfaceType.equals(functionalInterfaceType)) {
                PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(interfaceType);
                PsiType castExprType = castOperand.getType();
                if (interfaceReturnType != null && castExprType != null && interfaceReturnType.isAssignableFrom(castExprType)) {
                    this.addToResults(returnExpression);
                }
            }
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
            PsiExpression operand = typeCast.getOperand();
            if (operand == null) {
                return;
            }
            PsiExpression expr = RedundantCastUtil.deparenthesizeExpression(operand);
            PsiType topCastType = typeCast.getType();
            if (expr instanceof PsiTypeCastExpression) {
                PsiType operandType;
                PsiTypeElement typeElement = ((PsiTypeCastExpression)expr).getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType castType = typeElement.getType();
                PsiExpression innerOperand = ((PsiTypeCastExpression)expr).getOperand();
                PsiType psiType = operandType = innerOperand != null ? innerOperand.getType() : null;
                if (!(castType instanceof PsiPrimitiveType) && !(topCastType instanceof PsiPrimitiveType)) {
                    if (operandType != null && topCastType != null && TypeConversionUtil.areTypesConvertible(operandType, topCastType)) {
                        this.addToResults((PsiTypeCastExpression)expr);
                    }
                } else if (PsiPrimitiveType.getUnboxedType(operandType) == topCastType) {
                    this.addToResults((PsiTypeCastExpression)expr);
                }
            } else {
                PsiElement parent = typeCast.getParent();
                if (parent instanceof PsiConditionalExpression) {
                    PsiType conditionalType;
                    PsiType operandType = operand.getType();
                    if (!Comparing.equal(operandType, conditionalType = ((PsiConditionalExpression)parent).getType())) {
                        PsiExpression opposite;
                        if (!PsiUtil.isLanguageLevel5OrHigher(typeCast)) {
                            return;
                        }
                        if (!MyIsRedundantVisitor.checkResolveAfterRemoveCast(parent)) {
                            return;
                        }
                        PsiExpression thenExpression = ((PsiConditionalExpression)parent).getThenExpression();
                        PsiExpression elseExpression = ((PsiConditionalExpression)parent).getElseExpression();
                        PsiExpression psiExpression = opposite = thenExpression == typeCast ? elseExpression : thenExpression;
                        if (opposite == null || !Comparing.equal(conditionalType, opposite.getType())) {
                            return;
                        }
                    }
                } else {
                    if (parent instanceof PsiSynchronizedStatement && expr instanceof PsiExpression && expr.getType() instanceof PsiPrimitiveType) {
                        return;
                    }
                    if (expr instanceof PsiLambdaExpression || expr instanceof PsiMethodReferenceExpression) {
                        if (parent instanceof PsiParenthesizedExpression && parent.getParent() instanceof PsiReferenceExpression) {
                            return;
                        }
                        PsiType functionalInterfaceType = PsiTypesUtil.getExpectedTypeByParent(typeCast);
                        if (topCastType != null && functionalInterfaceType != null && !TypeConversionUtil.isAssignable(topCastType, functionalInterfaceType, false)) {
                            return;
                        }
                    }
                }
                this.processAlreadyHasTypeCast(typeCast);
            }
            super.visitTypeCastExpression(typeCast);
        }

        private static boolean checkResolveAfterRemoveCast(PsiElement parent) {
            PsiElement grandPa = parent.getParent();
            if (grandPa instanceof PsiExpressionList) {
                PsiMethod resolve;
                PsiExpression[] expressions = ((PsiExpressionList)grandPa).getExpressions();
                int idx = ArrayUtil.find(expressions, parent);
                PsiElement grandGrandPa = grandPa.getParent();
                if (grandGrandPa instanceof PsiCall && (resolve = ((PsiCall)grandGrandPa).resolveMethod()) instanceof PsiMethod) {
                    PsiCall expression = (PsiCall)grandGrandPa.copy();
                    PsiExpressionList argumentList = expression.getArgumentList();
                    LOG.assertTrue(argumentList != null);
                    PsiExpression toReplace = argumentList.getExpressions()[idx];
                    if (toReplace instanceof PsiConditionalExpression) {
                        PsiExpression elseOperand;
                        PsiExpression thenExpression = ((PsiConditionalExpression)toReplace).getThenExpression();
                        PsiExpression elseExpression = ((PsiConditionalExpression)toReplace).getElseExpression();
                        if (thenExpression instanceof PsiTypeCastExpression) {
                            PsiExpression thenOperand = ((PsiTypeCastExpression)thenExpression).getOperand();
                            if (thenOperand != null) {
                                thenExpression.replace(thenOperand);
                            }
                        } else if (elseExpression instanceof PsiTypeCastExpression && (elseOperand = ((PsiTypeCastExpression)elseExpression).getOperand()) != null) {
                            elseExpression.replace(elseOperand);
                        }
                    }
                    if (expression.resolveMethod() != resolve) {
                        return false;
                    }
                }
            }
            return true;
        }

        private void processAlreadyHasTypeCast(PsiTypeCastExpression typeCast) {
            PsiElement parent = typeCast.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionList) {
                return;
            }
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            if (parent instanceof PsiTypeCastExpression) {
                return;
            }
            if (parent instanceof PsiLambdaExpression) {
                return;
            }
            if (parent instanceof PsiConditionalExpression) {
                PsiElement gParent = PsiUtil.skipParenthesizedExprUp(parent.getParent());
                if (gParent instanceof PsiLambdaExpression) {
                    return;
                }
                if (gParent instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType(gParent, PsiMethod.class, PsiLambdaExpression.class) instanceof PsiLambdaExpression) {
                    return;
                }
            }
            if (RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                return;
            }
            PsiTypeElement typeElement = typeCast.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castTo = typeElement.getType();
            PsiExpression operand = typeCast.getOperand();
            PsiType opType = operand.getType();
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent(typeCast);
            if (expectedTypeByParent != null) {
                try {
                    PsiExpression expr;
                    Project project = operand.getProject();
                    String uniqueVariableName = JavaCodeStyleManager.getInstance(project).suggestUniqueVariableName("l", parent, false);
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)JavaPsiFacade.getElementFactory(project).createStatementFromText(expectedTypeByParent.getCanonicalText() + " " + uniqueVariableName + " = " + operand.getText() + ";", parent);
                    PsiExpression initializer = ((PsiLocalVariable)declarationStatement.getDeclaredElements()[0]).getInitializer();
                    LOG.assertTrue(initializer != null, operand.getText());
                    opType = initializer.getType();
                    if (opType != null && (expr = PsiUtil.skipParenthesizedExprDown(operand)) instanceof PsiConditionalExpression) {
                        if (!MyIsRedundantVisitor.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)expr).getThenExpression())) {
                            return;
                        }
                        if (!MyIsRedundantVisitor.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)expr).getElseExpression())) {
                            return;
                        }
                    }
                }
                catch (IncorrectOperationException project) {
                    // empty catch block
                }
            }
            if (opType == null) {
                return;
            }
            if (parent instanceof PsiReferenceExpression) {
                if (castTo instanceof PsiClassType && opType instanceof PsiPrimitiveType) {
                    return;
                }
                if (opType instanceof PsiClassType) {
                    PsiReferenceExpression refExpression = (PsiReferenceExpression)parent;
                    PsiElement element = refExpression.resolve();
                    if (!(element instanceof PsiMember)) {
                        return;
                    }
                    PsiClass accessClass = ((PsiClassType)opType).resolve();
                    if (accessClass == null) {
                        return;
                    }
                    if (!JavaPsiFacade.getInstance(parent.getProject()).getResolveHelper().isAccessible((PsiMember)element, typeCast, accessClass)) {
                        return;
                    }
                    if (!RedundantCastUtil.isCastRedundantInRefExpression(refExpression, operand)) {
                        return;
                    }
                }
            }
            if (parent instanceof PsiConditionalExpression && castTo instanceof PsiClassType && opType instanceof PsiPrimitiveType && opType != PsiType.NULL) {
                PsiExpression opposite;
                PsiExpression thenExpression = ((PsiConditionalExpression)parent).getThenExpression();
                PsiExpression elseExpression = ((PsiConditionalExpression)parent).getElseExpression();
                PsiExpression psiExpression = opposite = PsiTreeUtil.isAncestor(thenExpression, typeCast, false) ? elseExpression : thenExpression;
                if (opposite != null && !(opposite.getType() instanceof PsiPrimitiveType) && !(PsiTypesUtil.getExpectedTypeByParent((PsiExpression)parent) instanceof PsiPrimitiveType)) {
                    return;
                }
            }
            if (MyIsRedundantVisitor.arrayAccessAtTheLeftSideOfAssignment(parent)) {
                if (TypeConversionUtil.isAssignable(opType, castTo, false) && opType.getArrayDimensions() == castTo.getArrayDimensions()) {
                    this.addToResults(typeCast);
                }
            } else {
                if (parent instanceof PsiInstanceOfExpression && opType instanceof PsiPrimitiveType) {
                    return;
                }
                if (parent instanceof PsiForeachStatement) {
                    PsiClassType.ClassResolveResult castResolveResult = PsiUtil.resolveGenericsClassInType(opType);
                    PsiClass psiClass = castResolveResult.getElement();
                    if (psiClass != null) {
                        PsiType resultedParamType;
                        PsiTypeParameter[] iterableTypeParameters;
                        PsiClass iterableClass = JavaPsiFacade.getInstance(parent.getProject()).findClass("java.lang.Iterable", psiClass.getResolveScope());
                        if (iterableClass != null && InheritanceUtil.isInheritorOrSelf(psiClass, iterableClass, true) && (iterableTypeParameters = iterableClass.getTypeParameters()).length == 1 && (resultedParamType = TypeConversionUtil.getSuperClassSubstitutor(iterableClass, psiClass, castResolveResult.getSubstitutor()).substitute(iterableTypeParameters[0])) != null && TypeConversionUtil.isAssignable(((PsiForeachStatement)parent).getIterationParameter().getType(), resultedParamType)) {
                            this.addToResults(typeCast);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (parent instanceof PsiThrowStatement) {
                    PsiMethod method;
                    PsiClass thrownClass = PsiUtil.resolveClassInType(opType);
                    if (InheritanceUtil.isInheritor(thrownClass, false, "java.lang.RuntimeException")) {
                        this.addToResults(typeCast);
                        return;
                    }
                    if (InheritanceUtil.isInheritor(thrownClass, false, "java.lang.Throwable") && (method = PsiTreeUtil.getParentOfType(parent, PsiMethod.class)) != null) {
                        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
                            if (!TypeConversionUtil.isAssignable(thrownType, opType, false)) continue;
                            this.addToResults(typeCast);
                            return;
                        }
                    }
                }
                if (parent instanceof PsiInstanceOfExpression) {
                    PsiTypeElement checkTypeElement = ((PsiInstanceOfExpression)parent).getCheckType();
                    if (checkTypeElement != null && TypeConversionUtil.areTypesConvertible(opType, checkTypeElement.getType())) {
                        this.addToResults(typeCast);
                    }
                } else if (TypeConversionUtil.isAssignable(castTo, opType, false) && (expectedTypeByParent == null || TypeConversionUtil.isAssignable(expectedTypeByParent, opType, false))) {
                    this.addToResults(typeCast);
                }
            }
        }

        private static boolean isApplicableForConditionalBranch(PsiType opType, PsiExpression thenExpression) {
            PsiType thenType;
            return thenExpression == null || (thenType = thenExpression.getType()) == null || TypeConversionUtil.isAssignable(opType, thenType);
        }

        private static boolean arrayAccessAtTheLeftSideOfAssignment(PsiElement element) {
            PsiAssignmentExpression assignment = PsiTreeUtil.getParentOfType(element, PsiAssignmentExpression.class, false, PsiMember.class);
            if (assignment == null) {
                return false;
            }
            PsiExpression lExpression = assignment.getLExpression();
            return PsiTreeUtil.isAncestor(lExpression, element, false) && lExpression instanceof PsiArrayAccessExpression;
        }
    }

    private static class MyCollectingVisitor
    extends MyIsRedundantVisitor {
        private final Set<PsiTypeCastExpression> myFoundCasts = new HashSet<PsiTypeCastExpression>();

        private MyCollectingVisitor() {
            super(true);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visitClass(PsiClass aClass) {
        }

        @Override
        public void visitMethod(PsiMethod method) {
        }

        @Override
        public void visitField(PsiField field) {
        }

        @Override
        protected void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCast", "com/intellij/psi/util/RedundantCastUtil$MyCollectingVisitor", "addToResults"));
            }
            if (!RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                this.myFoundCasts.add(typeCast);
            }
        }
    }
}

