/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import org.jetbrains.annotations.NotNull;

class CallToSuperTeardownVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean callToSuperTearDownFound;

    CallToSuperTeardownVisitor() {
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/junit/CallToSuperTeardownVisitor", "visitElement"));
        }
        if (!this.callToSuperTearDownFound) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/CallToSuperTeardownVisitor", "visitMethodCallExpression"));
        }
        if (this.callToSuperTearDownFound) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"tearDown".equals(methodName)) {
            return;
        }
        PsiExpression target = methodExpression.getQualifierExpression();
        if (!(target instanceof PsiSuperExpression)) {
            return;
        }
        this.callToSuperTearDownFound = true;
    }

    boolean isCallToSuperTeardownFound() {
        return this.callToSuperTearDownFound;
    }
}

