/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.CallToSuperTeardownVisitor;
import org.jetbrains.annotations.NotNull;

public class TeardownCallsSuperTeardownInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("TearDownDoesntCallSuperTearDown" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection", "getID"));
        }
        return "TearDownDoesntCallSuperTearDown";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSuperTearDownCall();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TeardownCallsSuperTeardownVisitor();
    }

    private static class TeardownCallsSuperTeardownVisitor
    extends BaseInspectionVisitor {
        private TeardownCallsSuperTeardownVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection$TeardownCallsSuperTeardownVisitor", "visitMethod"));
            }
            String methodName = method.getName();
            if (!"tearDown".equals(methodName)) {
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                return;
            }
            if (method.getBody() == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor(targetClass, "junit.framework.TestCase")) {
                return;
            }
            CallToSuperTeardownVisitor visitor = new CallToSuperTeardownVisitor();
            method.accept(visitor);
            if (visitor.isCallToSuperTeardownFound()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }

    private static class AddSuperTearDownCall
    extends InspectionGadgetsFix {
        private AddSuperTearDownCall() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection$AddSuperTearDownCall", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection$AddSuperTearDownCall", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiStatement newStatement = factory.createStatementFromText("super.tearDown();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
            PsiJavaToken brace = body.getRBrace();
            body.addBefore(newStatement, brace);
            styleManager.reformat(body);
        }
    }
}

