/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ApdexData;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerformanceWatcher
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.diagnostic.PerformanceWatcher");
    private Thread myThread;
    private int myLoopCounter;
    private int mySwingThreadCounter;
    private final Semaphore myShutdownSemaphore = new Semaphore(1);
    private ThreadMXBean myThreadMXBean;
    private final DateFormat myDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private File mySessionLogDir;
    private int myUnresponsiveDuration;
    private File myCurHangLogDir;
    private List<StackTraceElement> myStacktraceCommonPart;
    private volatile ApdexData mySwingApdex = ApdexData.EMPTY;
    private volatile ApdexData myGeneralApdex = ApdexData.EMPTY;
    private int UNRESPONSIVE_THRESHOLD_SECONDS = 5;
    private int UNRESPONSIVE_INTERVAL_SECONDS = 5;
    private static final int SAMPLING_INTERVAL_MS = 1000;

    public static PerformanceWatcher getInstance() {
        return ApplicationManager.getApplication().getComponent(PerformanceWatcher.class);
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("PerformanceWatcher" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/PerformanceWatcher", "getComponentName"));
        }
        return "PerformanceWatcher";
    }

    @Override
    public void initComponent() {
        String interval;
        this.myThreadMXBean = ManagementFactory.getThreadMXBean();
        if (!this.shouldWatch()) {
            return;
        }
        String threshold = System.getProperty("performance.watcher.threshold");
        if (threshold != null) {
            try {
                this.UNRESPONSIVE_THRESHOLD_SECONDS = Integer.parseInt(threshold);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((interval = System.getProperty("performance.watcher.interval")) != null) {
            try {
                this.UNRESPONSIVE_INTERVAL_SECONDS = Integer.parseInt(interval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.UNRESPONSIVE_THRESHOLD_SECONDS == 0 || this.UNRESPONSIVE_INTERVAL_SECONDS == 0) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                PerformanceWatcher.deleteOldThreadDumps();
            }
        });
        this.myCurHangLogDir = this.mySessionLogDir = new File(PathManager.getLogPath() + "/threadDumps-" + this.myDateFormat.format(new Date()) + "-" + ApplicationInfo.getInstance().getBuild().asString());
        try {
            this.myShutdownSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                PerformanceWatcher.this.checkEDTResponsiveness();
            }
        }, "Performance watcher");
        this.myThread.setPriority(1);
        this.myThread.start();
    }

    private static void deleteOldThreadDumps() {
        Object[] dirs;
        File allLogsDir = new File(PathManager.getLogPath());
        if (allLogsDir.isDirectory() && (dirs = allLogsDir.list(new FilenameFilter(){

            @Override
            public boolean accept(@NotNull File dir, @NotNull String name) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/diagnostic/PerformanceWatcher$3", "accept"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diagnostic/PerformanceWatcher$3", "accept"));
                }
                return name.startsWith("threadDumps-");
            }
        })) != null) {
            Arrays.sort(dirs);
            for (int i = 0; i < dirs.length - 11; ++i) {
                FileUtil.delete(new File(allLogsDir, (String)dirs[i]));
            }
        }
    }

    @Override
    public void disposeComponent() {
        if (!this.shouldWatch()) {
            return;
        }
        this.myShutdownSemaphore.release();
        try {
            this.myThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean shouldWatch() {
        return !ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment() && this.UNRESPONSIVE_INTERVAL_SECONDS != 0 && this.UNRESPONSIVE_THRESHOLD_SECONDS != 0;
    }

    private void checkEDTResponsiveness() {
        long intervalStart = System.currentTimeMillis();
        while (true) {
            long lastMillis = System.currentTimeMillis();
            try {
                if (this.myShutdownSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
                }
            }
            catch (InterruptedException e) {}
            break;
            long millis = System.currentTimeMillis();
            for (long diff = millis - lastMillis - 1000L; diff >= 0L; diff -= 1000L) {
                this.myGeneralApdex = this.myGeneralApdex.withEvent(100L, diff);
            }
            if (millis - intervalStart >= (long)(this.UNRESPONSIVE_INTERVAL_SECONDS * 1000)) {
                intervalStart = millis;
                if (this.mySwingThreadCounter != this.myLoopCounter) {
                    this.edtFrozen();
                } else {
                    this.edtResponds();
                }
            }
            ++this.myLoopCounter;
            SwingUtilities.invokeLater(new SwingThreadRunnable(this.myLoopCounter));
        }
    }

    private void edtFrozen() {
        this.myUnresponsiveDuration += this.UNRESPONSIVE_INTERVAL_SECONDS;
        if (this.myUnresponsiveDuration >= this.UNRESPONSIVE_THRESHOLD_SECONDS) {
            if (this.myCurHangLogDir == this.mySessionLogDir) {
                this.myCurHangLogDir = new File(this.mySessionLogDir, this.myDateFormat.format(new Date()));
            }
            this.dumpThreads("", false);
        }
    }

    private void edtResponds() {
        if (this.myUnresponsiveDuration >= this.UNRESPONSIVE_THRESHOLD_SECONDS) {
            if (this.myCurHangLogDir != this.mySessionLogDir && this.myCurHangLogDir.exists()) {
                this.myCurHangLogDir.renameTo(new File(this.mySessionLogDir, this.getLogDirForHang()));
            }
            this.myUnresponsiveDuration = 0;
            this.myCurHangLogDir = this.mySessionLogDir;
            this.myStacktraceCommonPart = null;
        }
        this.myUnresponsiveDuration = 0;
    }

    private String getLogDirForHang() {
        StringBuilder name = new StringBuilder("freeze-" + this.myCurHangLogDir.getName());
        name.append("-").append(this.myUnresponsiveDuration);
        if (this.myStacktraceCommonPart != null && !this.myStacktraceCommonPart.isEmpty()) {
            StackTraceElement element = this.myStacktraceCommonPart.get(0);
            name.append("-").append(StringUtil.getShortName(element.getClassName())).append(".").append(element.getMethodName());
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File dumpThreads(@NotNull String pathPrefix, boolean millis) {
        if (pathPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPrefix", "com/intellij/diagnostic/PerformanceWatcher", "dumpThreads"));
        }
        if (!this.shouldWatch()) {
            return null;
        }
        String suffix = millis ? "-" + System.currentTimeMillis() : "";
        File file = new File(this.myCurHangLogDir, pathPrefix + "threadDump-" + this.myDateFormat.format(new Date()) + suffix + ".txt");
        File dir = file.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            try {
                StackTraceElement[] edtStack = ThreadDumper.dumpThreadsToFile(this.myThreadMXBean, writer);
                if (edtStack != null) {
                    if (this.myStacktraceCommonPart == null) {
                        this.myStacktraceCommonPart = ContainerUtil.newArrayList(edtStack);
                    } else {
                        this.updateStacktraceCommonPart(edtStack);
                    }
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static void dumpThreadsToConsole(String message) {
        OutputStreamWriter writer = new OutputStreamWriter(System.err);
        try {
            writer.write(message);
            writer.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ThreadDumper.dumpThreadsToFile(PerformanceWatcher.getInstance().myThreadMXBean, writer);
    }

    private void updateStacktraceCommonPart(StackTraceElement[] stackTraceElements) {
        for (int i = 0; i < this.myStacktraceCommonPart.size() && i < stackTraceElements.length; ++i) {
            StackTraceElement el2;
            StackTraceElement el1 = this.myStacktraceCommonPart.get(this.myStacktraceCommonPart.size() - i - 1);
            if (el1.equals(el2 = stackTraceElements[stackTraceElements.length - i - 1])) continue;
            this.myStacktraceCommonPart = this.myStacktraceCommonPart.subList(this.myStacktraceCommonPart.size() - i, this.myStacktraceCommonPart.size());
            break;
        }
    }

    @NotNull
    public static Snapshot takeSnapshot() {
        PerformanceWatcher performanceWatcher = PerformanceWatcher.getInstance();
        performanceWatcher.getClass();
        Snapshot snapshot = performanceWatcher.new Snapshot();
        if (snapshot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/PerformanceWatcher", "takeSnapshot"));
        }
        return snapshot;
    }

    public class Snapshot {
        private final ApdexData myStartGeneralSnapshot;
        private final ApdexData myStartSwingSnapshot;
        private final long myStartMillis;

        private Snapshot() {
            this.myStartGeneralSnapshot = PerformanceWatcher.this.myGeneralApdex;
            this.myStartSwingSnapshot = PerformanceWatcher.this.mySwingApdex;
            this.myStartMillis = System.currentTimeMillis();
        }

        public void logResponsivenessSinceCreation(@NotNull String activityName) {
            if (activityName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/intellij/diagnostic/PerformanceWatcher$Snapshot", "logResponsivenessSinceCreation"));
            }
            LOG.info(activityName + " took " + (System.currentTimeMillis() - this.myStartMillis) + "ms" + "; general responsiveness: " + PerformanceWatcher.this.myGeneralApdex.summarizePerformanceSince(this.myStartGeneralSnapshot) + "; EDT responsiveness: " + PerformanceWatcher.this.mySwingApdex.summarizePerformanceSince(this.myStartSwingSnapshot));
        }
    }

    private class SwingThreadRunnable
    implements Runnable {
        private final int myCount;
        private final long myCreationMillis = System.currentTimeMillis();

        private SwingThreadRunnable(int count) {
            this.myCount = count;
        }

        @Override
        public void run() {
            PerformanceWatcher.this.mySwingThreadCounter = this.myCount;
            PerformanceWatcher.this.mySwingApdex = PerformanceWatcher.this.mySwingApdex.withEvent(100L, System.currentTimeMillis() - this.myCreationMillis);
        }
    }
}

