/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class InferenceIncorporationPhase {
    private static final Logger LOG = Logger.getInstance("#" + InferenceIncorporationPhase.class.getName());
    private final InferenceSession mySession;
    private final List<Pair<PsiTypeParameter[], PsiClassType>> myCaptures = new ArrayList<Pair<PsiTypeParameter[], PsiClassType>>();

    public InferenceIncorporationPhase(InferenceSession session) {
        this.mySession = session;
    }

    public void addCapture(PsiTypeParameter[] typeParameters, PsiClassType rightType) {
        this.myCaptures.add(Pair.create(typeParameters, rightType));
    }

    public void forgetCaptures(List<InferenceVariable> variables) {
        for (InferenceVariable variable : variables) {
            PsiTypeParameter parameter = variable.getParameter();
            Iterator<Pair<PsiTypeParameter[], PsiClassType>> iterator = this.myCaptures.iterator();
            block1: while (iterator.hasNext()) {
                Pair<PsiTypeParameter[], PsiClassType> capture = iterator.next();
                for (PsiTypeParameter typeParameter : (PsiTypeParameter[])capture.first) {
                    if (parameter != typeParameter) continue;
                    iterator.remove();
                    continue block1;
                }
            }
        }
    }

    public boolean hasCaptureConstraints(Iterable<InferenceVariable> variables) {
        for (InferenceVariable variable : variables) {
            PsiTypeParameter parameter = variable.getParameter();
            for (Pair<PsiTypeParameter[], PsiClassType> capture : this.myCaptures) {
                for (PsiTypeParameter typeParameter : (PsiTypeParameter[])capture.first) {
                    if (parameter != typeParameter) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean incorporate() {
        Collection<InferenceVariable> inferenceVariables = this.mySession.getInferenceVariables();
        PsiSubstitutor substitutor = this.mySession.retrieveNonPrimitiveEqualsBounds(inferenceVariables);
        for (InferenceVariable inferenceVariable : inferenceVariables) {
            if (inferenceVariable.getInstantiation() != PsiType.NULL) continue;
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
            List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            this.eqEq(eqBounds);
            this.upDown(lowerBounds, upperBounds, substitutor);
            this.upDown(eqBounds, upperBounds, substitutor);
            this.upDown(lowerBounds, eqBounds, substitutor);
            this.upUp(upperBounds);
        }
        for (Pair pair : this.myCaptures) {
            PsiClassType right = (PsiClassType)pair.second;
            PsiClass gClass = right.resolve();
            LOG.assertTrue(gClass != null);
            PsiTypeParameter[] parameters = (PsiTypeParameter[])pair.first;
            PsiType[] typeArgs = right.getParameters();
            if (parameters.length != typeArgs.length) continue;
            for (int i = 0; i < typeArgs.length; ++i) {
                InferenceVariable inferenceVariable;
                PsiType aType = typeArgs[i];
                if (aType instanceof PsiCapturedWildcardType) {
                    aType = ((PsiCapturedWildcardType)aType).getWildcard();
                }
                LOG.assertTrue((inferenceVariable = this.mySession.getInferenceVariable(parameters[i])) != null);
                List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
                List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
                List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
                if (aType instanceof PsiWildcardType) {
                    for (PsiType psiType : eqBounds) {
                        if (this.mySession.getInferenceVariable(psiType) != null) continue;
                        return false;
                    }
                    PsiClassType[] paramBounds = parameters[i].getExtendsListTypes();
                    if (!((PsiWildcardType)aType).isBounded()) {
                        for (PsiType upperBound : upperBounds) {
                            if (this.mySession.getInferenceVariable(upperBound) != null) continue;
                            for (PsiClassType paramBound : paramBounds) {
                                this.addConstraint(new StrictSubtypingConstraint(upperBound, this.mySession.substituteWithInferenceVariables(paramBound)));
                            }
                        }
                        for (PsiType lowerBound : lowerBounds) {
                            if (this.mySession.getInferenceVariable(lowerBound) != null) continue;
                            return false;
                        }
                        continue;
                    }
                    if (((PsiWildcardType)aType).isExtends()) {
                        PsiType psiType = ((PsiWildcardType)aType).getExtendsBound();
                        for (PsiType upperBound : upperBounds) {
                            if (this.mySession.getInferenceVariable(upperBound) != null) continue;
                            if (paramBounds.length == 1 && paramBounds[0].equalsToText("java.lang.Object") || paramBounds.length == 0) {
                                this.addConstraint(new StrictSubtypingConstraint(upperBound, psiType));
                                continue;
                            }
                            if (!psiType.equalsToText("java.lang.Object")) continue;
                            for (PsiClassType paramBound : paramBounds) {
                                this.addConstraint(new StrictSubtypingConstraint(upperBound, this.mySession.substituteWithInferenceVariables(paramBound)));
                            }
                        }
                        for (PsiType lowerBound : lowerBounds) {
                            if (this.mySession.getInferenceVariable(lowerBound) != null) continue;
                            return false;
                        }
                        continue;
                    }
                    LOG.assertTrue(((PsiWildcardType)aType).isSuper());
                    PsiType psiType = ((PsiWildcardType)aType).getSuperBound();
                    for (PsiType upperBound : upperBounds) {
                        if (this.mySession.getInferenceVariable(upperBound) != null) continue;
                        for (PsiClassType paramBound : paramBounds) {
                            this.addConstraint(new StrictSubtypingConstraint(this.mySession.substituteWithInferenceVariables(paramBound), upperBound));
                        }
                    }
                    for (PsiType lowerBound : lowerBounds) {
                        if (this.mySession.getInferenceVariable(lowerBound) != null) continue;
                        this.addConstraint(new StrictSubtypingConstraint(lowerBound, psiType));
                    }
                    continue;
                }
                inferenceVariable.addBound(aType, InferenceBound.EQ);
            }
        }
        return true;
    }

    boolean isFullyIncorporated() {
        boolean needFurtherIncorporation = false;
        for (InferenceVariable inferenceVariable : this.mySession.getInferenceVariables()) {
            if (inferenceVariable.getInstantiation() != PsiType.NULL) continue;
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
            List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            needFurtherIncorporation |= this.crossVariables(inferenceVariable, upperBounds, lowerBounds, InferenceBound.LOWER);
            needFurtherIncorporation |= this.crossVariables(inferenceVariable, lowerBounds, upperBounds, InferenceBound.UPPER);
            needFurtherIncorporation |= this.eqCrossVariables(inferenceVariable, eqBounds);
        }
        return !needFurtherIncorporation;
    }

    private boolean eqCrossVariables(InferenceVariable inferenceVariable, List<PsiType> eqBounds) {
        boolean needFurtherIncorporation = false;
        for (PsiType eqBound : eqBounds) {
            InferenceVariable inferenceVar = this.mySession.getInferenceVariable(eqBound);
            if (inferenceVar == null) continue;
            for (InferenceBound inferenceBound : InferenceBound.values()) {
                for (PsiType bound : inferenceVariable.getBounds(inferenceBound)) {
                    if (this.mySession.getInferenceVariable(bound) == inferenceVar) continue;
                    needFurtherIncorporation |= inferenceVar.addBound(bound, inferenceBound);
                }
                for (PsiType bound : inferenceVar.getBounds(inferenceBound)) {
                    if (this.mySession.getInferenceVariable(bound) == inferenceVariable) continue;
                    needFurtherIncorporation |= inferenceVariable.addBound(bound, inferenceBound);
                }
            }
        }
        return needFurtherIncorporation;
    }

    private boolean crossVariables(InferenceVariable inferenceVariable, List<PsiType> upperBounds, List<PsiType> lowerBounds, InferenceBound inferenceBound) {
        InferenceBound oppositeBound = inferenceBound == InferenceBound.LOWER ? InferenceBound.UPPER : InferenceBound.LOWER;
        boolean result = false;
        for (PsiType upperBound : upperBounds) {
            InferenceVariable inferenceVar = this.mySession.getInferenceVariable(upperBound);
            if (inferenceVar == null || inferenceVariable == inferenceVar) continue;
            for (PsiType lowerBound : lowerBounds) {
                result |= inferenceVar.addBound(lowerBound, inferenceBound);
            }
            for (PsiType varUpperBound : inferenceVar.getBounds(oppositeBound)) {
                result |= inferenceVariable.addBound(varUpperBound, oppositeBound);
            }
        }
        return result;
    }

    private void upDown(List<PsiType> eqBounds, List<PsiType> upperBounds, PsiSubstitutor substitutor) {
        for (PsiType upperBound : upperBounds) {
            if (upperBound == null) continue;
            for (PsiType eqBound : eqBounds) {
                if (eqBound == null) continue;
                this.addConstraint(new StrictSubtypingConstraint(substitutor.substitute(upperBound), substitutor.substitute(eqBound)));
            }
        }
    }

    private void eqEq(List<PsiType> eqBounds) {
        for (int i = 0; i < eqBounds.size(); ++i) {
            PsiType sBound = eqBounds.get(i);
            for (int j = i + 1; j < eqBounds.size(); ++j) {
                PsiType tBound = eqBounds.get(j);
                this.addConstraint(new TypeEqualityConstraint(tBound, sBound));
            }
        }
    }

    private boolean upUp(List<PsiType> upperBounds) {
        return InferenceSession.findParameterizationOfTheSameGenericClass(upperBounds, new Processor<Pair<PsiType, PsiType>>(){

            @Override
            public boolean process(Pair<PsiType, PsiType> pair) {
                PsiType sType = (PsiType)pair.first;
                PsiType tType = (PsiType)pair.second;
                if (!(sType instanceof PsiWildcardType) && !(tType instanceof PsiWildcardType) && sType != null && tType != null) {
                    InferenceIncorporationPhase.this.addConstraint(new TypeEqualityConstraint(sType, tType));
                }
                return true;
            }
        }) != null;
    }

    private void addConstraint(ConstraintFormula constraint) {
        this.mySession.addConstraint(constraint);
    }

    public void collectCaptureDependencies(InferenceVariable variable, Set<InferenceVariable> dependencies) {
        PsiTypeParameter parameter = variable.getParameter();
        block0: for (Pair<PsiTypeParameter[], PsiClassType> capture : this.myCaptures) {
            for (PsiTypeParameter typeParameter : (PsiTypeParameter[])capture.first) {
                if (typeParameter != parameter) continue;
                this.collectAllVariablesOnBothSides(dependencies, capture);
                continue block0;
            }
        }
    }

    protected void collectAllVariablesOnBothSides(Set<InferenceVariable> dependencies, Pair<PsiTypeParameter[], PsiClassType> capture) {
        this.mySession.collectDependencies((PsiType)capture.second, dependencies);
        for (PsiTypeParameter psiTypeParameter : (PsiTypeParameter[])capture.first) {
            InferenceVariable var = this.mySession.getInferenceVariable(psiTypeParameter);
            if (var == null) continue;
            dependencies.add(var);
        }
    }
}

