/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class AsyncValueLoader<T> {
    private final AtomicReference<Promise<T>> ref = new AtomicReference();
    private volatile long modificationCount;
    private volatile long loadedModificationCount;
    private final Consumer<T> doneHandler = new Consumer<T>(){

        @Override
        public void consume(T o) {
            AsyncValueLoader.this.loadedModificationCount = AsyncValueLoader.this.modificationCount;
        }
    };

    @NotNull
    public final Promise<T> get() {
        Promise<T> promise = this.get(true);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncValueLoader", "get"));
        }
        return promise;
    }

    public final T getResult() {
        return (T)((Getter)((Object)this.get(true))).get();
    }

    public final void reset() {
        Promise oldValue = this.ref.getAndSet(null);
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    private void rejectAndDispose(@NotNull AsyncPromise<T> asyncResult) {
        if (asyncResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncResult", "org/jetbrains/concurrency/AsyncValueLoader", "rejectAndDispose"));
        }
        try {
            asyncResult.setError(Promise.createError("rejected"));
        }
        finally {
            T result = asyncResult.get();
            if (result != null) {
                this.disposeResult(result);
            }
        }
    }

    protected void disposeResult(@NotNull T result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/concurrency/AsyncValueLoader", "disposeResult"));
        }
        if (result instanceof Disposable) {
            Disposer.dispose((Disposable)result, false);
        }
    }

    public final boolean has() {
        Promise<T> result = this.ref.get();
        return result != null && result.getState() == Promise.State.FULFILLED && ((Getter)((Object)result)).get() != null;
    }

    @NotNull
    public final Promise<T> get(boolean checkFreshness) {
        Promise<T> promise = this.ref.get();
        if (promise == null) {
            promise = new AsyncPromise();
            if (!this.ref.compareAndSet(null, promise)) {
                Promise<T> promise2 = this.ref.get();
                if (promise2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncValueLoader", "get"));
                }
                return promise2;
            }
        } else {
            Promise.State state = promise.getState();
            if (state == Promise.State.PENDING) {
                Promise<T> promise3 = promise;
                if (promise3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncValueLoader", "get"));
                }
                return promise3;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(((Getter)((Object)promise)).get())) {
                    Promise<T> promise4 = promise;
                    if (promise4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncValueLoader", "get"));
                    }
                    return promise4;
                }
                if (!this.ref.compareAndSet(promise, promise = new AsyncPromise())) {
                    Promise<T> valueFromAnotherThread = this.ref.get();
                    while (valueFromAnotherThread == null) {
                        if (this.ref.compareAndSet(null, promise)) {
                            Promise<T> promise5 = this.getPromise((AsyncPromise)promise);
                            if (promise5 == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncValueLoader", "get"));
                            }
                            return promise5;
                        }
                        valueFromAnotherThread = this.ref.get();
                    }
                    Promise<T> promise6 = valueFromAnotherThread;
                    if (promise6 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncValueLoader", "get"));
                    }
                    return promise6;
                }
            }
        }
        Promise<T> promise7 = this.getPromise((AsyncPromise)promise);
        if (promise7 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncValueLoader", "get"));
        }
        return promise7;
    }

    protected boolean isCancelOnReject() {
        return false;
    }

    @NotNull
    private Promise<T> getPromise(@NotNull AsyncPromise<T> promise) {
        Promise<T> effectivePromise;
        if (promise == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "org/jetbrains/concurrency/AsyncValueLoader", "getPromise"));
        }
        try {
            effectivePromise = this.load(promise);
            if (effectivePromise != promise) {
                this.ref.compareAndSet(promise, effectivePromise);
            }
        }
        catch (Throwable e) {
            this.ref.compareAndSet(promise, null);
            this.rejectAndDispose(promise);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        effectivePromise.done(this.doneHandler);
        if (this.isCancelOnReject()) {
            effectivePromise.rejected(new Consumer<Throwable>(){

                @Override
                public void consume(Throwable throwable) {
                    AsyncValueLoader.this.ref.compareAndSet(effectivePromise, null);
                }
            });
        }
        if (effectivePromise != promise) {
            effectivePromise.notify(promise);
        }
        Promise<T> promise2 = effectivePromise;
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/AsyncValueLoader", "getPromise"));
        }
        return promise2;
    }

    @NotNull
    protected abstract Promise<T> load(@NotNull AsyncPromise<T> var1) throws IOException;

    protected boolean isUpToDate(@Nullable T result) {
        return this.loadedModificationCount == this.modificationCount;
    }

    public final void set(@NotNull T result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/concurrency/AsyncValueLoader", "set"));
        }
        Promise<T> oldValue = this.ref.getAndSet(Promise.resolve(result));
        if (oldValue != null && oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    public final void markDirty() {
        ++this.modificationCount;
    }
}

