/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModuleManager;
import com.intellij.mock.MockProject;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.StateMap;
import com.intellij.openapi.components.impl.stores.StorageDataBase;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class CoreProjectLoader {
    public static boolean loadProject(MockProject project, @NotNull VirtualFile virtualFile) throws IOException, JDOMException, InvalidDataException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/core/CoreProjectLoader", "loadProject"));
        }
        if (virtualFile.isDirectory() && virtualFile.findChild(".idea") != null) {
            project.setBaseDir(virtualFile);
            CoreProjectLoader.loadDirectoryProject(project, virtualFile);
            return true;
        }
        return false;
    }

    private static void loadDirectoryProject(MockProject project, VirtualFile projectDir) throws IOException, JDOMException, InvalidDataException {
        VirtualFile dotIdea = projectDir.findChild(".idea");
        if (dotIdea == null) {
            throw new FileNotFoundException("Missing '.idea' in " + projectDir.getPath());
        }
        VirtualFile modulesXml = dotIdea.findChild("modules.xml");
        if (modulesXml == null) {
            throw new FileNotFoundException("Missing 'modules.xml' in " + dotIdea.getPath());
        }
        StateMap storageData = CoreProjectLoader.loadStorageFile(project, modulesXml);
        Element moduleManagerState = storageData.getState("ProjectModuleManager");
        if (moduleManagerState == null) {
            throw new JDOMException("cannot find ProjectModuleManager state in modules.xml");
        }
        CoreModuleManager moduleManager = (CoreModuleManager)ModuleManager.getInstance(project);
        moduleManager.loadState(moduleManagerState);
        VirtualFile miscXml = dotIdea.findChild("misc.xml");
        if (miscXml == null) {
            throw new FileNotFoundException("Missing 'misc.xml' in " + dotIdea.getPath());
        }
        storageData = CoreProjectLoader.loadStorageFile(project, miscXml);
        Element projectRootManagerState = storageData.getState("ProjectRootManager");
        if (projectRootManagerState == null) {
            throw new JDOMException("cannot find ProjectRootManager state in misc.xml");
        }
        ((ProjectRootManagerImpl)ProjectRootManager.getInstance(project)).readExternal(projectRootManagerState);
        VirtualFile libraries = dotIdea.findChild("libraries");
        if (libraries != null) {
            DirectoryStorageData data = new DirectoryStorageData();
            data.loadFrom(libraries, PathMacroManager.getInstance(project).createTrackingSubstitutor());
            Element libraryTable = DefaultStateSerializer.deserializeState(data.getCompositeStateAndArchive("libraryTable", new ProjectLibraryTable.LibraryStateSplitter()), Element.class, null);
            ((LibraryTableBase)ProjectLibraryTable.getInstance(project)).loadState(libraryTable);
        }
        moduleManager.loadModules();
        project.projectOpened();
    }

    @NotNull
    public static StateMap loadStorageFile(@NotNull ComponentManager componentManager, @NotNull VirtualFile modulesXml) throws JDOMException, IOException {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/core/CoreProjectLoader", "loadStorageFile"));
        }
        if (modulesXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesXml", "com/intellij/core/CoreProjectLoader", "loadStorageFile"));
        }
        StateMap states = new StateMap();
        StorageDataBase.load(states, JDOMUtil.loadDocument(modulesXml.contentsToByteArray()).getRootElement(), PathMacroManager.getInstance(componentManager), false);
        StateMap stateMap = states;
        if (stateMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectLoader", "loadStorageFile"));
        }
        return stateMap;
    }
}

