/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.ManualRangeMarker;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private final VirtualFile myVirtualFile;
    private final Class myType;
    private final Project myProject;
    private final Language myLanguage;
    @Nullable
    private ManualRangeMarker myRangeMarker;
    @Nullable
    private ProperTextRange myPsiRange;

    SelfElementInfo(@NotNull Project project, @NotNull ProperTextRange range, @NotNull Class anchorClass, @NotNull PsiFile containingFile, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (anchorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorClass", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        this.myLanguage = language;
        this.myVirtualFile = PsiUtilCore.getVirtualFile(containingFile);
        this.myType = anchorClass;
        assert (!PsiFile.class.isAssignableFrom(anchorClass)) : "FileElementInfo must be used for files";
        this.myProject = project;
        this.myPsiRange = range;
        Document document = this.getDocumentManager().getCachedDocument(containingFile);
        if (document != null) {
            this.setRange(range, document);
        }
    }

    void setRange(@NotNull TextRange range, @NotNull Document document) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "setRange"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "setRange"));
        }
        this.myPsiRange = null;
        this.myRangeMarker = ((SmartPointerManagerImpl)SmartPointerManager.getInstance(this.myProject)).obtainMarker(document, ProperTextRange.create(range));
    }

    private PsiDocumentManagerBase getDocumentManager() {
        return (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
    }

    @Override
    public Document getDocumentToSynchronize() {
        return this.myVirtualFile == null ? null : FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
    }

    @Override
    public void fastenBelt() {
        Document document;
        if (this.myRangeMarker != null) {
            return;
        }
        if (this.myPsiRange == null) {
            return;
        }
        Document document2 = document = this.myVirtualFile == null ? null : FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        if (document == null || !this.getDocumentManager().isCommitted(document)) {
            this.myPsiRange = null;
            return;
        }
        this.setRange(this.myPsiRange, document);
    }

    @Override
    public PsiElement restoreElement() {
        Segment segment = this.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile file = this.restoreFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return SelfElementInfo.findElementInside(file, segment.getStartOffset(), segment.getEndOffset(), this.myType, this.myLanguage);
    }

    @Nullable
    protected Segment getPsiRange() {
        return this.myRangeMarker != null ? this.myRangeMarker.getRange() : this.myPsiRange;
    }

    @Override
    public PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
    }

    static PsiElement findElementInside(@NotNull PsiFile file, int syncStartOffset, int syncEndOffset, @NotNull Class type, @NotNull Language language) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        PsiElement anchor = file.getViewProvider().findElementAt(syncStartOffset, language);
        if (anchor == null) {
            return null;
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != syncStartOffset) {
            return null;
        }
        while (range.getEndOffset() < syncEndOffset && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        while (range.getEndOffset() == syncEndOffset && anchor != null && !type.equals(anchor.getClass()) && (anchor = anchor.getParent()) != null && anchor.getTextRange() != null) {
            range = anchor.getTextRange();
        }
        return range.getEndOffset() == syncEndOffset ? anchor : null;
    }

    @Override
    public void cleanup() {
        this.myRangeMarker = null;
        this.myPsiRange = null;
    }

    public void updateRange(@NotNull DocumentEvent event, @NotNull Set<ManualRangeMarker> processedMarkers) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "updateRange"));
        }
        if (processedMarkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedMarkers", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "updateRange"));
        }
        assert (this.myPsiRange == null);
        if (this.myRangeMarker != null) {
            if (processedMarkers.add(this.myRangeMarker)) {
                this.myRangeMarker.applyEvent(event);
            }
            if (!this.myRangeMarker.isValid()) {
                this.myRangeMarker = null;
            }
        }
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(final VirtualFile virtualFile, final @NotNull Project project, final @Nullable Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new NullableComputable<PsiFile>(){

            @Override
            public PsiFile compute() {
                VirtualFile child;
                if (project.isDisposed()) {
                    return null;
                }
                if (virtualFile.isValid()) {
                    child = virtualFile;
                } else {
                    VirtualFile vParent = virtualFile.getParent();
                    if (vParent == null || !vParent.isDirectory()) {
                        return null;
                    }
                    String name = virtualFile.getName();
                    child = vParent.findChild(name);
                }
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiFile file = PsiManager.getInstance(project).findFile(child);
                if (file != null && language != null) {
                    return file.getViewProvider().getPsi(language);
                }
                return file;
            }
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(final VirtualFile virtualFile, final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreDirectoryFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiDirectory>(){

            @Override
            public PsiDirectory compute() {
                VirtualFile child;
                if (virtualFile.isValid()) {
                    child = virtualFile;
                } else {
                    VirtualFile vParent = virtualFile.getParent();
                    if (vParent == null || !vParent.isDirectory()) {
                        return null;
                    }
                    String name = virtualFile.getName();
                    child = vParent.findChild(name);
                }
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiDirectory file = PsiManager.getInstance(project).findDirectory(child);
                if (file == null || !file.isValid()) {
                    return null;
                }
                return file;
            }
        });
    }

    @Override
    public int elementHashCode() {
        VirtualFile virtualFile = this.myVirtualFile;
        return virtualFile == null ? 0 : virtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            Segment range1 = this.getPsiRange();
            Segment range2 = otherInfo.getPsiRange();
            return Comparing.equal(this.myVirtualFile, otherInfo.myVirtualFile) && this.myType == otherInfo.myType && range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return Comparing.equal(SelfElementInfo.this.restoreElement(), other.restoreElement());
            }
        });
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    @Nullable
    public Segment getRange() {
        if (this.myRangeMarker != null) {
            Document document = this.getDocumentToSynchronize();
            if (document != null) {
                FrozenDocument frozen = this.getDocumentManager().getLastCommittedDocument(document);
                ManualRangeMarker marker = this.myRangeMarker;
                for (DocumentEvent event : this.getDocumentManager().getEventsSinceCommit(document)) {
                    if ((marker = marker.getUpdatedRange(SelfElementInfo.withFrozen(frozen = frozen.applyEvent(event, 0), event))) != null) continue;
                    return null;
                }
                return marker.getRange();
            }
            return this.myRangeMarker.getRange();
        }
        return this.myPsiRange;
    }

    @NotNull
    static DocumentEventImpl withFrozen(FrozenDocument frozen, DocumentEvent e) {
        DocumentEventImpl documentEventImpl = new DocumentEventImpl(frozen, e.getOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp(), e.isWholeTextReplaced());
        if (documentEventImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "withFrozen"));
        }
        return documentEventImpl;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getProject"));
        }
        return project;
    }

    @Nullable
    ManualRangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }
}

