/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("com.intellij.classInheritorsSearch");
    public static final ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
    }

    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return INSTANCE.createUniqueResultsQuery(parameters);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, checkInheritance, true);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, true);
    }

    public static Query<PsiClass> search(final @NotNull PsiClass aClass, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(aClass, ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

            @Override
            public SearchScope compute() {
                if (!aClass.isValid()) {
                    throw new ProcessCanceledException();
                }
                return aClass.getUseScope();
            }
        }), checkDeep);
    }

    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return ClassInheritorsSearch.search(aClass, true);
    }

    public static class SearchParameters {
        private final PsiClass myClass;
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;
        private final Condition<String> myNameCondition;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, Conditions.alwaysTrue());
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, @NotNull Condition<String> nameCondition) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (nameCondition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameCondition", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            this.myIncludeAnonymous = includeAnonymous;
            this.myNameCondition = nameCondition;
        }

        @NotNull
        public PsiClass getClassToProcess() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "getClassToProcess"));
            }
            return psiClass;
        }

        @NotNull
        public Condition<String> getNameCondition() {
            Condition<String> condition = this.myNameCondition;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "getNameCondition"));
            }
            return condition;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }
    }
}

