/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualRangeMarker {
    private static int ourCount = 0;
    private ProperTextRange myRange;
    private boolean myValid;
    private final boolean myGreedyLeft;
    private final boolean myGreedyRight;
    private final int myHash;
    private PersistentRangeMarker.LinesCols myLinesCols;

    public ManualRangeMarker(@NotNull FrozenDocument document, @NotNull ProperTextRange range, boolean greedyLeft, boolean greedyRight, boolean surviveOnExternalChange) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/ManualRangeMarker", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/ManualRangeMarker", "<init>"));
        }
        this(range, greedyLeft, greedyRight, surviveOnExternalChange ? PersistentRangeMarker.storeLinesAndCols(range, document) : null);
    }

    private ManualRangeMarker(ProperTextRange range, boolean greedyLeft, boolean greedyRight, PersistentRangeMarker.LinesCols linesCols) {
        this.myValid = true;
        this.myHash = ourCount++;
        this.myRange = range;
        this.myGreedyLeft = greedyLeft;
        this.myGreedyRight = greedyRight;
        this.myLinesCols = linesCols;
    }

    @Nullable
    public ManualRangeMarker getUpdatedRange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/ManualRangeMarker", "getUpdatedRange"));
        }
        Pair<ProperTextRange, PersistentRangeMarker.LinesCols> pair = this.getUpdatedState(event);
        return pair == null ? null : new ManualRangeMarker((ProperTextRange)pair.first, this.myGreedyLeft, this.myGreedyRight, (PersistentRangeMarker.LinesCols)pair.second);
    }

    @Nullable
    private Pair<ProperTextRange, PersistentRangeMarker.LinesCols> getUpdatedState(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/ManualRangeMarker", "getUpdatedState"));
        }
        if (event instanceof RetargetRangeMarkers) {
            int start = ((RetargetRangeMarkers)event).getStartOffset();
            if (this.myRange.getStartOffset() >= start && this.myRange.getEndOffset() <= ((RetargetRangeMarkers)event).getEndOffset()) {
                ProperTextRange range = this.myRange.shiftRight(((RetargetRangeMarkers)event).getMoveDestinationOffset() - start);
                return Pair.create(range, this.myLinesCols == null ? null : PersistentRangeMarker.storeLinesAndCols(range, event.getDocument()));
            }
        }
        if (this.myLinesCols != null) {
            return PersistentRangeMarker.applyChange(event, this.myRange, this.myRange.getStartOffset(), this.myRange.getEndOffset(), this.myGreedyLeft, this.myGreedyRight, this.myLinesCols);
        }
        ProperTextRange range = RangeMarkerImpl.applyChange(event, this.myRange.getStartOffset(), this.myRange.getEndOffset(), this.myGreedyLeft, this.myGreedyRight);
        return range == null ? null : new Pair<ProperTextRange, Object>(range, null);
    }

    public void applyState(@Nullable ManualRangeMarker updated) {
        if (updated == null || !updated.myValid) {
            this.myValid = false;
        }
        if (!this.myValid) {
            return;
        }
        this.myRange = updated.myRange;
        this.myLinesCols = updated.myLinesCols;
    }

    public boolean isGreedyLeft() {
        return this.myGreedyLeft;
    }

    public boolean isGreedyRight() {
        return this.myGreedyRight;
    }

    public boolean isSurviveOnExternalChange() {
        return this.myLinesCols != null;
    }

    @Nullable
    public ProperTextRange getRange() {
        return this.myValid ? this.myRange : null;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public String toString() {
        return "ManualRangeMarker" + (this.myValid ? this.myRange.toString() : " invalid");
    }

    public int hashCode() {
        return this.myHash;
    }
}

